/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.FontResourcesParser;
import android.graphics.Typeface;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class Typeface_Delegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromDisk(BridgeContext context, String path, boolean isFramework) {
        Typeface typeface = Typeface.findFromCache(context.getAssets(), path);
        if (typeface != null) {
            return typeface;
        }
        if (path.isBlank()) {
            return null;
        }
        String lowerCaseValue = path.toLowerCase();
        if (lowerCaseValue.endsWith(".xml")) {
            XmlPullParser parser = context.getLayoutlibCallback().createXmlParserForPsiFile(path);
            if (parser != null) {
                BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser(parser, context, ResourceNamespace.fromBoolean((boolean)isFramework));
                try {
                    FontResourcesParser.FamilyResourceEntry entry = FontResourcesParser.parse(blockParser, context.getResources());
                    typeface = Typeface.createFromResources(entry, context.getAssets(), path);
                }
                catch (IOException | XmlPullParserException e) {
                    Bridge.getLog().error(null, "Failed to parse file " + path, e, null, null);
                }
                finally {
                    blockParser.ensurePopped();
                }
            } else {
                Bridge.getLog().error("broken", String.format("File %s does not exist (or is not a file)", path), null, null);
            }
        } else {
            typeface = new Typeface.Builder(context.getAssets(), path, false, 0).build();
        }
        return typeface;
    }

    @LayoutlibDelegate
    static Typeface create(String familyName, int style2) {
        if (familyName != null && Files.exists(Paths.get(familyName, new String[0]), new LinkOption[0])) {
            return Typeface_Delegate.createFromDisk(RenderAction.getCurrentContext(), familyName, false);
        }
        return Typeface.create_Original(familyName, style2);
    }

    @LayoutlibDelegate
    static Typeface create(Typeface family, int style2) {
        return Typeface.create_Original(family, style2);
    }

    @LayoutlibDelegate
    static Typeface create(Typeface family, int style2, boolean isItalic) {
        return Typeface.create_Original(family, style2, isItalic);
    }
}

