/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.Resources_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class AdaptiveIconDrawable_Delegate {
    public static String sPath;

    public static String getResourceString(Resources res, int resId) {
        if (resId == 17039954) {
            return sPath;
        }
        return res.getString(resId);
    }

    @LayoutlibDelegate
    public static void draw(AdaptiveIconDrawable thisDrawable, Canvas canvas) {
        Resources res = Resources.getSystem();
        BridgeContext context = Resources_Delegate.getContext(res);
        if (context.useThemedIcon() && thisDrawable.getMonochrome() != null) {
            AdaptiveIconDrawable themedIcon = AdaptiveIconDrawable_Delegate.createThemedVersionFromMonochrome(thisDrawable.getMonochrome(), res);
            themedIcon.onBoundsChange(thisDrawable.getBounds());
            themedIcon.draw_Original(canvas);
        } else {
            thisDrawable.draw_Original(canvas);
        }
    }

    private static AdaptiveIconDrawable createThemedVersionFromMonochrome(Drawable mono, Resources resources) {
        mono = mono.mutate();
        int[] colors = AdaptiveIconDrawable_Delegate.getColors(resources);
        mono.setTint(colors[1]);
        return new AdaptiveIconDrawable(new ColorDrawable(colors[0]), mono);
    }

    private static int[] getColors(Resources resources) {
        int[] colors = new int[2];
        if (resources.getConfiguration().isNightModeActive()) {
            colors[0] = resources.getColor(17170471, null);
            colors[1] = resources.getColor(17170490, null);
        } else {
            colors[0] = resources.getColor(17170490, null);
            colors[1] = resources.getColor(17170483, null);
        }
        return colors;
    }
}

