/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseLongArray;
import android.util.SparseIntArray;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedStateListDrawable
extends StateListDrawable {
    private static final String LOGTAG = AnimatedStateListDrawable.class.getSimpleName();
    private static final String ELEMENT_TRANSITION = "transition";
    private static final String ELEMENT_ITEM = "item";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private AnimatedStateListState mState;
    private Transition mTransition;
    private int mTransitionToIndex = -1;
    private int mTransitionFromIndex = -1;
    private boolean mMutated;

    public AnimatedStateListDrawable() {
        this(null, null);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    public void addState(int[] stateSet, Drawable drawable2, int id2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable must not be null");
        }
        this.mState.addStateSet(stateSet, drawable2, id2);
        this.onStateChange(this.getState());
    }

    public <T extends Drawable> void addTransition(int fromId, int toId, T transition2, boolean reversible) {
        if (transition2 == null) {
            throw new IllegalArgumentException("Transition drawable must not be null");
        }
        this.mState.addTransition(fromId, toId, transition2, reversible);
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        int targetIndex = this.mState.indexOfKeyframe(stateSet);
        boolean changed = targetIndex != this.getCurrentIndex() && (this.selectTransition(targetIndex) || this.selectDrawable(targetIndex));
        Drawable current = this.getCurrent();
        if (current != null) {
            changed |= current.setState(stateSet);
        }
        return changed;
    }

    private boolean selectTransition(int toIndex) {
        Transition transition2;
        int fromIndex;
        Transition currentTransition = this.mTransition;
        if (currentTransition != null) {
            if (toIndex == this.mTransitionToIndex) {
                return true;
            }
            if (toIndex == this.mTransitionFromIndex && currentTransition.canReverse()) {
                currentTransition.reverse();
                this.mTransitionToIndex = this.mTransitionFromIndex;
                this.mTransitionFromIndex = toIndex;
                return true;
            }
            fromIndex = this.mTransitionToIndex;
            currentTransition.stop();
        } else {
            fromIndex = this.getCurrentIndex();
        }
        this.mTransition = null;
        this.mTransitionFromIndex = -1;
        this.mTransitionToIndex = -1;
        AnimatedStateListState state = this.mState;
        int fromId = state.getKeyframeIdAt(fromIndex);
        int toId = state.getKeyframeIdAt(toIndex);
        if (toId == 0 || fromId == 0) {
            return false;
        }
        int transitionIndex = state.indexOfTransition(fromId, toId);
        if (transitionIndex < 0) {
            return false;
        }
        boolean hasReversibleFlag = state.transitionHasReversibleFlag(fromId, toId);
        this.selectDrawable(transitionIndex);
        Drawable d = this.getCurrent();
        if (d instanceof AnimationDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimationDrawableTransition((AnimationDrawable)d, reversed, hasReversibleFlag);
        } else if (d instanceof AnimatedVectorDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimatedVectorDrawableTransition((AnimatedVectorDrawable)d, reversed, hasReversibleFlag);
        } else if (d instanceof Animatable) {
            transition2 = new AnimatableTransition((Animatable)((Object)d));
        } else {
            return false;
        }
        transition2.start();
        this.mTransition = transition2;
        this.mTransitionFromIndex = fromIndex;
        this.mTransitionToIndex = toIndex;
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.stop();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToIndex);
            this.mTransitionToIndex = -1;
            this.mTransitionFromIndex = -1;
        }
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.updateStateFromTypedArray(a);
        this.updateDensity(r);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.init();
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        AnimatedStateListState state = this.mState;
        if (state == null || state.mAnimThemeAttrs == null) {
            return;
        }
        TypedArray a = theme.resolveAttributes(state.mAnimThemeAttrs, R.styleable.AnimatedRotateDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.init();
    }

    private void updateStateFromTypedArray(TypedArray a) {
        AnimatedStateListState state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mAnimThemeAttrs = a.extractThemeAttrs();
        state.setVariablePadding(a.getBoolean(2, state.mVariablePadding));
        state.setConstantSize(a.getBoolean(3, state.mConstantSize));
        state.setEnterFadeDuration(a.getInt(4, state.mEnterFadeDuration));
        state.setExitFadeDuration(a.getInt(5, state.mExitFadeDuration));
        this.setDither(a.getBoolean(0, state.mDither));
        this.setAutoMirrored(a.getBoolean(6, state.mAutoMirrored));
    }

    private void init() {
        this.onStateChange(this.getState());
    }

    private void inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            if (parser.getName().equals(ELEMENT_ITEM)) {
                this.parseItem(r, parser, attrs, theme);
                continue;
            }
            if (!parser.getName().equals(ELEMENT_TRANSITION)) continue;
            this.parseTransition(r, parser, attrs, theme);
        }
    }

    private int parseTransition(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawableTransition);
        int fromId = a.getResourceId(2, 0);
        int toId = a.getResourceId(1, 0);
        boolean reversible = a.getBoolean(3, false);
        Drawable dr = a.getDrawable(0);
        a.recycle();
        if (dr == null) {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <transition> tag requires a 'drawable' attribute or child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        return this.mState.addTransition(fromId, toId, dr, reversible);
    }

    private int parseItem(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawableItem);
        int keyframeId = a.getResourceId(0, 0);
        Drawable dr = a.getDrawable(1);
        a.recycle();
        int[] states = this.extractStateSet(attrs);
        if (dr == null) {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        return this.mState.addStateSet(states, dr, keyframeId);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    AnimatedStateListState cloneConstantState() {
        return new AnimatedStateListState(this.mState, this, null);
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    protected void setConstantState(DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimatedStateListState) {
            this.mState = (AnimatedStateListState)state;
        }
    }

    private AnimatedStateListDrawable(AnimatedStateListState state, Resources res) {
        super(null);
        AnimatedStateListState newState = new AnimatedStateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
        this.jumpToCurrentState();
    }

    static class AnimatedStateListState
    extends StateListDrawable.StateListState {
        private static final long REVERSED_BIT = 0x100000000L;
        private static final long REVERSIBLE_FLAG_BIT = 0x200000000L;
        int[] mAnimThemeAttrs;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        LongSparseLongArray mTransitions;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        SparseIntArray mStateIds;

        AnimatedStateListState(AnimatedStateListState orig, AnimatedStateListDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mAnimThemeAttrs = orig.mAnimThemeAttrs;
                this.mTransitions = orig.mTransitions;
                this.mStateIds = orig.mStateIds;
            } else {
                this.mTransitions = new LongSparseLongArray();
                this.mStateIds = new SparseIntArray();
            }
        }

        @Override
        void mutate() {
            this.mTransitions = this.mTransitions.clone();
            this.mStateIds = this.mStateIds.clone();
        }

        int addTransition(int fromId, int toId, Drawable anim2, boolean reversible) {
            int pos = super.addChild(anim2);
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            long reversibleBit = 0L;
            if (reversible) {
                reversibleBit = 0x200000000L;
            }
            this.mTransitions.append(keyFromTo, (long)pos | reversibleBit);
            if (reversible) {
                long keyToFrom = AnimatedStateListState.generateTransitionKey(toId, fromId);
                this.mTransitions.append(keyToFrom, (long)pos | 0x100000000L | reversibleBit);
            }
            return pos;
        }

        int addStateSet(int[] stateSet, Drawable drawable2, int id2) {
            int index = super.addStateSet(stateSet, drawable2);
            this.mStateIds.put(index, id2);
            return index;
        }

        int indexOfKeyframe(int[] stateSet) {
            int index = super.indexOfStateSet(stateSet);
            if (index >= 0) {
                return index;
            }
            return super.indexOfStateSet(StateSet.WILD_CARD);
        }

        int getKeyframeIdAt(int index) {
            return index < 0 ? 0 : this.mStateIds.get(index, 0);
        }

        int indexOfTransition(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (int)this.mTransitions.get(keyFromTo, -1L);
        }

        boolean isTransitionReversed(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (this.mTransitions.get(keyFromTo, -1L) & 0x100000000L) != 0L;
        }

        boolean transitionHasReversibleFlag(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (this.mTransitions.get(keyFromTo, -1L) & 0x200000000L) != 0L;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mAnimThemeAttrs != null || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedStateListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimatedStateListDrawable(this, res);
        }

        private static long generateTransitionKey(int fromId, int toId) {
            return (long)fromId << 32 | (long)toId;
        }
    }

    private static abstract class Transition {
        private Transition() {
        }

        public abstract void start();

        public abstract void stop();

        public void reverse() {
        }

        public boolean canReverse() {
            return false;
        }
    }

    private static class AnimationDrawableTransition
    extends Transition {
        private final ObjectAnimator mAnim;
        private final boolean mHasReversibleFlag;

        public AnimationDrawableTransition(AnimationDrawable ad, boolean reversed, boolean hasReversibleFlag) {
            int frameCount = ad.getNumberOfFrames();
            int fromFrame = reversed ? frameCount - 1 : 0;
            int toFrame = reversed ? 0 : frameCount - 1;
            FrameInterpolator interp = new FrameInterpolator(ad, reversed);
            ObjectAnimator anim2 = ObjectAnimator.ofInt((Object)ad, "currentIndex", fromFrame, toFrame);
            anim2.setAutoCancel(true);
            anim2.setDuration(interp.getTotalDuration());
            anim2.setInterpolator(interp);
            this.mHasReversibleFlag = hasReversibleFlag;
            this.mAnim = anim2;
        }

        @Override
        public boolean canReverse() {
            return this.mHasReversibleFlag;
        }

        @Override
        public void start() {
            this.mAnim.start();
        }

        @Override
        public void reverse() {
            this.mAnim.reverse();
        }

        @Override
        public void stop() {
            this.mAnim.cancel();
        }
    }

    private static class AnimatedVectorDrawableTransition
    extends Transition {
        private final AnimatedVectorDrawable mAvd;
        private final boolean mReversed;
        private final boolean mHasReversibleFlag;

        public AnimatedVectorDrawableTransition(AnimatedVectorDrawable avd, boolean reversed, boolean hasReversibleFlag) {
            this.mAvd = avd;
            this.mReversed = reversed;
            this.mHasReversibleFlag = hasReversibleFlag;
        }

        @Override
        public boolean canReverse() {
            return this.mAvd.canReverse() && this.mHasReversibleFlag;
        }

        @Override
        public void start() {
            if (this.mReversed) {
                this.reverse();
            } else {
                this.mAvd.start();
            }
        }

        @Override
        public void reverse() {
            if (this.canReverse()) {
                this.mAvd.reverse();
            } else {
                Log.w(LOGTAG, "Can't reverse, either the reversible is set to false, or the AnimatedVectorDrawable can't reverse");
            }
        }

        @Override
        public void stop() {
            this.mAvd.stop();
        }
    }

    private static class AnimatableTransition
    extends Transition {
        private final Animatable mA;

        public AnimatableTransition(Animatable a) {
            this.mA = a;
        }

        @Override
        public void start() {
            this.mA.start();
        }

        @Override
        public void stop() {
            this.mA.stop();
        }
    }

    private static class FrameInterpolator
    implements TimeInterpolator {
        private int[] mFrameTimes;
        private int mFrames;
        private int mTotalDuration;

        public FrameInterpolator(AnimationDrawable d, boolean reversed) {
            this.updateFrames(d, reversed);
        }

        public int updateFrames(AnimationDrawable d, boolean reversed) {
            int N;
            this.mFrames = N = d.getNumberOfFrames();
            if (this.mFrameTimes == null || this.mFrameTimes.length < N) {
                this.mFrameTimes = new int[N];
            }
            int[] frameTimes = this.mFrameTimes;
            int totalDuration = 0;
            for (int i = 0; i < N; ++i) {
                int duration;
                frameTimes[i] = duration = d.getDuration(reversed ? N - i - 1 : i);
                totalDuration += duration;
            }
            this.mTotalDuration = totalDuration;
            return totalDuration;
        }

        public int getTotalDuration() {
            return this.mTotalDuration;
        }

        @Override
        public float getInterpolation(float input) {
            int i;
            int elapsed = (int)(input * (float)this.mTotalDuration + 0.5f);
            int N = this.mFrames;
            int[] frameTimes = this.mFrameTimes;
            int remaining = elapsed;
            for (i = 0; i < N && remaining >= frameTimes[i]; remaining -= frameTimes[i], ++i) {
            }
            float frameElapsed = i < N ? (float)remaining / (float)this.mTotalDuration : 0.0f;
            return (float)i / (float)N + frameElapsed;
        }
    }
}

