/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.fonts.FontFileUtil;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.graphics.fonts.Font_Builder_Delegate;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.TypedValue;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import libcore.util.NativeAllocationRegistry;

public final class Font {
    private static String TAG = "Font";
    private static int NOT_SPECIFIED = -1;
    private static int STYLE_ITALIC = 1;
    private static int STYLE_NORMAL = 0;
    private static NativeAllocationRegistry BUFFER_REGISTRY;
    private static NativeAllocationRegistry FONT_REGISTRY;
    private final long mNativePtr;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ByteBuffer mBuffer = null;
    @GuardedBy(value={"mLock"})
    private boolean mIsFileInitialized = false;
    @GuardedBy(value={"mLock"})
    private File mFile = null;
    @GuardedBy(value={"mLock"})
    private FontStyle mFontStyle = null;
    @GuardedBy(value={"mLock"})
    private FontVariationAxis[] mAxes = null;
    @GuardedBy(value={"mLock"})
    private LocaleList mLocaleList = null;

    public Font(long nativePtr) {
        this.mNativePtr = nativePtr;
        FONT_REGISTRY.registerNativeAllocation(this, this.mNativePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuffer() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBuffer == null) {
                long ref = Font.nCloneFont(this.mNativePtr);
                ByteBuffer fromNative = Font.nNewByteBuffer(this.mNativePtr);
                BUFFER_REGISTRY.registerNativeAllocation(fromNative, ref);
                this.mBuffer = fromNative.asReadOnlyBuffer();
            }
            return this.mBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsFileInitialized) {
                String path = Font.nGetFontPath(this.mNativePtr);
                if (!TextUtils.isEmpty(path)) {
                    this.mFile = new File(path);
                }
                this.mIsFileInitialized = true;
            }
            return this.mFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontStyle getStyle() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFontStyle == null) {
                int packedStyle = Font.nGetPackedStyle(this.mNativePtr);
                this.mFontStyle = new FontStyle(FontFileUtil.unpackWeight(packedStyle), FontFileUtil.unpackItalic(packedStyle) ? 1 : 0);
            }
            return this.mFontStyle;
        }
    }

    public int getTtcIndex() {
        return Font.nGetIndex(this.mNativePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontVariationAxis[] getAxes() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAxes == null) {
                int axisCount = Font.nGetAxisCount(this.mNativePtr);
                this.mAxes = new FontVariationAxis[axisCount];
                char[] charBuffer = new char[4];
                for (int i = 0; i < axisCount; ++i) {
                    long packedAxis = Font.nGetAxisInfo(this.mNativePtr, i);
                    float value = Float.intBitsToFloat((int)(packedAxis & 0xFFFFFFFFL));
                    charBuffer[0] = (char)((packedAxis & 0xFF00000000000000L) >>> 56);
                    charBuffer[1] = (char)((packedAxis & 0xFF000000000000L) >>> 48);
                    charBuffer[2] = (char)((packedAxis & 0xFF0000000000L) >>> 40);
                    charBuffer[3] = (char)((packedAxis & 0xFF00000000L) >>> 32);
                    this.mAxes[i] = new FontVariationAxis(new String(charBuffer), value);
                }
            }
        }
        return this.mAxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocaleList getLocaleList() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLocaleList == null) {
                String langTags = Font.nGetLocaleList(this.mNativePtr);
                this.mLocaleList = TextUtils.isEmpty(langTags) ? LocaleList.getEmptyLocaleList() : LocaleList.forLanguageTags(langTags);
            }
            return this.mLocaleList;
        }
    }

    public float getGlyphBounds(int glyphId, Paint paint, RectF outBoundingBox) {
        return Font.nGetGlyphBounds(this.mNativePtr, glyphId, paint.getNativeInstance(), outBoundingBox);
    }

    public void getMetrics(Paint paint, Paint.FontMetrics outMetrics) {
        Font.nGetFontMetrics(this.mNativePtr, paint.getNativeInstance(), outMetrics);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public int getSourceIdentifier() {
        return Font.nGetSourceId(this.mNativePtr);
    }

    private boolean isSameSource(Font other) {
        Objects.requireNonNull(other);
        ByteBuffer myBuffer = this.getBuffer();
        ByteBuffer otherBuffer = other.getBuffer();
        if (myBuffer == otherBuffer) {
            return true;
        }
        if (myBuffer.capacity() != otherBuffer.capacity()) {
            return false;
        }
        if (this.getSourceIdentifier() == other.getSourceIdentifier() && myBuffer.position() == otherBuffer.position()) {
            return true;
        }
        return myBuffer.equals(otherBuffer);
    }

    public boolean paramEquals(Font f) {
        return f.getStyle().equals(this.getStyle()) && f.getTtcIndex() == this.getTtcIndex() && Arrays.equals(f.getAxes(), this.getAxes()) && Objects.equals(f.getLocaleList(), this.getLocaleList()) && Objects.equals(this.getFile(), f.getFile());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Font)) {
            return false;
        }
        Font f = (Font)o;
        if (Font.nGetMinikinFontPtr(this.mNativePtr) == Font.nGetMinikinFontPtr(f.mNativePtr)) {
            return true;
        }
        if (!this.paramEquals(f)) {
            return false;
        }
        return this.isSameSource(f);
    }

    public int hashCode() {
        return Objects.hash(this.getStyle(), this.getTtcIndex(), Arrays.hashCode(this.getAxes()), this.getLocaleList());
    }

    public String toString() {
        return "Font {path=" + this.getFile() + ", style=" + this.getStyle() + ", ttcIndex=" + this.getTtcIndex() + ", axes=" + FontVariationAxis.toFontVariationSettings(this.getAxes()) + ", localeList=" + this.getLocaleList() + ", buffer=" + this.getBuffer() + "}";
    }

    public static Set<Font> getAvailableFonts() {
        IdentityHashMap<Font, Font> map = new IdentityHashMap<Font, Font>();
        for (long nativePtr : Font.nGetAvailableFontSet()) {
            Font font = new Font(nativePtr);
            map.put(font, font);
        }
        return Collections.unmodifiableSet(map.keySet());
    }

    @CriticalNative
    private static native long nGetMinikinFontPtr(long var0);

    @CriticalNative
    private static native long nCloneFont(long var0);

    @FastNative
    private static native ByteBuffer nNewByteBuffer(long var0);

    @CriticalNative
    private static native long nGetBufferAddress(long var0);

    @CriticalNative
    private static native int nGetSourceId(long var0);

    @CriticalNative
    private static native long nGetReleaseNativeFont();

    @FastNative
    private static native float nGetGlyphBounds(long var0, int var2, long var3, RectF var5);

    @FastNative
    private static native float nGetFontMetrics(long var0, long var2, Paint.FontMetrics var4);

    @FastNative
    private static native String nGetFontPath(long var0);

    @FastNative
    private static native String nGetLocaleList(long var0);

    @CriticalNative
    private static native int nGetPackedStyle(long var0);

    @CriticalNative
    private static native int nGetIndex(long var0);

    @CriticalNative
    private static native int nGetAxisCount(long var0);

    @CriticalNative
    private static native long nGetAxisInfo(long var0, int var2);

    @FastNative
    private static native long[] nGetAvailableFontSet();

    public static void deferredStaticInitializer() {
        BUFFER_REGISTRY = NativeAllocationRegistry.createMalloced(ByteBuffer.class.getClassLoader(), Font.nGetReleaseNativeFont());
        FONT_REGISTRY = NativeAllocationRegistry.createMalloced(Font.class.getClassLoader(), Font.nGetReleaseNativeFont());
    }

    public static final class Builder {
        private ByteBuffer mBuffer;
        private File mFile;
        private Font mFont;
        private String mLocaleList = "";
        private int mWeight = -1;
        private int mItalic = -1;
        private int mTtcIndex = 0;
        private FontVariationAxis[] mAxes = null;
        private IOException mException;

        public Builder(ByteBuffer buffer) {
            Preconditions.checkNotNull(buffer, "buffer can not be null");
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("Only direct buffer can be used as the source of font data.");
            }
            this.mBuffer = buffer;
        }

        public Builder(ByteBuffer buffer, File path, String localeList) {
            this(buffer);
            this.mFile = path;
            this.mLocaleList = localeList;
        }

        public Builder(File path, String localeList) {
            this(path);
            this.mLocaleList = localeList;
        }

        public Builder(File path) {
            Preconditions.checkNotNull(path, "path can not be null");
            try (FileInputStream fis = new FileInputStream(path);){
                FileChannel fc = fis.getChannel();
                this.mBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            }
            catch (IOException e) {
                this.mException = e;
            }
            this.mFile = path;
        }

        public Builder(ParcelFileDescriptor fd) {
            this(fd, 0L, -1L);
        }

        public Builder(ParcelFileDescriptor fd, long offset, long size) {
            try (FileInputStream fis = new FileInputStream(fd.getFileDescriptor());){
                FileChannel fc = fis.getChannel();
                size = size == -1L ? fc.size() - offset : size;
                this.mBuffer = fc.map(FileChannel.MapMode.READ_ONLY, offset, size);
            }
            catch (IOException e) {
                this.mException = e;
            }
        }

        public Builder(AssetManager am, String path) {
            try {
                this.mBuffer = Builder.createBuffer(am, path, true, -1);
            }
            catch (IOException e) {
                this.mException = e;
            }
        }

        public Builder(AssetManager am, String path, boolean isAsset, int cookie) {
            try {
                this.mBuffer = Builder.createBuffer(am, path, isAsset, cookie);
            }
            catch (IOException e) {
                this.mException = e;
            }
        }

        public Builder(Resources res, int resId) {
            TypedValue value = new TypedValue();
            res.getValue(resId, value, true);
            if (value.string == null) {
                this.mException = new FileNotFoundException(resId + " not found");
                return;
            }
            String str = value.string.toString();
            if (str.toLowerCase().endsWith(".xml")) {
                this.mException = new FileNotFoundException(resId + " must be font file.");
                return;
            }
            try {
                this.mBuffer = Builder.createBuffer(res.getAssets(), str, false, value.assetCookie);
            }
            catch (IOException e) {
                this.mException = e;
            }
        }

        public Builder(Font font) {
            this.mFont = font;
            this.mBuffer = font.getBuffer();
            this.mWeight = font.getStyle().getWeight();
            this.mItalic = font.getStyle().getSlant();
            this.mAxes = font.getAxes();
            this.mFile = font.getFile();
            this.mTtcIndex = font.getTtcIndex();
        }

        public static ByteBuffer createBuffer_Original(AssetManager am, String path, boolean isAsset, int cookie) throws IOException {
            MappedByteBuffer mappedByteBuffer;
            block15: {
                Preconditions.checkNotNull(am, "assetManager can not be null");
                Preconditions.checkNotNull(path, "path can not be null");
                AssetFileDescriptor assetFD = isAsset ? am.openFd(path) : (cookie > 0 ? am.openNonAssetFd(cookie, path) : am.openNonAssetFd(path));
                FileInputStream fis2 = assetFD.createInputStream();
                try {
                    FileChannel fc = fis2.getChannel();
                    long startOffset = assetFD.getStartOffset();
                    long declaredLength = assetFD.getDeclaredLength();
                    mappedByteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
                    if (fis2 == null) break block15;
                }
                catch (Throwable fc) {
                    try {
                        if (fis2 != null) {
                            try {
                                fis2.close();
                            }
                            catch (Throwable startOffset) {
                                fc.addSuppressed(startOffset);
                            }
                        }
                        throw fc;
                    }
                    catch (IOException fis2) {
                        try (InputStream assetStream = isAsset ? am.open(path, 3) : am.openNonAsset(cookie, path, 3);){
                            int capacity = assetStream.available();
                            ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
                            buffer.order(ByteOrder.nativeOrder());
                            assetStream.read(buffer.array(), buffer.arrayOffset(), assetStream.available());
                            if (assetStream.read() != -1) {
                                throw new IOException("Unable to access full contents of " + path);
                            }
                            ByteBuffer byteBuffer = buffer;
                            return byteBuffer;
                        }
                    }
                }
                fis2.close();
            }
            return mappedByteBuffer;
        }

        @LayoutlibDelegate
        public static ByteBuffer createBuffer(AssetManager assetManager, String string2, boolean bl, int n) throws IOException {
            return Font_Builder_Delegate.createBuffer(assetManager, string2, bl, n);
        }

        public Builder setWeight(int weight) {
            Preconditions.checkArgument(1 <= weight && weight <= 1000);
            this.mWeight = weight;
            return this;
        }

        public Builder setSlant(int slant) {
            this.mItalic = slant == 0 ? 0 : 1;
            return this;
        }

        public Builder setTtcIndex(int ttcIndex) {
            this.mTtcIndex = ttcIndex;
            return this;
        }

        public Builder setFontVariationSettings(String variationSettings) {
            this.mAxes = FontVariationAxis.fromFontVariationSettings(variationSettings);
            return this;
        }

        public Builder setFontVariationSettings(FontVariationAxis[] axes) {
            this.mAxes = axes == null ? null : (FontVariationAxis[])axes.clone();
            return this;
        }

        public Font build() throws IOException {
            Font font;
            String filePath;
            if (this.mException != null) {
                throw new IOException("Failed to read font contents", this.mException);
            }
            if (this.mWeight == -1 || this.mItalic == -1) {
                int packed = FontFileUtil.analyzeStyle(this.mBuffer, this.mTtcIndex, this.mAxes);
                if (FontFileUtil.isSuccess(packed)) {
                    if (this.mWeight == -1) {
                        this.mWeight = FontFileUtil.unpackWeight(packed);
                    }
                    if (this.mItalic == -1) {
                        this.mItalic = FontFileUtil.unpackItalic(packed) ? 1 : 0;
                    }
                } else {
                    this.mWeight = 400;
                    this.mItalic = 0;
                }
            }
            this.mWeight = Math.max(1, Math.min(1000, this.mWeight));
            boolean italic = this.mItalic == 1;
            boolean slant = this.mItalic == 1;
            long builderPtr = Builder.nInitBuilder();
            if (this.mAxes != null) {
                for (FontVariationAxis axis : this.mAxes) {
                    Builder.nAddAxis(builderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            ByteBuffer readonlyBuffer = this.mBuffer.asReadOnlyBuffer();
            String string2 = filePath = this.mFile == null ? "" : this.mFile.getAbsolutePath();
            if (this.mFont == null) {
                long ptr = Builder.nBuild(builderPtr, readonlyBuffer, filePath, this.mLocaleList, this.mWeight, italic, this.mTtcIndex);
                font = new Font(ptr);
            } else {
                long ptr = Builder.nClone(this.mFont.getNativePtr(), builderPtr, this.mWeight, italic, this.mTtcIndex);
                font = new Font(ptr);
            }
            return font;
        }

        private static native long nInitBuilder();

        @CriticalNative
        private static native void nAddAxis(long var0, int var2, float var3);

        private static native long nBuild(long var0, ByteBuffer var2, String var3, String var4, int var5, boolean var6, int var7);

        @FastNative
        private static native long nClone(long var0, long var2, int var4, boolean var5, int var6);
    }
}

