/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.FontListParser;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.SystemFonts_Delegate;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class SystemFonts {
    private static final String TAG = "SystemFonts";
    private static final String FONTS_XML = "/system/etc/fonts.xml";
    public static final String SYSTEM_FONT_DIR = "/system/fonts/";
    private static final String OEM_XML = "/product/etc/fonts_customization.xml";
    public static final String OEM_FONT_DIR = "/product/fonts/";
    private static final Object LOCK = new Object();
    @GuardedBy(value={"sLock"})
    private static Set<Font> sAvailableFonts;

    private SystemFonts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Font> getAvailableFonts() {
        Object object = LOCK;
        synchronized (object) {
            if (sAvailableFonts == null) {
                sAvailableFonts = Font.getAvailableFonts();
            }
            return sAvailableFonts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAvailableFonts() {
        Object object = LOCK;
        synchronized (object) {
            sAvailableFonts = null;
        }
    }

    static ByteBuffer mmap_Original(String fullPath) {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream file = new FileInputStream(fullPath);
        try {
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        file.close();
        return mappedByteBuffer;
    }

    @LayoutlibDelegate
    private static ByteBuffer mmap(String string2) {
        return SystemFonts_Delegate.mmap(string2);
    }

    private static void pushFamilyToFallback(FontConfig.FontFamily xmlFamily, ArrayMap<String, NativeFamilyListSet> fallbackMap, Map<String, ByteBuffer> cache) {
        ArrayList fallback;
        String languageTags = xmlFamily.getLocaleList().toLanguageTags();
        int variant = xmlFamily.getVariant();
        ArrayList<FontConfig.Font> defaultFonts = new ArrayList<FontConfig.Font>();
        ArrayMap<String, ArrayList> specificFallbackFonts = new ArrayMap<String, ArrayList>();
        for (FontConfig.Font font : xmlFamily.getFonts()) {
            String fallbackName = font.getFontFamilyName();
            if (fallbackName == null) {
                defaultFonts.add(font);
                continue;
            }
            fallback = (ArrayList)specificFallbackFonts.get(fallbackName);
            if (fallback == null) {
                fallback = new ArrayList();
                specificFallbackFonts.put(fallbackName, fallback);
            }
            fallback.add(font);
        }
        FontFamily defaultFamily = defaultFonts.isEmpty() ? null : SystemFonts.createFontFamily(defaultFonts, languageTags, variant, false, cache);
        for (int i = 0; i < fallbackMap.size(); ++i) {
            String name = fallbackMap.keyAt(i);
            NativeFamilyListSet familyListSet = fallbackMap.valueAt(i);
            int identityHash = System.identityHashCode(xmlFamily);
            if (familyListSet.seenXmlFamilies.get(identityHash, -1) != -1) continue;
            familyListSet.seenXmlFamilies.append(identityHash, 1);
            fallback = (ArrayList)specificFallbackFonts.get(name);
            if (fallback == null) {
                if (defaultFamily == null) continue;
                familyListSet.familyList.add(defaultFamily);
                continue;
            }
            FontFamily family = SystemFonts.createFontFamily(fallback, languageTags, variant, false, cache);
            if (family != null) {
                familyListSet.familyList.add(family);
                continue;
            }
            if (defaultFamily == null) continue;
            familyListSet.familyList.add(defaultFamily);
        }
    }

    private static FontFamily createFontFamily(List<FontConfig.Font> fonts, String languageTags, int variant, boolean isDefaultFallback, Map<String, ByteBuffer> cache) {
        if (fonts.size() == 0) {
            return null;
        }
        FontFamily.Builder b = null;
        for (int i = 0; i < fonts.size(); ++i) {
            Font font;
            FontConfig.Font fontConfig = fonts.get(i);
            String fullPath = fontConfig.getFile().getAbsolutePath();
            ByteBuffer buffer = cache.get(fullPath);
            if (buffer == null) {
                if (cache.containsKey(fullPath)) continue;
                buffer = SystemFonts.mmap(fullPath);
                cache.put(fullPath, buffer);
                if (buffer == null) continue;
            }
            try {
                font = new Font.Builder(buffer, new File(fullPath), languageTags).setWeight(fontConfig.getStyle().getWeight()).setSlant(fontConfig.getStyle().getSlant()).setTtcIndex(fontConfig.getTtcIndex()).setFontVariationSettings(fontConfig.getFontVariationSettings()).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (b == null) {
                b = new FontFamily.Builder(font);
                continue;
            }
            b.addFont(font);
        }
        return b == null ? null : b.build(languageTags, variant, false, isDefaultFallback);
    }

    private static void appendNamedFamilyList(FontConfig.NamedFamilyList namedFamilyList, ArrayMap<String, ByteBuffer> bufferCache, ArrayMap<String, NativeFamilyListSet> fallbackListMap) {
        String familyName = namedFamilyList.getName();
        NativeFamilyListSet familyListSet = new NativeFamilyListSet();
        List<FontConfig.FontFamily> xmlFamilies = namedFamilyList.getFamilies();
        for (int i = 0; i < xmlFamilies.size(); ++i) {
            FontConfig.FontFamily xmlFamily = xmlFamilies.get(i);
            FontFamily family = SystemFonts.createFontFamily(xmlFamily.getFontList(), xmlFamily.getLocaleList().toLanguageTags(), xmlFamily.getVariant(), true, bufferCache);
            if (family == null) {
                return;
            }
            familyListSet.familyList.add(family);
            familyListSet.seenXmlFamilies.append(System.identityHashCode(xmlFamily), 1);
        }
        fallbackListMap.put(familyName, familyListSet);
    }

    public static FontConfig getSystemFontConfig(Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        return SystemFonts.getSystemFontConfigInternal(FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, updatableFontMap, lastModifiedDate, configVersion);
    }

    public static FontConfig getSystemPreinstalledFontConfig() {
        return SystemFonts.getSystemFontConfigInternal(FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, null, 0L, 0);
    }

    static FontConfig getSystemFontConfigInternal_Original(String fontsXml, String systemFontDir, String oemXml, String productFontDir, Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        try {
            return FontListParser.parse(fontsXml, systemFontDir, oemXml, productFontDir, updatableFontMap, lastModifiedDate, configVersion);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to open/read system font configurations.", e);
            return new FontConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0L, 0);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "Failed to parse the system font configuration.", e);
            return new FontConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0L, 0);
        }
    }

    @LayoutlibDelegate
    static FontConfig getSystemFontConfigInternal(String string2, String string3, String string4, String string5, Map<String, File> map, long l, int n) {
        return SystemFonts_Delegate.getSystemFontConfigInternal(string2, string3, string4, string5, map, l, n);
    }

    @VisibleForTesting
    public static Map<String, FontFamily[]> buildSystemFallback(FontConfig fontConfig) {
        return SystemFonts.buildSystemFallback(fontConfig, new ArrayMap<String, ByteBuffer>());
    }

    @VisibleForTesting
    public static Map<String, FontFamily[]> buildSystemFallback(FontConfig fontConfig, ArrayMap<String, ByteBuffer> outBufferCache) {
        ArrayMap<String, NativeFamilyListSet> fallbackListMap = new ArrayMap<String, NativeFamilyListSet>();
        List<FontConfig.NamedFamilyList> namedFamilies = fontConfig.getNamedFamilyLists();
        for (int i = 0; i < namedFamilies.size(); ++i) {
            FontConfig.NamedFamilyList namedFamilyList = namedFamilies.get(i);
            SystemFonts.appendNamedFamilyList(namedFamilyList, outBufferCache, fallbackListMap);
        }
        List<FontConfig.FontFamily> xmlFamilies = fontConfig.getFontFamilies();
        for (int i = 0; i < xmlFamilies.size(); ++i) {
            FontConfig.FontFamily xmlFamily = xmlFamilies.get(i);
            SystemFonts.pushFamilyToFallback(xmlFamily, fallbackListMap, outBufferCache);
        }
        ArrayMap<String, FontFamily[]> fallbackMap = new ArrayMap<String, FontFamily[]>();
        for (int i = 0; i < fallbackListMap.size(); ++i) {
            String fallbackName = fallbackListMap.keyAt(i);
            List<FontFamily> familyList = fallbackListMap.valueAt((int)i).familyList;
            fallbackMap.put(fallbackName, familyList.toArray(new FontFamily[0]));
        }
        return fallbackMap;
    }

    @VisibleForTesting
    public static Map<String, Typeface> buildSystemTypefaces(FontConfig fontConfig, Map<String, FontFamily[]> fallbackMap) {
        ArrayMap<String, Typeface> result = new ArrayMap<String, Typeface>();
        Typeface.initSystemDefaultTypefaces(fallbackMap, fontConfig.getAliases(), result);
        return result;
    }

    private static class NativeFamilyListSet {
        public List<FontFamily> familyList = new ArrayList<FontFamily>();
        public SparseIntArray seenXmlFamilies = new SparseIntArray();

        private NativeFamilyListSet() {
        }
    }
}

