/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.ISensorPrivacyListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISensorPrivacyManager
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.ISensorPrivacyManager";

    public boolean supportsSensorToggle(int var1, int var2) throws RemoteException;

    public void addSensorPrivacyListener(ISensorPrivacyListener var1) throws RemoteException;

    public void addToggleSensorPrivacyListener(ISensorPrivacyListener var1) throws RemoteException;

    public void removeSensorPrivacyListener(ISensorPrivacyListener var1) throws RemoteException;

    public void removeToggleSensorPrivacyListener(ISensorPrivacyListener var1) throws RemoteException;

    public boolean isSensorPrivacyEnabled() throws RemoteException;

    public boolean isCombinedToggleSensorPrivacyEnabled(int var1) throws RemoteException;

    public boolean isToggleSensorPrivacyEnabled(int var1, int var2) throws RemoteException;

    public void setSensorPrivacy(boolean var1) throws RemoteException;

    public void setToggleSensorPrivacy(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void setToggleSensorPrivacyForProfileGroup(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void suppressToggleSensorPrivacyReminders(int var1, int var2, IBinder var3, boolean var4) throws RemoteException;

    public boolean requiresAuthentication() throws RemoteException;

    public void showSensorUseDialog(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISensorPrivacyManager {
        static final int TRANSACTION_supportsSensorToggle = 1;
        static final int TRANSACTION_addSensorPrivacyListener = 2;
        static final int TRANSACTION_addToggleSensorPrivacyListener = 3;
        static final int TRANSACTION_removeSensorPrivacyListener = 4;
        static final int TRANSACTION_removeToggleSensorPrivacyListener = 5;
        static final int TRANSACTION_isSensorPrivacyEnabled = 6;
        static final int TRANSACTION_isCombinedToggleSensorPrivacyEnabled = 7;
        static final int TRANSACTION_isToggleSensorPrivacyEnabled = 8;
        static final int TRANSACTION_setSensorPrivacy = 9;
        static final int TRANSACTION_setToggleSensorPrivacy = 10;
        static final int TRANSACTION_setToggleSensorPrivacyForProfileGroup = 11;
        static final int TRANSACTION_suppressToggleSensorPrivacyReminders = 12;
        static final int TRANSACTION_requiresAuthentication = 13;
        static final int TRANSACTION_showSensorUseDialog = 14;

        public Stub() {
            this.attachInterface(this, ISensorPrivacyManager.DESCRIPTOR);
        }

        public static ISensorPrivacyManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISensorPrivacyManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISensorPrivacyManager) {
                return (ISensorPrivacyManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "supportsSensorToggle";
                }
                case 2: {
                    return "addSensorPrivacyListener";
                }
                case 3: {
                    return "addToggleSensorPrivacyListener";
                }
                case 4: {
                    return "removeSensorPrivacyListener";
                }
                case 5: {
                    return "removeToggleSensorPrivacyListener";
                }
                case 6: {
                    return "isSensorPrivacyEnabled";
                }
                case 7: {
                    return "isCombinedToggleSensorPrivacyEnabled";
                }
                case 8: {
                    return "isToggleSensorPrivacyEnabled";
                }
                case 9: {
                    return "setSensorPrivacy";
                }
                case 10: {
                    return "setToggleSensorPrivacy";
                }
                case 11: {
                    return "setToggleSensorPrivacyForProfileGroup";
                }
                case 12: {
                    return "suppressToggleSensorPrivacyReminders";
                }
                case 13: {
                    return "requiresAuthentication";
                }
                case 14: {
                    return "showSensorUseDialog";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISensorPrivacyManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.supportsSensorToggle(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    ISensorPrivacyListener _arg0 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addSensorPrivacyListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ISensorPrivacyListener _arg0 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addToggleSensorPrivacyListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ISensorPrivacyListener _arg0 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeSensorPrivacyListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ISensorPrivacyListener _arg0 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeToggleSensorPrivacyListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    boolean _result = this.isSensorPrivacyEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isCombinedToggleSensorPrivacyEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isToggleSensorPrivacyEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSensorPrivacy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setToggleSensorPrivacy(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setToggleSensorPrivacyForProfileGroup(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.suppressToggleSensorPrivacyReminders(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _result = this.requiresAuthentication();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showSensorUseDialog(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements ISensorPrivacyManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISensorPrivacyManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsSensorToggle(int toggleType, int sensor) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(toggleType);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addToggleSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeToggleSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSensorPrivacyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCombinedToggleSensorPrivacyEnabled(int sensor) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isToggleSensorPrivacyEnabled(int toggleType, int sensor) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(toggleType);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSensorPrivacy(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setToggleSensorPrivacy(int userId, int source, int sensor, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(source);
                    _data.writeInt(sensor);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setToggleSensorPrivacyForProfileGroup(int userId, int source, int sensor, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(source);
                    _data.writeInt(sensor);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressToggleSensorPrivacyReminders(int userId, int sensor, IBinder token, boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(sensor);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(suppress);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requiresAuthentication() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showSensorUseDialog(int sensor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISensorPrivacyManager {
        @Override
        public boolean supportsSensorToggle(int toggleType, int sensor) throws RemoteException {
            return false;
        }

        @Override
        public void addSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
        }

        @Override
        public void addToggleSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
        }

        @Override
        public void removeSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
        }

        @Override
        public void removeToggleSensorPrivacyListener(ISensorPrivacyListener listener) throws RemoteException {
        }

        @Override
        public boolean isSensorPrivacyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isCombinedToggleSensorPrivacyEnabled(int sensor) throws RemoteException {
            return false;
        }

        @Override
        public boolean isToggleSensorPrivacyEnabled(int toggleType, int sensor) throws RemoteException {
            return false;
        }

        @Override
        public void setSensorPrivacy(boolean enable) throws RemoteException {
        }

        @Override
        public void setToggleSensorPrivacy(int userId, int source, int sensor, boolean enable) throws RemoteException {
        }

        @Override
        public void setToggleSensorPrivacyForProfileGroup(int userId, int source, int sensor, boolean enable) throws RemoteException {
        }

        @Override
        public void suppressToggleSensorPrivacyReminders(int userId, int sensor, IBinder token, boolean suppress) throws RemoteException {
        }

        @Override
        public boolean requiresAuthentication() throws RemoteException {
            return false;
        }

        @Override
        public void showSensorUseDialog(int sensor) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

