/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.ISensorPrivacyListener;
import android.hardware.ISensorPrivacyManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SensorPrivacyManager {
    private static final String LOG_TAG = SensorPrivacyManager.class.getSimpleName();
    private IBinder token = new Binder();
    public static final String EXTRA_SENSOR = SensorPrivacyManager.class.getName() + ".extra.sensor";
    public static final String EXTRA_ALL_SENSORS = SensorPrivacyManager.class.getName() + ".extra.all_sensors";
    public static final String EXTRA_TOGGLE_TYPE = SensorPrivacyManager.class.getName() + ".extra.toggle_type";
    public static final int TOGGLE_TYPE_SOFTWARE = 1;
    public static final int TOGGLE_TYPE_HARDWARE = 2;
    private static final Object sInstanceLock = new Object();
    private final Object mLock = new Object();
    @GuardedBy(value={"sInstanceLock"})
    private static SensorPrivacyManager sInstance;
    private final Context mContext;
    private final ISensorPrivacyManager mService;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Pair<Integer, Integer>, Boolean> mToggleSupportCache = new ArrayMap();
    private final ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> mListeners;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<OnSensorPrivacyChangedListener, Executor> mToggleListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Pair<Integer, OnSensorPrivacyChangedListener>, OnSensorPrivacyChangedListener> mLegacyToggleListeners = new ArrayMap();
    private final ISensorPrivacyListener mIToggleListener = new ISensorPrivacyListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSensorPrivacyChanged(int toggleType, int sensor, boolean enabled) {
            Object object = SensorPrivacyManager.this.mLock;
            synchronized (object) {
                for (int i = 0; i < SensorPrivacyManager.this.mToggleListeners.size(); ++i) {
                    OnSensorPrivacyChangedListener listener = SensorPrivacyManager.this.mToggleListeners.keyAt(i);
                    SensorPrivacyManager.this.mToggleListeners.valueAt(i).execute(() -> listener.onSensorPrivacyChanged(new OnSensorPrivacyChangedListener.SensorPrivacyChangedParams(toggleType, sensor, enabled)));
                }
            }
        }
    };
    @GuardedBy(value={"mLock"})
    private boolean mToggleListenerRegistered = false;
    private Boolean mRequiresAuthentication = null;

    private SensorPrivacyManager(Context context, ISensorPrivacyManager service) {
        this.mContext = context;
        this.mService = service;
        this.mListeners = new ArrayMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SensorPrivacyManager getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                try {
                    IBinder b = ServiceManager.getServiceOrThrow("sensor_privacy");
                    ISensorPrivacyManager service = ISensorPrivacyManager.Stub.asInterface(b);
                    sInstance = new SensorPrivacyManager(context, service);
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SensorPrivacyManager getInstance(Context context, ISensorPrivacyManager service) {
        Object object = sInstanceLock;
        synchronized (object) {
            sInstance = new SensorPrivacyManager(context, service);
            return sInstance;
        }
    }

    public boolean supportsSensorToggle(int sensor) {
        return this.supportsSensorToggle(1, sensor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSensorToggle(int toggleType, int sensor) {
        try {
            Pair<Integer, Integer> key = new Pair<Integer, Integer>(toggleType, sensor);
            Object object = this.mLock;
            synchronized (object) {
                Boolean val = this.mToggleSupportCache.get(key);
                if (val == null) {
                    val = this.mService.supportsSensorToggle(toggleType, sensor);
                    this.mToggleSupportCache.put(key, val);
                }
                return val;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(int sensor, OnSensorPrivacyChangedListener listener) {
        this.addSensorPrivacyListener(sensor, this.mContext.getMainExecutor(), listener);
    }

    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(int sensor, int userId, OnSensorPrivacyChangedListener listener) {
        this.addSensorPrivacyListener(sensor, this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(final int sensor, Executor executor, final OnSensorPrivacyChangedListener listener) {
        Pair<Integer, OnSensorPrivacyChangedListener> pair = new Pair<Integer, OnSensorPrivacyChangedListener>(sensor, listener);
        OnSensorPrivacyChangedListener toggleListener = new OnSensorPrivacyChangedListener(){

            @Override
            public void onSensorPrivacyChanged(OnSensorPrivacyChangedListener.SensorPrivacyChangedParams params) {
                if (params.getSensor() == sensor) {
                    listener.onSensorPrivacyChanged(params);
                }
            }

            @Override
            public void onSensorPrivacyChanged(int sensor2, boolean enabled) {
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            this.mLegacyToggleListeners.put(pair, toggleListener);
            this.addSensorPrivacyListenerLocked(executor, toggleListener);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(OnSensorPrivacyChangedListener listener) {
        this.addSensorPrivacyListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(Executor executor, OnSensorPrivacyChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.addSensorPrivacyListenerLocked(executor, listener);
        }
    }

    @GuardedBy(value={"mLock"})
    private void addSensorPrivacyListenerLocked(Executor executor, OnSensorPrivacyChangedListener listener) {
        if (!this.mToggleListenerRegistered) {
            try {
                this.mService.addToggleSensorPrivacyListener(this.mIToggleListener);
                this.mToggleListenerRegistered = true;
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        if (this.mToggleListeners.containsKey(listener)) {
            throw new IllegalArgumentException("listener is already registered");
        }
        this.mToggleListeners.put(listener, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void removeSensorPrivacyListener(int sensor, OnSensorPrivacyChangedListener listener) {
        Pair<Integer, OnSensorPrivacyChangedListener> pair = new Pair<Integer, OnSensorPrivacyChangedListener>(sensor, listener);
        Object object = this.mLock;
        synchronized (object) {
            OnSensorPrivacyChangedListener onToggleSensorPrivacyChangedListener = this.mLegacyToggleListeners.remove(pair);
            if (onToggleSensorPrivacyChangedListener != null) {
                this.removeSensorPrivacyListenerLocked(onToggleSensorPrivacyChangedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void removeSensorPrivacyListener(OnSensorPrivacyChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeSensorPrivacyListenerLocked(listener);
        }
    }

    @GuardedBy(value={"mLock"})
    private void removeSensorPrivacyListenerLocked(OnSensorPrivacyChangedListener listener) {
        this.mToggleListeners.remove(listener);
        if (this.mToggleListeners.size() == 0) {
            try {
                this.mService.removeToggleSensorPrivacyListener(this.mIToggleListener);
                this.mToggleListenerRegistered = false;
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean isSensorPrivacyEnabled(int sensor) {
        return this.isSensorPrivacyEnabled(1, sensor);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean isSensorPrivacyEnabled(int toggleType, int sensor) {
        try {
            return this.mService.isToggleSensorPrivacyEnabled(toggleType, sensor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean areAnySensorPrivacyTogglesEnabled(int sensor) {
        try {
            return this.mService.isCombinedToggleSensorPrivacyEnabled(sensor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacy(int sensor, boolean enable) {
        this.setSensorPrivacy(this.resolveSourceFromCurrentContext(), sensor, enable, -2);
    }

    private int resolveSourceFromCurrentContext() {
        String packageName = this.mContext.getOpPackageName();
        if (Objects.equals(packageName, this.mContext.getPackageManager().getPermissionControllerPackageName())) {
            return 6;
        }
        return 5;
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacy(int source, int sensor, boolean enable) {
        this.setSensorPrivacy(source, sensor, enable, -2);
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacy(int source, int sensor, boolean enable, int userId) {
        try {
            this.mService.setToggleSensorPrivacy(userId, source, sensor, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacyForProfileGroup(int source, int sensor, boolean enable) {
        this.setSensorPrivacyForProfileGroup(source, sensor, enable, -2);
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacyForProfileGroup(int source, int sensor, boolean enable, int userId) {
        try {
            this.mService.setToggleSensorPrivacyForProfileGroup(userId, source, sensor, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void suppressSensorPrivacyReminders(int sensor, boolean suppress) {
        this.suppressSensorPrivacyReminders(sensor, suppress, -2);
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void suppressSensorPrivacyReminders(int sensor, boolean suppress, int userId) {
        try {
            this.mService.suppressToggleSensorPrivacyReminders(userId, sensor, this.token, suppress);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean requiresAuthentication() {
        if (this.mRequiresAuthentication == null) {
            try {
                this.mRequiresAuthentication = this.mService.requiresAuthentication();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mRequiresAuthentication;
    }

    public void showSensorUseDialog(int sensor) {
        try {
            this.mService.showSensorUseDialog(sensor);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Received exception while trying to show sensor use dialog", e);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setAllSensorPrivacy(boolean enable) {
        try {
            this.mService.setSensorPrivacy(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addAllSensorPrivacyListener(final OnAllSensorPrivacyChangedListener listener) {
        ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mListeners.get(listener);
            if (iListener == null) {
                iListener = new ISensorPrivacyListener.Stub(){

                    @Override
                    public void onSensorPrivacyChanged(int toggleType, int sensor, boolean enabled) {
                        listener.onAllSensorPrivacyChanged(enabled);
                    }
                };
                this.mListeners.put(listener, iListener);
            }
            try {
                this.mService.addSensorPrivacyListener(iListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void removeAllSensorPrivacyListener(OnAllSensorPrivacyChangedListener listener) {
        ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mListeners.get(listener);
            if (iListener != null) {
                this.mListeners.remove(iListener);
                try {
                    this.mService.removeSensorPrivacyListener(iListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean isAllSensorPrivacyEnabled() {
        try {
            return this.mService.isSensorPrivacyEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static interface OnSensorPrivacyChangedListener {
        default public void onSensorPrivacyChanged(SensorPrivacyChangedParams params) {
            this.onSensorPrivacyChanged(params.mSensor, params.mEnabled);
        }

        @Deprecated
        public void onSensorPrivacyChanged(int var1, boolean var2);

        public static class SensorPrivacyChangedParams {
            private int mToggleType;
            private int mSensor;
            private boolean mEnabled;

            private SensorPrivacyChangedParams(int toggleType, int sensor, boolean enabled) {
                this.mToggleType = toggleType;
                this.mSensor = sensor;
                this.mEnabled = enabled;
            }

            public int getToggleType() {
                return this.mToggleType;
            }

            public int getSensor() {
                return this.mSensor;
            }

            public boolean isEnabled() {
                return this.mEnabled;
            }
        }
    }

    public static class Sources {
        public static final int QS_TILE = 1;
        public static final int SETTINGS = 2;
        public static final int DIALOG = 3;
        public static final int SHELL = 4;
        public static final int OTHER = 5;
        public static final int SAFETY_CENTER = 6;

        private Sources() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Source {
        }
    }

    public static interface OnAllSensorPrivacyChangedListener {
        public void onAllSensorPrivacyChanged(boolean var1);
    }

    public static class StateTypes {
        public static final int ENABLED = 1;
        public static final int DISABLED = 2;

        private StateTypes() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StateType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ToggleType {
    }

    public static class Sensors {
        public static final int MICROPHONE = 1;
        public static final int CAMERA = 2;

        private Sensors() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Sensor {
        }
    }
}

