/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.time.Duration;
import libcore.util.NativeAllocationRegistry;

public class SyncFence
implements AutoCloseable,
Parcelable {
    public static final long SIGNAL_TIME_INVALID = -1L;
    public static final long SIGNAL_TIME_PENDING = Long.MAX_VALUE;
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createNonmalloced(SyncFence.class.getClassLoader(), SyncFence.nGetDestructor(), 4L);
    private long mNativePtr;
    private final Runnable mCloser;
    public static final Parcelable.Creator<SyncFence> CREATOR = new Parcelable.Creator<SyncFence>(){

        @Override
        public SyncFence createFromParcel(Parcel in) {
            return new SyncFence(in);
        }

        public SyncFence[] newArray(int size) {
            return new SyncFence[size];
        }
    };

    private SyncFence(int fileDescriptor) {
        this.mNativePtr = SyncFence.nCreate(fileDescriptor);
        this.mCloser = sRegistry.registerNativeAllocation(this, this.mNativePtr);
    }

    private SyncFence(Parcel parcel) {
        boolean valid = parcel.readBoolean();
        FileDescriptor fileDescriptor = null;
        if (valid) {
            fileDescriptor = parcel.readRawFileDescriptor();
        }
        if (fileDescriptor != null) {
            this.mNativePtr = SyncFence.nCreate(fileDescriptor.getInt$());
            this.mCloser = sRegistry.registerNativeAllocation(this, this.mNativePtr);
        } else {
            this.mCloser = () -> {};
        }
    }

    public SyncFence(long nativeFencePtr) {
        this.mNativePtr = nativeFencePtr;
        this.mCloser = nativeFencePtr != 0L ? sRegistry.registerNativeAllocation(this, this.mNativePtr) : () -> {};
    }

    private SyncFence() {
        this.mCloser = () -> {};
    }

    public static SyncFence createEmpty() {
        return new SyncFence();
    }

    public static SyncFence create(ParcelFileDescriptor wrapped) {
        return new SyncFence(wrapped.detachFd());
    }

    public static SyncFence adopt(int fileDescriptor) {
        return new SyncFence(fileDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor getFdDup() throws IOException {
        Runnable runnable = this.mCloser;
        synchronized (runnable) {
            int fd;
            int n = fd = this.mNativePtr != 0L ? SyncFence.nGetFd(this.mNativePtr) : -1;
            if (fd == -1) {
                throw new IllegalStateException("Cannot dup the FD of an invalid SyncFence");
            }
            return ParcelFileDescriptor.fromFd(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Runnable runnable = this.mCloser;
        synchronized (runnable) {
            return this.mNativePtr != 0L && SyncFence.nIsValid(this.mNativePtr);
        }
    }

    public boolean await(Duration timeout) {
        long timeoutNanos = timeout.isNegative() ? -1L : timeout.toNanos();
        return this.await(timeoutNanos);
    }

    public boolean awaitForever() {
        return this.await(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await(long timeoutNanos) {
        Runnable runnable = this.mCloser;
        synchronized (runnable) {
            return this.mNativePtr != 0L && SyncFence.nWait(this.mNativePtr, timeoutNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSignalTime() {
        Runnable runnable = this.mCloser;
        synchronized (runnable) {
            return this.mNativePtr != 0L ? SyncFence.nGetSignalTime(this.mNativePtr) : -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Runnable runnable = this.mCloser;
        synchronized (runnable) {
            if (this.mNativePtr == 0L) {
                return;
            }
            this.mNativePtr = 0L;
            this.mCloser.run();
        }
    }

    @Override
    public int describeContents() {
        return 1;
    }

    public Object getLock() {
        return this.mCloser;
    }

    public long getNativeFence() {
        return this.mNativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel out, int flags) {
        Runnable runnable = this.mCloser;
        synchronized (runnable) {
            int fd;
            int n = fd = this.mNativePtr != 0L ? SyncFence.nGetFd(this.mNativePtr) : -1;
            if (fd == -1) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                FileDescriptor temp = new FileDescriptor();
                temp.setInt$(fd);
                out.writeFileDescriptor(temp);
            }
        }
    }

    private static long nGetDestructor() {
        return OverrideMethod.invokeL("android.hardware.SyncFence#nGetDestructor()J", true, null);
    }

    private static long nCreate(int n) {
        return OverrideMethod.invokeL("android.hardware.SyncFence#nCreate(I)J", true, null);
    }

    private static boolean nIsValid(long l) {
        return OverrideMethod.invokeI("android.hardware.SyncFence#nIsValid(J)Z", true, null) != 0;
    }

    private static int nGetFd(long l) {
        return OverrideMethod.invokeI("android.hardware.SyncFence#nGetFd(J)I", true, null);
    }

    private static boolean nWait(long l, long l2) {
        return OverrideMethod.invokeI("android.hardware.SyncFence#nWait(JJ)Z", true, null) != 0;
    }

    private static long nGetSignalTime(long l) {
        return OverrideMethod.invokeL("android.hardware.SyncFence#nGetSignalTime(J)J", true, null);
    }
}

