/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBiometricStateListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.IBiometricStateListener";

    public void onStateChanged(int var1) throws RemoteException;

    public void onBiometricAction(int var1) throws RemoteException;

    public void onEnrollmentsChanged(int var1, int var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBiometricStateListener {
        static final int TRANSACTION_onStateChanged = 1;
        static final int TRANSACTION_onBiometricAction = 2;
        static final int TRANSACTION_onEnrollmentsChanged = 3;

        public Stub() {
            this.attachInterface(this, IBiometricStateListener.DESCRIPTOR);
        }

        public static IBiometricStateListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBiometricStateListener.DESCRIPTOR);
            if (iin != null && iin instanceof IBiometricStateListener) {
                return (IBiometricStateListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStateChanged";
                }
                case 2: {
                    return "onBiometricAction";
                }
                case 3: {
                    return "onEnrollmentsChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBiometricStateListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStateChanged(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricAction(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onEnrollmentsChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IBiometricStateListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBiometricStateListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateChanged(int newState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricStateListener.DESCRIPTOR);
                    _data.writeInt(newState);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricAction(int action) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricStateListener.DESCRIPTOR);
                    _data.writeInt(action);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentsChanged(int userId, int sensorId, boolean hasEnrollments) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricStateListener.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(sensorId);
                    _data.writeBoolean(hasEnrollments);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBiometricStateListener {
        @Override
        public void onStateChanged(int newState) throws RemoteException {
        }

        @Override
        public void onBiometricAction(int action) throws RemoteException {
        }

        @Override
        public void onEnrollmentsChanged(int userId, int sensorId, boolean hasEnrollments) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

