/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBiometricSysuiReceiver
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.IBiometricSysuiReceiver";

    public void onDialogDismissed(int var1, byte[] var2) throws RemoteException;

    public void onTryAgainPressed() throws RemoteException;

    public void onDeviceCredentialPressed() throws RemoteException;

    public void onSystemEvent(int var1) throws RemoteException;

    public void onDialogAnimatedIn(boolean var1) throws RemoteException;

    public void onStartFingerprintNow() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBiometricSysuiReceiver {
        static final int TRANSACTION_onDialogDismissed = 1;
        static final int TRANSACTION_onTryAgainPressed = 2;
        static final int TRANSACTION_onDeviceCredentialPressed = 3;
        static final int TRANSACTION_onSystemEvent = 4;
        static final int TRANSACTION_onDialogAnimatedIn = 5;
        static final int TRANSACTION_onStartFingerprintNow = 6;

        public Stub() {
            this.attachInterface(this, IBiometricSysuiReceiver.DESCRIPTOR);
        }

        public static IBiometricSysuiReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBiometricSysuiReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof IBiometricSysuiReceiver) {
                return (IBiometricSysuiReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDialogDismissed";
                }
                case 2: {
                    return "onTryAgainPressed";
                }
                case 3: {
                    return "onDeviceCredentialPressed";
                }
                case 4: {
                    return "onSystemEvent";
                }
                case 5: {
                    return "onDialogAnimatedIn";
                }
                case 6: {
                    return "onStartFingerprintNow";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBiometricSysuiReceiver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onDialogDismissed(_arg0, _arg1);
                    break;
                }
                case 2: {
                    this.onTryAgainPressed();
                    break;
                }
                case 3: {
                    this.onDeviceCredentialPressed();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSystemEvent(_arg0);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onDialogAnimatedIn(_arg0);
                    break;
                }
                case 6: {
                    this.onStartFingerprintNow();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IBiometricSysuiReceiver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBiometricSysuiReceiver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDialogDismissed(int reason, byte[] credentialAttestation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeByteArray(credentialAttestation);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onTryAgainPressed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDeviceCredentialPressed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemEvent(int event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDialogAnimatedIn(boolean startFingerprintNow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    _data.writeBoolean(startFingerprintNow);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onStartFingerprintNow() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBiometricSysuiReceiver.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBiometricSysuiReceiver {
        @Override
        public void onDialogDismissed(int reason, byte[] credentialAttestation) throws RemoteException {
        }

        @Override
        public void onTryAgainPressed() throws RemoteException {
        }

        @Override
        public void onDeviceCredentialPressed() throws RemoteException {
        }

        @Override
        public void onSystemEvent(int event) throws RemoteException {
        }

        @Override
        public void onDialogAnimatedIn(boolean startFingerprintNow) throws RemoteException {
        }

        @Override
        public void onStartFingerprintNow() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

