/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface ITestSession
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.ITestSession";

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void setTestHalEnabled(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void startEnroll(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void finishEnroll(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void acceptAuthentication(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void rejectAuthentication(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void notifyAcquired(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void notifyError(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void cleanupInternalState(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITestSession {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_setTestHalEnabled = 1;
        static final int TRANSACTION_startEnroll = 2;
        static final int TRANSACTION_finishEnroll = 3;
        static final int TRANSACTION_acceptAuthentication = 4;
        static final int TRANSACTION_rejectAuthentication = 5;
        static final int TRANSACTION_notifyAcquired = 6;
        static final int TRANSACTION_notifyError = 7;
        static final int TRANSACTION_cleanupInternalState = 8;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, ITestSession.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static ITestSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITestSession.DESCRIPTOR);
            if (iin != null && iin instanceof ITestSession) {
                return (ITestSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setTestHalEnabled";
                }
                case 2: {
                    return "startEnroll";
                }
                case 3: {
                    return "finishEnroll";
                }
                case 4: {
                    return "acceptAuthentication";
                }
                case 5: {
                    return "rejectAuthentication";
                }
                case 6: {
                    return "notifyAcquired";
                }
                case 7: {
                    return "notifyError";
                }
                case 8: {
                    return "cleanupInternalState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITestSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTestHalEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startEnroll(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishEnroll(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.acceptAuthentication(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.rejectAuthentication(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAcquired(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyError(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cleanupInternalState(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setTestHalEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startEnroll_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void finishEnroll_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void acceptAuthentication_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void rejectAuthentication_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyAcquired_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyError_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cleanupInternalState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements ITestSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITestSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestHalEnabled(boolean enableTestHal) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeBoolean(enableTestHal);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startEnroll(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishEnroll(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acceptAuthentication(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rejectAuthentication(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAcquired(int userId, int acquireInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(acquireInfo);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyError(int userId, int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(errorCode);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanupInternalState(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestSession.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITestSession {
        @Override
        public void setTestHalEnabled(boolean enableTestHal) throws RemoteException {
        }

        @Override
        public void startEnroll(int userId) throws RemoteException {
        }

        @Override
        public void finishEnroll(int userId) throws RemoteException {
        }

        @Override
        public void acceptAuthentication(int userId) throws RemoteException {
        }

        @Override
        public void rejectAuthentication(int userId) throws RemoteException {
        }

        @Override
        public void notifyAcquired(int userId, int acquireInfo) throws RemoteException {
        }

        @Override
        public void notifyError(int userId, int errorCode) throws RemoteException {
        }

        @Override
        public void cleanupInternalState(int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

