/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.hardware.biometrics.ComponentInfoInternal;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class SensorPropertiesInternal
implements Parcelable {
    public final int sensorId;
    public final int sensorStrength;
    public final int maxEnrollmentsPerUser;
    public final List<ComponentInfoInternal> componentInfo;
    public final boolean resetLockoutRequiresHardwareAuthToken;
    public final boolean resetLockoutRequiresChallenge;
    public static final Parcelable.Creator<SensorPropertiesInternal> CREATOR = new Parcelable.Creator<SensorPropertiesInternal>(){

        @Override
        public SensorPropertiesInternal createFromParcel(Parcel in) {
            return new SensorPropertiesInternal(in);
        }

        public SensorPropertiesInternal[] newArray(int size) {
            return new SensorPropertiesInternal[size];
        }
    };

    public static SensorPropertiesInternal from(SensorPropertiesInternal prop) {
        return new SensorPropertiesInternal(prop.sensorId, prop.sensorStrength, prop.maxEnrollmentsPerUser, prop.componentInfo, prop.resetLockoutRequiresHardwareAuthToken, prop.resetLockoutRequiresChallenge);
    }

    public SensorPropertiesInternal(int sensorId, int sensorStrength, int maxEnrollmentsPerUser, List<ComponentInfoInternal> componentInfo, boolean resetLockoutRequiresHardwareAuthToken, boolean resetLockoutRequiresChallenge) {
        this.sensorId = sensorId;
        this.sensorStrength = sensorStrength;
        this.maxEnrollmentsPerUser = maxEnrollmentsPerUser;
        this.componentInfo = componentInfo;
        this.resetLockoutRequiresHardwareAuthToken = resetLockoutRequiresHardwareAuthToken;
        this.resetLockoutRequiresChallenge = resetLockoutRequiresChallenge;
    }

    protected SensorPropertiesInternal(Parcel in) {
        this.sensorId = in.readInt();
        this.sensorStrength = in.readInt();
        this.maxEnrollmentsPerUser = in.readInt();
        this.componentInfo = new ArrayList<ComponentInfoInternal>();
        in.readList(this.componentInfo, ComponentInfoInternal.class.getClassLoader(), ComponentInfoInternal.class);
        this.resetLockoutRequiresHardwareAuthToken = in.readBoolean();
        this.resetLockoutRequiresChallenge = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.sensorId);
        dest.writeInt(this.sensorStrength);
        dest.writeInt(this.maxEnrollmentsPerUser);
        dest.writeList(this.componentInfo);
        dest.writeBoolean(this.resetLockoutRequiresHardwareAuthToken);
        dest.writeBoolean(this.resetLockoutRequiresChallenge);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (ComponentInfoInternal info : this.componentInfo) {
            sb.append("[").append(info.toString());
            sb.append("] ");
        }
        sb.append("]");
        return "ID: " + this.sensorId + ", Strength: " + this.sensorStrength + ", MaxEnrollmentsPerUser: " + this.maxEnrollmentsPerUser + ", ComponentInfo: " + sb.toString();
    }
}

