/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.extension.IAdvancedExtenderImpl;
import android.hardware.camera2.extension.ICameraExtensionsProxyService;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.hardware.camera2.extension.LatencyRange;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.extension.SizeList;
import android.hardware.camera2.impl.CameraExtensionUtils;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.AsyncTask;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.view.SurfaceView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CameraExtensionCharacteristics {
    private static final String TAG = "CameraExtensionCharacteristics";
    public static final int EXTENSION_AUTOMATIC = 0;
    public static final int EXTENSION_FACE_RETOUCH = 1;
    @Deprecated
    public static final int EXTENSION_BEAUTY = 1;
    public static final int EXTENSION_BOKEH = 2;
    public static final int EXTENSION_HDR = 3;
    public static final int EXTENSION_NIGHT = 4;
    public static final int NON_PROCESSING_INPUT_FORMAT = 34;
    public static final int PROCESSING_INPUT_FORMAT = 35;
    private static final int[] EXTENSION_LIST = new int[]{0, 1, 2, 3, 4};
    private final Context mContext;
    private final String mCameraId;
    private final Map<String, CameraCharacteristics> mCharacteristicsMap;
    private final Map<String, CameraMetadataNative> mCharacteristicsMapNative;

    public CameraExtensionCharacteristics(Context context, String cameraId, Map<String, CameraCharacteristics> characteristicsMap) {
        this.mContext = context;
        this.mCameraId = cameraId;
        this.mCharacteristicsMap = characteristicsMap;
        this.mCharacteristicsMapNative = CameraExtensionUtils.getCharacteristicsMapNative(characteristicsMap);
    }

    private static ArrayList<android.util.Size> getSupportedSizes(List<SizeList> sizesList, Integer format) {
        ArrayList<android.util.Size> ret = new ArrayList<android.util.Size>();
        if (sizesList != null && !sizesList.isEmpty()) {
            for (SizeList entry : sizesList) {
                if (entry.format != format || entry.sizes.isEmpty()) continue;
                for (Size sz : entry.sizes) {
                    ret.add(new android.util.Size(sz.width, sz.height));
                }
                return ret;
            }
        }
        return ret;
    }

    private static List<android.util.Size> generateSupportedSizes(List<SizeList> sizesList, Integer format, StreamConfigurationMap streamMap) {
        ArrayList<android.util.Size> ret = CameraExtensionCharacteristics.getSupportedSizes(sizesList, format);
        android.util.Size[] supportedSizes = streamMap.getOutputSizes(format);
        if (ret.isEmpty() && supportedSizes != null) {
            ret.addAll(Arrays.asList(supportedSizes));
        }
        return ret;
    }

    private static List<android.util.Size> generateJpegSupportedSizes(List<SizeList> sizesList, StreamConfigurationMap streamMap) {
        ArrayList<android.util.Size> extensionSizes = CameraExtensionCharacteristics.getSupportedSizes(sizesList, 35);
        HashSet<android.util.Size> supportedSizes = extensionSizes.isEmpty() ? new HashSet<android.util.Size>(Arrays.asList(streamMap.getOutputSizes(35))) : new HashSet<android.util.Size>(extensionSizes);
        HashSet<android.util.Size> supportedJpegSizes = new HashSet<android.util.Size>(Arrays.asList(streamMap.getOutputSizes(256)));
        supportedSizes.retainAll(supportedJpegSizes);
        return new ArrayList<android.util.Size>(supportedSizes);
    }

    public static long registerClient(Context ctx) {
        return CameraExtensionManagerGlobal.get().registerClient(ctx);
    }

    public static void unregisterClient(long clientId) {
        CameraExtensionManagerGlobal.get().unregisterClient(clientId);
    }

    public static void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
        CameraExtensionManagerGlobal.get().initializeSession(cb);
    }

    public static void releaseSession() {
        CameraExtensionManagerGlobal.get().releaseSession();
    }

    public static boolean areAdvancedExtensionsSupported() {
        return CameraExtensionManagerGlobal.get().areAdvancedExtensionsSupported();
    }

    public static boolean isExtensionSupported(String cameraId, int extensionType, Map<String, CameraMetadataNative> characteristicsMap) {
        Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders;
        if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
            try {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extensionType);
                return extender.isExtensionAvailable(cameraId, characteristicsMap);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to query extension availability! Extension service does not respond!");
                return false;
            }
        }
        try {
            extenders = CameraExtensionCharacteristics.initializeExtension(extensionType);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            return ((IPreviewExtenderImpl)extenders.first).isExtensionAvailable(cameraId, characteristicsMap.get(cameraId)) && ((IImageCaptureExtenderImpl)extenders.second).isExtensionAvailable(cameraId, characteristicsMap.get(cameraId));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query extension availability! Extension service does not respond!");
            return false;
        }
    }

    public static IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) {
        IAdvancedExtenderImpl extender;
        try {
            extender = CameraExtensionManagerGlobal.get().initializeAdvancedExtension(extensionType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to initialize extension: " + extensionType);
        }
        if (extender == null) {
            throw new IllegalArgumentException("Unknown extension: " + extensionType);
        }
        return extender;
    }

    public static Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> initializeExtension(int extensionType) {
        IImageCaptureExtenderImpl imageExtender;
        IPreviewExtenderImpl previewExtender;
        try {
            previewExtender = CameraExtensionManagerGlobal.get().initializePreviewExtension(extensionType);
            imageExtender = CameraExtensionManagerGlobal.get().initializeImageExtension(extensionType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to initialize extension: " + extensionType);
        }
        if (imageExtender == null || previewExtender == null) {
            throw new IllegalArgumentException("Unknown extension: " + extensionType);
        }
        return new Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl>(previewExtender, imageExtender);
    }

    private static <T> boolean isOutputSupportedFor(Class<T> klass) {
        Objects.requireNonNull(klass, "klass must not be null");
        return klass == SurfaceTexture.class || klass == SurfaceView.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getSupportedExtensions() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            return Collections.unmodifiableList(ret);
        }
        try {
            for (int extensionType : EXTENSION_LIST) {
                if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extensionType, this.mCharacteristicsMapNative)) continue;
                ret.add(extensionType);
            }
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return Collections.unmodifiableList(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPostviewAvailable(int extension) {
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                boolean bl = extender.isPostviewAvailable();
                return bl;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            boolean bl = ((IImageCaptureExtenderImpl)extenders.second).isPostviewAvailable();
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension for postview availability! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<android.util.Size> getPostviewSupportedSizes(int extension, android.util.Size captureSize, int format) {
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            Size sz = new Size();
            sz.width = captureSize.getWidth();
            sz.height = captureSize.getHeight();
            StreamConfigurationMap streamMap = this.mCharacteristicsMap.get(this.mCameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                switch (format) {
                    case 35: 
                    case 256: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported format: " + format);
                    }
                }
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedPostviewResolutions(sz), format, streamMap);
                return list;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null || !this.isPostviewAvailable(extension)) {
                throw new IllegalArgumentException("Extension does not support postview feature");
            }
            if (format == 35) {
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedPostviewResolutions(sz), format, streamMap);
                return list;
            }
            if (format == 256) {
                List<android.util.Size> list = CameraExtensionCharacteristics.generateJpegSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedPostviewResolutions(sz), streamMap);
                return list;
            }
            try {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to query the extension postview supported sizes! Extension service does not respond!");
                List<android.util.Size> list = Collections.emptyList();
                return list;
            }
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<android.util.Size> getExtensionSupportedSizes(int extension, Class<T> klass) {
        if (!CameraExtensionCharacteristics.isOutputSupportedFor(klass)) {
            return new ArrayList<android.util.Size>();
        }
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            StreamConfigurationMap streamMap = this.mCharacteristicsMap.get(this.mCameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedPreviewOutputResolutions(this.mCameraId), 34, streamMap);
                return list;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IPreviewExtenderImpl)extenders.first).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IPreviewExtenderImpl)extenders.first).getSupportedResolutions(), 34, streamMap);
            return list;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension supported sizes! Extension service does not respond!");
            ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
            return arrayList;
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<android.util.Size> getExtensionSupportedSizes(int extension, int format) {
        try {
            long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
            if (clientId < 0L) {
                throw new IllegalArgumentException("Unsupported extensions");
            }
            try {
                if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                    throw new IllegalArgumentException("Unsupported extension");
                }
                StreamConfigurationMap streamMap = this.mCharacteristicsMap.get(this.mCameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                    switch (format) {
                        case 35: 
                        case 256: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported format: " + format);
                        }
                    }
                    IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                    extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedCaptureOutputResolutions(this.mCameraId), format, streamMap);
                    return list;
                }
                if (format == 35) {
                    Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                    ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                    if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null) {
                        ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
                        return arrayList;
                    }
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedResolutions(), format, streamMap);
                    return list;
                }
                if (format != 256) throw new IllegalArgumentException("Unsupported format: " + format);
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() != null) {
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateJpegSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedResolutions(), streamMap);
                    return list;
                }
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(null, format, streamMap);
                return list;
            }
            finally {
                CameraExtensionCharacteristics.unregisterClient(clientId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension supported sizes! Extension service does not respond!");
            return new ArrayList<android.util.Size>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range<Long> getEstimatedCaptureLatencyRangeMillis(int extension, android.util.Size captureOutputSize, int format) {
        switch (format) {
            case 35: 
            case 256: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
        }
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            Size sz = new Size();
            sz.width = captureOutputSize.getWidth();
            sz.height = captureOutputSize.getHeight();
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                LatencyRange latencyRange = extender.getEstimatedCaptureLatencyRange(this.mCameraId, sz, format);
                if (latencyRange != null) {
                    Range<Long> range = new Range<Long>(latencyRange.min, latencyRange.max);
                    return range;
                }
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                if (format == 35 && ((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                if (format == 256 && ((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() != null) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                LatencyRange latencyRange = ((IImageCaptureExtenderImpl)extenders.second).getEstimatedCaptureLatencyRange(sz);
                if (latencyRange != null) {
                    Range<Long> range = new Range<Long>(latencyRange.min, latencyRange.max);
                    return range;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension capture latency! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCaptureProcessProgressAvailable(int extension) {
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                boolean bl = extender.isCaptureProcessProgressAvailable();
                return bl;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            boolean bl = ((IImageCaptureExtenderImpl)extenders.second).isCaptureProcessProgressAvailable();
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension progress callbacks! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return false;
    }

    public Set<CaptureRequest.Key> getAvailableCaptureRequestKeys(int extension) {
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        HashSet<CaptureRequest.Key<Number>> ret = new HashSet<CaptureRequest.Key<Number>>();
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            CameraMetadataNative captureRequestMeta = null;
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                captureRequestMeta = extender.getAvailableCaptureRequestKeys(this.mCameraId);
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).onInit(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                captureRequestMeta = ((IImageCaptureExtenderImpl)extenders.second).getAvailableCaptureRequestKeys();
                ((IImageCaptureExtenderImpl)extenders.second).onDeInit();
            }
            if (captureRequestMeta != null) {
                Class<CaptureRequest.Key> crKey;
                int[] requestKeys = captureRequestMeta.get(CameraCharacteristics.REQUEST_AVAILABLE_REQUEST_KEYS);
                if (requestKeys == null) {
                    throw new AssertionError((Object)"android.request.availableRequestKeys must be non-null in the characteristics");
                }
                CameraCharacteristics requestChars = new CameraCharacteristics(captureRequestMeta);
                Class<CaptureRequest.Key> crKeyTyped = crKey = CaptureRequest.Key.class;
                ret.addAll(requestChars.getAvailableKeyList(CaptureRequest.class, crKeyTyped, requestKeys, true));
            }
            if (!ret.contains(CaptureRequest.JPEG_QUALITY)) {
                ret.add(CaptureRequest.JPEG_QUALITY);
            }
            if (!ret.contains(CaptureRequest.JPEG_ORIENTATION)) {
                ret.add(CaptureRequest.JPEG_ORIENTATION);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to query the available capture request keys!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<CaptureResult.Key> getAvailableCaptureResultKeys(int extension) {
        long clientId = CameraExtensionCharacteristics.registerClient(this.mContext);
        if (clientId < 0L) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        HashSet<CaptureResult.Key<Number>> ret = new HashSet<CaptureResult.Key<Number>>();
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            CameraMetadataNative captureResultMeta = null;
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported()) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                captureResultMeta = extender.getAvailableCaptureResultKeys(this.mCameraId);
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).onInit(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                captureResultMeta = ((IImageCaptureExtenderImpl)extenders.second).getAvailableCaptureResultKeys();
                ((IImageCaptureExtenderImpl)extenders.second).onDeInit();
            }
            if (captureResultMeta != null) {
                Class<CaptureResult.Key> crKey;
                int[] resultKeys = captureResultMeta.get(CameraCharacteristics.REQUEST_AVAILABLE_RESULT_KEYS);
                if (resultKeys == null) {
                    throw new AssertionError((Object)"android.request.availableResultKeys must be non-null in the characteristics");
                }
                CameraCharacteristics resultChars = new CameraCharacteristics(captureResultMeta);
                Class<CaptureResult.Key> crKeyTyped = crKey = CaptureResult.Key.class;
                ret.addAll(resultChars.getAvailableKeyList(CaptureResult.class, crKeyTyped, resultKeys, true));
                if (!ret.contains(CaptureResult.JPEG_QUALITY)) {
                    ret.add(CaptureResult.JPEG_QUALITY);
                }
                if (!ret.contains(CaptureResult.JPEG_ORIENTATION)) {
                    ret.add(CaptureResult.JPEG_ORIENTATION);
                }
                if (!ret.contains(CaptureResult.SENSOR_TIMESTAMP)) {
                    ret.add(CaptureResult.SENSOR_TIMESTAMP);
                }
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to query the available capture result keys!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(clientId);
        }
        return Collections.unmodifiableSet(ret);
    }

    private static class CameraExtensionManagerGlobal {
        private static final String TAG = "CameraExtensionManagerGlobal";
        private static final String PROXY_PACKAGE_NAME = "com.android.cameraextensions";
        private static final String PROXY_SERVICE_NAME = "com.android.cameraextensions.CameraExtensionsProxyService";
        private static final CameraExtensionManagerGlobal GLOBAL_CAMERA_MANAGER = new CameraExtensionManagerGlobal();
        private final Object mLock = new Object();
        private final int PROXY_SERVICE_DELAY_MS = 1000;
        private InitializerFuture mInitFuture = null;
        private ServiceConnection mConnection = null;
        private ICameraExtensionsProxyService mProxy = null;
        private boolean mSupportsAdvancedExtensions = false;

        private CameraExtensionManagerGlobal() {
        }

        public static CameraExtensionManagerGlobal get() {
            return GLOBAL_CAMERA_MANAGER;
        }

        private void connectToProxyLocked(Context ctx) {
            if (this.mConnection == null) {
                Intent intent = new Intent();
                intent.setClassName(PROXY_PACKAGE_NAME, PROXY_SERVICE_NAME);
                String vendorProxyPackage = SystemProperties.get("ro.vendor.camera.extensions.package");
                String vendorProxyService = SystemProperties.get("ro.vendor.camera.extensions.service");
                if (!vendorProxyPackage.isEmpty() && !vendorProxyService.isEmpty()) {
                    Log.v(TAG, "Choosing the vendor camera extensions proxy package: " + vendorProxyPackage);
                    Log.v(TAG, "Choosing the vendor camera extensions proxy service: " + vendorProxyService);
                    intent.setClassName(vendorProxyPackage, vendorProxyService);
                }
                this.mInitFuture = new InitializerFuture();
                this.mConnection = new ServiceConnection(){

                    @Override
                    public void onServiceDisconnected(ComponentName component) {
                        mInitFuture.setStatus(false);
                        mConnection = null;
                        mProxy = null;
                    }

                    @Override
                    public void onServiceConnected(ComponentName component, IBinder binder) {
                        mProxy = ICameraExtensionsProxyService.Stub.asInterface(binder);
                        if (mProxy == null) {
                            throw new IllegalStateException("Camera Proxy service is null");
                        }
                        try {
                            mSupportsAdvancedExtensions = mProxy.advancedExtensionsSupported();
                        }
                        catch (RemoteException e) {
                            Log.e(CameraExtensionManagerGlobal.TAG, "Remote IPC failed!");
                        }
                        mInitFuture.setStatus(true);
                    }
                };
                ctx.bindService(intent, 0x40000049, AsyncTask.THREAD_POOL_EXECUTOR, this.mConnection);
                try {
                    this.mInitFuture.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    Log.e(TAG, "Timed out while initializing proxy service!");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long registerClient(Context ctx) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectToProxyLocked(ctx);
                if (this.mProxy != null) {
                    try {
                        return this.mProxy.registerClient();
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to initialize extension! Extension service does  not respond!");
                        return -1L;
                    }
                }
                return -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterClient(long clientId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    try {
                        this.mProxy.unregisterClient(clientId);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to de-initialize extension! Extension service does not respond!");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    this.mProxy.initializeSession(cb);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSession() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    try {
                        this.mProxy.releaseSession();
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to release session! Extension service does not respond!");
                    }
                }
            }
        }

        public boolean areAdvancedExtensionsSupported() {
            return this.mSupportsAdvancedExtensions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPreviewExtenderImpl initializePreviewExtension(int extensionType) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    return this.mProxy.initializePreviewExtension(extensionType);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IImageCaptureExtenderImpl initializeImageExtension(int extensionType) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    return this.mProxy.initializeImageExtension(extensionType);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProxy != null) {
                    return this.mProxy.initializeAdvancedExtension(extensionType);
                }
                return null;
            }
        }

        private static class InitializerFuture
        implements Future<Boolean> {
            private volatile Boolean mStatus;
            ConditionVariable mCondVar = new ConditionVariable(false);

            private InitializerFuture() {
            }

            public void setStatus(boolean status) {
                this.mStatus = status;
                this.mCondVar.open();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return this.mStatus != null;
            }

            @Override
            public Boolean get() {
                this.mCondVar.block();
                return this.mStatus;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws TimeoutException {
                long timeoutMs = unit.convert(timeout, TimeUnit.MILLISECONDS);
                if (!this.mCondVar.block(timeoutMs)) {
                    throw new TimeoutException("Failed to receive status after " + timeout + " " + (Object)((Object)unit));
                }
                if (this.mStatus == null) {
                    throw new AssertionError();
                }
                return this.mStatus;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Extension {
    }
}

