/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.utils.HashCodeHelpers;
import java.util.concurrent.Executor;

public abstract class CameraExtensionSession
implements AutoCloseable {
    public CameraDevice getDevice() {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int capture(CaptureRequest request, Executor executor, ExtensionCaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int setRepeatingRequest(CaptureRequest request, Executor executor, ExtensionCaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public void stopRepeating() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public StillCaptureLatency getRealtimeStillCaptureLatency() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @Override
    public void close() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public static class StillCaptureLatency {
        private final long mCaptureLatency;
        private final long mProcessingLatency;

        public StillCaptureLatency(long captureLatency, long processingLatency) {
            this.mCaptureLatency = captureLatency;
            this.mProcessingLatency = processingLatency;
        }

        public long getCaptureLatency() {
            return this.mCaptureLatency;
        }

        public long getProcessingLatency() {
            return this.mProcessingLatency;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StillCaptureLatency latency = (StillCaptureLatency)o;
            if (this.mCaptureLatency != latency.mCaptureLatency) {
                return false;
            }
            return this.mProcessingLatency == latency.mProcessingLatency;
        }

        public int hashCode() {
            return HashCodeHelpers.hashCode(this.mCaptureLatency, this.mProcessingLatency);
        }

        public String toString() {
            return "StillCaptureLatency(processingLatency:" + this.mProcessingLatency + ", captureLatency: " + this.mCaptureLatency + ")";
        }
    }

    public static abstract class StateCallback {
        public abstract void onConfigured(CameraExtensionSession var1);

        public abstract void onConfigureFailed(CameraExtensionSession var1);

        public void onClosed(CameraExtensionSession session) {
        }
    }

    public static abstract class ExtensionCaptureCallback {
        public void onCaptureStarted(CameraExtensionSession session, CaptureRequest request, long timestamp) {
        }

        public void onCaptureProcessStarted(CameraExtensionSession session, CaptureRequest request) {
        }

        public void onCaptureFailed(CameraExtensionSession session, CaptureRequest request) {
        }

        public void onCaptureSequenceCompleted(CameraExtensionSession session, int sequenceId) {
        }

        public void onCaptureSequenceAborted(CameraExtensionSession session, int sequenceId) {
        }

        public void onCaptureResultAvailable(CameraExtensionSession session, CaptureRequest request, TotalCaptureResult result) {
        }

        public void onCaptureProcessProgressed(CameraExtensionSession session, CaptureRequest request, int progress) {
        }
    }
}

