/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraInjectionSession
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.ICameraInjectionSession";

    public void stopInjection() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraInjectionSession {
        static final int TRANSACTION_stopInjection = 1;

        public Stub() {
            this.attachInterface(this, ICameraInjectionSession.DESCRIPTOR);
        }

        public static ICameraInjectionSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICameraInjectionSession.DESCRIPTOR);
            if (iin != null && iin instanceof ICameraInjectionSession) {
                return (ICameraInjectionSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "stopInjection";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICameraInjectionSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.stopInjection();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ICameraInjectionSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICameraInjectionSession.DESCRIPTOR;
            }

            @Override
            public void stopInjection() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICameraInjectionSession.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICameraInjectionSession {
        @Override
        public void stopInjection() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

