/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.IAdvancedExtenderImpl;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraExtensionsProxyService
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.ICameraExtensionsProxyService";

    public long registerClient() throws RemoteException;

    public void unregisterClient(long var1) throws RemoteException;

    public boolean advancedExtensionsSupported() throws RemoteException;

    public void initializeSession(IInitializeSessionCallback var1) throws RemoteException;

    public void releaseSession() throws RemoteException;

    public IPreviewExtenderImpl initializePreviewExtension(int var1) throws RemoteException;

    public IImageCaptureExtenderImpl initializeImageExtension(int var1) throws RemoteException;

    public IAdvancedExtenderImpl initializeAdvancedExtension(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraExtensionsProxyService {
        static final int TRANSACTION_registerClient = 1;
        static final int TRANSACTION_unregisterClient = 2;
        static final int TRANSACTION_advancedExtensionsSupported = 3;
        static final int TRANSACTION_initializeSession = 4;
        static final int TRANSACTION_releaseSession = 5;
        static final int TRANSACTION_initializePreviewExtension = 6;
        static final int TRANSACTION_initializeImageExtension = 7;
        static final int TRANSACTION_initializeAdvancedExtension = 8;

        public Stub() {
            this.attachInterface(this, ICameraExtensionsProxyService.DESCRIPTOR);
        }

        public static ICameraExtensionsProxyService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICameraExtensionsProxyService.DESCRIPTOR);
            if (iin != null && iin instanceof ICameraExtensionsProxyService) {
                return (ICameraExtensionsProxyService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerClient";
                }
                case 2: {
                    return "unregisterClient";
                }
                case 3: {
                    return "advancedExtensionsSupported";
                }
                case 4: {
                    return "initializeSession";
                }
                case 5: {
                    return "releaseSession";
                }
                case 6: {
                    return "initializePreviewExtension";
                }
                case 7: {
                    return "initializeImageExtension";
                }
                case 8: {
                    return "initializeAdvancedExtension";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICameraExtensionsProxyService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    long _result = this.registerClient();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _result = this.advancedExtensionsSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IInitializeSessionCallback _arg0 = IInitializeSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.initializeSession(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.releaseSession();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IPreviewExtenderImpl _result = this.initializePreviewExtension(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IImageCaptureExtenderImpl _result = this.initializeImageExtension(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IAdvancedExtenderImpl _result = this.initializeAdvancedExtension(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements ICameraExtensionsProxyService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICameraExtensionsProxyService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long registerClient() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClient(long clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeLong(clientId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean advancedExtensionsSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSession() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPreviewExtenderImpl initializePreviewExtension(int extensionType) throws RemoteException {
                IPreviewExtenderImpl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeInt(extensionType);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = IPreviewExtenderImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImageCaptureExtenderImpl initializeImageExtension(int extensionType) throws RemoteException {
                IImageCaptureExtenderImpl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeInt(extensionType);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = IImageCaptureExtenderImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) throws RemoteException {
                IAdvancedExtenderImpl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICameraExtensionsProxyService.DESCRIPTOR);
                    _data.writeInt(extensionType);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = IAdvancedExtenderImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICameraExtensionsProxyService {
        @Override
        public long registerClient() throws RemoteException {
            return 0L;
        }

        @Override
        public void unregisterClient(long clientId) throws RemoteException {
        }

        @Override
        public boolean advancedExtensionsSupported() throws RemoteException {
            return false;
        }

        @Override
        public void initializeSession(IInitializeSessionCallback cb) throws RemoteException {
        }

        @Override
        public void releaseSession() throws RemoteException {
        }

        @Override
        public IPreviewExtenderImpl initializePreviewExtension(int extensionType) throws RemoteException {
            return null;
        }

        @Override
        public IImageCaptureExtenderImpl initializeImageExtension(int extensionType) throws RemoteException {
            return null;
        }

        @Override
        public IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

