/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICaptureCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.ICaptureCallback";

    public void onCaptureStarted(int var1, long var2) throws RemoteException;

    public void onCaptureProcessStarted(int var1) throws RemoteException;

    public void onCaptureFailed(int var1) throws RemoteException;

    public void onCaptureSequenceCompleted(int var1) throws RemoteException;

    public void onCaptureSequenceAborted(int var1) throws RemoteException;

    public void onCaptureCompleted(long var1, int var3, CameraMetadataNative var4) throws RemoteException;

    public void onCaptureProcessProgressed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICaptureCallback {
        static final int TRANSACTION_onCaptureStarted = 1;
        static final int TRANSACTION_onCaptureProcessStarted = 2;
        static final int TRANSACTION_onCaptureFailed = 3;
        static final int TRANSACTION_onCaptureSequenceCompleted = 4;
        static final int TRANSACTION_onCaptureSequenceAborted = 5;
        static final int TRANSACTION_onCaptureCompleted = 6;
        static final int TRANSACTION_onCaptureProcessProgressed = 7;

        public Stub() {
            this.attachInterface(this, ICaptureCallback.DESCRIPTOR);
        }

        public static ICaptureCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICaptureCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICaptureCallback) {
                return (ICaptureCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCaptureStarted";
                }
                case 2: {
                    return "onCaptureProcessStarted";
                }
                case 3: {
                    return "onCaptureFailed";
                }
                case 4: {
                    return "onCaptureSequenceCompleted";
                }
                case 5: {
                    return "onCaptureSequenceAborted";
                }
                case 6: {
                    return "onCaptureCompleted";
                }
                case 7: {
                    return "onCaptureProcessProgressed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICaptureCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onCaptureStarted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureProcessStarted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureFailed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureSequenceCompleted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureSequenceAborted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    CameraMetadataNative _arg2 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCaptureCompleted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureProcessProgressed(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements ICaptureCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICaptureCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureStarted(int captureSequenceId, long timestamp) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeInt(captureSequenceId);
                    _data.writeLong(timestamp);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureProcessStarted(int captureSequenceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeInt(captureSequenceId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureFailed(int captureSequenceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeInt(captureSequenceId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSequenceCompleted(int captureSequenceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeInt(captureSequenceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSequenceAborted(int captureSequenceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeInt(captureSequenceId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureCompleted(long shutterTimestamp, int requestId, CameraMetadataNative results) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeLong(shutterTimestamp);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(results, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureProcessProgressed(int progress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICaptureCallback.DESCRIPTOR);
                    _data.writeInt(progress);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICaptureCallback {
        @Override
        public void onCaptureStarted(int captureSequenceId, long timestamp) throws RemoteException {
        }

        @Override
        public void onCaptureProcessStarted(int captureSequenceId) throws RemoteException {
        }

        @Override
        public void onCaptureFailed(int captureSequenceId) throws RemoteException {
        }

        @Override
        public void onCaptureSequenceCompleted(int captureSequenceId) throws RemoteException {
        }

        @Override
        public void onCaptureSequenceAborted(int captureSequenceId) throws RemoteException {
        }

        @Override
        public void onCaptureCompleted(long shutterTimestamp, int requestId, CameraMetadataNative results) throws RemoteException {
        }

        @Override
        public void onCaptureProcessProgressed(int progress) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

