/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.IProcessResultImpl;
import android.hardware.camera2.extension.ParcelImage;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface IPreviewImageProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IPreviewImageProcessorImpl";

    public void onOutputSurface(Surface var1, int var2) throws RemoteException;

    public void onResolutionUpdate(Size var1) throws RemoteException;

    public void onImageFormatUpdate(int var1) throws RemoteException;

    public void process(ParcelImage var1, CameraMetadataNative var2, int var3, IProcessResultImpl var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPreviewImageProcessorImpl {
        static final int TRANSACTION_onOutputSurface = 1;
        static final int TRANSACTION_onResolutionUpdate = 2;
        static final int TRANSACTION_onImageFormatUpdate = 3;
        static final int TRANSACTION_process = 4;

        public Stub() {
            this.attachInterface(this, IPreviewImageProcessorImpl.DESCRIPTOR);
        }

        public static IPreviewImageProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPreviewImageProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IPreviewImageProcessorImpl) {
                return (IPreviewImageProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onOutputSurface";
                }
                case 2: {
                    return "onResolutionUpdate";
                }
                case 3: {
                    return "onImageFormatUpdate";
                }
                case 4: {
                    return "process";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPreviewImageProcessorImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Surface _arg0 = data.readTypedObject(Surface.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onOutputSurface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    Size _arg0 = data.readTypedObject(Size.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResolutionUpdate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onImageFormatUpdate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ParcelImage _arg0 = data.readTypedObject(ParcelImage.CREATOR);
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    int _arg2 = data.readInt();
                    IProcessResultImpl _arg3 = IProcessResultImpl.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.process(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IPreviewImageProcessorImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPreviewImageProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOutputSurface(Surface surface, int imageFormat) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewImageProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(imageFormat);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResolutionUpdate(Size size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewImageProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(size, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageFormatUpdate(int imageFormat) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewImageProcessorImpl.DESCRIPTOR);
                    _data.writeInt(imageFormat);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(ParcelImage image, CameraMetadataNative result, int sequenceId, IProcessResultImpl resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPreviewImageProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(image, 0);
                    _data.writeTypedObject(result, 0);
                    _data.writeInt(sequenceId);
                    _data.writeStrongInterface(resultCallback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPreviewImageProcessorImpl {
        @Override
        public void onOutputSurface(Surface surface, int imageFormat) throws RemoteException {
        }

        @Override
        public void onResolutionUpdate(Size size) throws RemoteException {
        }

        @Override
        public void onImageFormatUpdate(int imageFormat) throws RemoteException {
        }

        @Override
        public void process(ParcelImage image, CameraMetadataNative result, int sequenceId, IProcessResultImpl resultCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

