/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Handler;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class CameraExtensionUtils {
    private static final String TAG = "CameraExtensionUtils";
    public static final int JPEG_DEFAULT_QUALITY = 100;
    public static final int JPEG_DEFAULT_ROTATION = 0;
    public static final int[] SUPPORTED_CAPTURE_OUTPUT_FORMATS = new int[]{35, 256};

    public static SurfaceInfo querySurface(Surface s) {
        Object writer = null;
        Object img = null;
        SurfaceInfo surfaceInfo = new SurfaceInfo();
        int nativeFormat = SurfaceUtils.detectSurfaceFormat(s);
        int dataspace = SurfaceUtils.getSurfaceDataspace(s);
        Size surfaceSize = SurfaceUtils.getSurfaceSize(s);
        surfaceInfo.mFormat = nativeFormat;
        surfaceInfo.mWidth = surfaceSize.getWidth();
        surfaceInfo.mHeight = surfaceSize.getHeight();
        surfaceInfo.mUsage = SurfaceUtils.getSurfaceUsage(s);
        if (nativeFormat == 33 && dataspace == 146931712) {
            surfaceInfo.mFormat = 256;
            return surfaceInfo;
        }
        return surfaceInfo;
    }

    public static Surface getPostviewSurface(OutputConfiguration outputConfig, HashMap<Integer, List<Size>> supportedPostviewSizes, int captureFormat) {
        if (outputConfig == null) {
            return null;
        }
        SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(outputConfig.getSurface());
        if (surfaceInfo.mFormat == captureFormat) {
            if (supportedPostviewSizes.containsKey(captureFormat)) {
                Size postviewSize = new Size(surfaceInfo.mWidth, surfaceInfo.mHeight);
                if (supportedPostviewSizes.get(surfaceInfo.mFormat).contains(postviewSize)) {
                    return outputConfig.getSurface();
                }
                throw new IllegalArgumentException("Postview size not supported!");
            }
        } else {
            throw new IllegalArgumentException("Postview format should be equivalent to  the capture format!");
        }
        return null;
    }

    public static Surface getBurstCaptureSurface(List<OutputConfiguration> outputConfigs, HashMap<Integer, List<Size>> supportedCaptureSizes) {
        for (OutputConfiguration config : outputConfigs) {
            SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(config.getSurface());
            for (int supportedFormat : SUPPORTED_CAPTURE_OUTPUT_FORMATS) {
                if (surfaceInfo.mFormat != supportedFormat) continue;
                Size captureSize = new Size(surfaceInfo.mWidth, surfaceInfo.mHeight);
                if (supportedCaptureSizes.containsKey(supportedFormat)) {
                    if (supportedCaptureSizes.get(surfaceInfo.mFormat).contains(captureSize)) {
                        return config.getSurface();
                    }
                    throw new IllegalArgumentException("Capture size not supported!");
                }
                return config.getSurface();
            }
        }
        return null;
    }

    public static Surface getRepeatingRequestSurface(List<OutputConfiguration> outputConfigs, List<Size> supportedPreviewSizes) {
        for (OutputConfiguration config : outputConfigs) {
            SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(config.getSurface());
            if (surfaceInfo.mFormat != 34 && (surfaceInfo.mUsage & 0x800L) == 0L && surfaceInfo.mFormat != 1) continue;
            Size repeatingRequestSurfaceSize = new Size(surfaceInfo.mWidth, surfaceInfo.mHeight);
            if (supportedPreviewSizes == null || !supportedPreviewSizes.contains(repeatingRequestSurfaceSize)) {
                throw new IllegalArgumentException("Repeating request surface size " + repeatingRequestSurfaceSize + " not supported!");
            }
            return config.getSurface();
        }
        return null;
    }

    public static Map<String, CameraMetadataNative> getCharacteristicsMapNative(Map<String, CameraCharacteristics> charsMap) {
        HashMap<String, CameraMetadataNative> ret = new HashMap<String, CameraMetadataNative>();
        for (Map.Entry<String, CameraCharacteristics> entry : charsMap.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getNativeMetadata());
        }
        return ret;
    }

    public static class SurfaceInfo {
        public int mWidth = 0;
        public int mHeight = 0;
        public int mFormat = 1;
        public long mUsage = 0L;
    }

    public static class HandlerExecutor
    implements Executor {
        private final Handler mHandler;

        public HandlerExecutor(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void execute(Runnable runCmd) {
            try {
                this.mHandler.post(runCmd);
            }
            catch (RejectedExecutionException e) {
                Log.w(CameraExtensionUtils.TAG, "Handler thread unavailable, skipping message!");
            }
        }
    }
}

