/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Range;
import android.util.Size;
import com.android.internal.util.Preconditions;

public class Capability {
    public static final int COUNT = 3;
    private final int mMode;
    private final Size mMaxStreamingSize;
    private final Range<Float> mZoomRatioRange;

    public Capability(int mode, Size maxStreamingSize, Range<Float> zoomRatioRange) {
        this.mMode = mode;
        Preconditions.checkArgumentNonnegative(maxStreamingSize.getWidth(), "maxStreamingSize.getWidth() must be nonnegative");
        Preconditions.checkArgumentNonnegative(maxStreamingSize.getHeight(), "maxStreamingSize.getHeight() must be nonnegative");
        this.mMaxStreamingSize = maxStreamingSize;
        if (zoomRatioRange.getLower().floatValue() > zoomRatioRange.getUpper().floatValue()) {
            throw new IllegalArgumentException("zoomRatioRange.getLower() " + zoomRatioRange.getLower() + " is greater than zoomRatioRange.getUpper() " + zoomRatioRange.getUpper());
        }
        Preconditions.checkArgumentPositive(zoomRatioRange.getLower().floatValue(), "zoomRatioRange.getLower() must be positive");
        Preconditions.checkArgumentPositive(zoomRatioRange.getUpper().floatValue(), "zoomRatioRange.getUpper() must be positive");
        this.mZoomRatioRange = zoomRatioRange;
    }

    public int getMode() {
        return this.mMode;
    }

    public Size getMaxStreamingSize() {
        return this.mMaxStreamingSize;
    }

    public Range<Float> getZoomRatioRange() {
        return this.mZoomRatioRange;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Capability) {
            Capability other = (Capability)obj;
            return this.mMode == other.mMode && this.mMaxStreamingSize.equals(other.mMaxStreamingSize) && this.mZoomRatioRange.equals(other.mZoomRatioRange);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mMode, this.mMaxStreamingSize.getWidth(), this.mMaxStreamingSize.getHeight(), this.mZoomRatioRange.getLower().floatValue(), this.mZoomRatioRange.getUpper().floatValue());
    }

    public String toString() {
        return String.format("(mode:%d, maxStreamingSize:%d x %d, zoomRatio: %f-%f)", this.mMode, this.mMaxStreamingSize.getWidth(), this.mMaxStreamingSize.getHeight(), this.mZoomRatioRange.getLower(), this.mZoomRatioRange.getUpper());
    }
}

