/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.ColorSpace;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.Map;
import java.util.Set;

public class ColorSpaceProfiles {
    public static final int UNSPECIFIED = -1;
    private final Map<ColorSpace.Named, Map<Integer, Set<Long>>> mProfileMap = new ArrayMap<ColorSpace.Named, Map<Integer, Set<Long>>>();

    public ColorSpaceProfiles(long[] elements) {
        if (elements.length % 3 != 0) {
            throw new IllegalArgumentException("Color space profile map length " + elements.length + " is not divisible by 3!");
        }
        for (int i = 0; i < elements.length; i += 3) {
            int colorSpace = (int)elements[i];
            ColorSpaceProfiles.checkProfileValue(colorSpace);
            ColorSpace.Named namedColorSpace = ColorSpace.Named.values()[colorSpace];
            int imageFormat = (int)elements[i + 1];
            long dynamicRangeProfileBitmap = elements[i + 2];
            if (!this.mProfileMap.containsKey((Object)namedColorSpace)) {
                ArrayMap imageFormatMap = new ArrayMap();
                this.mProfileMap.put(namedColorSpace, imageFormatMap);
            }
            if (!this.mProfileMap.get((Object)namedColorSpace).containsKey(imageFormat)) {
                ArraySet dynamicRangeProfiles = new ArraySet();
                this.mProfileMap.get((Object)namedColorSpace).put(imageFormat, dynamicRangeProfiles);
            }
            if (dynamicRangeProfileBitmap == 0L) continue;
            for (long dynamicRangeProfile = 1L; dynamicRangeProfile < 4096L; dynamicRangeProfile <<= 1) {
                if ((dynamicRangeProfileBitmap & dynamicRangeProfile) == 0L) continue;
                this.mProfileMap.get((Object)namedColorSpace).get(imageFormat).add(dynamicRangeProfile);
            }
        }
    }

    public static void checkProfileValue(int colorSpace) {
        boolean found = false;
        for (ColorSpace.Named value : ColorSpace.Named.values()) {
            if (colorSpace != value.ordinal()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Unknown ColorSpace " + colorSpace);
        }
    }

    public Map<ColorSpace.Named, Map<Integer, Set<Long>>> getProfileMap() {
        return this.mProfileMap;
    }

    public Set<ColorSpace.Named> getSupportedColorSpaces(int imageFormat) {
        ArraySet<ColorSpace.Named> supportedColorSpaceProfiles = new ArraySet<ColorSpace.Named>();
        for (ColorSpace.Named colorSpace : this.mProfileMap.keySet()) {
            if (imageFormat == 0) {
                supportedColorSpaceProfiles.add(colorSpace);
                continue;
            }
            Map<Integer, Set<Long>> imageFormatMap = this.mProfileMap.get((Object)colorSpace);
            if (!imageFormatMap.containsKey(imageFormat)) continue;
            supportedColorSpaceProfiles.add(colorSpace);
        }
        return supportedColorSpaceProfiles;
    }

    public Set<Integer> getSupportedImageFormatsForColorSpace(ColorSpace.Named colorSpace) {
        Map<Integer, Set<Long>> imageFormatMap = this.mProfileMap.get((Object)colorSpace);
        if (imageFormatMap == null) {
            return new ArraySet<Integer>();
        }
        return imageFormatMap.keySet();
    }

    public Set<Long> getSupportedDynamicRangeProfiles(ColorSpace.Named colorSpace, int imageFormat) {
        Map<Integer, Set<Long>> imageFormatMap = this.mProfileMap.get((Object)colorSpace);
        if (imageFormatMap == null) {
            return new ArraySet<Long>();
        }
        Set<Object> dynamicRangeProfiles = null;
        if (imageFormat == 0) {
            dynamicRangeProfiles = new ArraySet();
            for (int supportedImageFormat : imageFormatMap.keySet()) {
                Set<Long> supportedDynamicRangeProfiles = imageFormatMap.get(supportedImageFormat);
                for (Long supportedDynamicRangeProfile : supportedDynamicRangeProfiles) {
                    dynamicRangeProfiles.add(supportedDynamicRangeProfile);
                }
            }
        } else {
            dynamicRangeProfiles = imageFormatMap.get(imageFormat);
            if (dynamicRangeProfiles == null) {
                return new ArraySet<Long>();
            }
        }
        return dynamicRangeProfiles;
    }

    public Set<ColorSpace.Named> getSupportedColorSpacesForDynamicRange(int imageFormat, long dynamicRangeProfile) {
        ArraySet<ColorSpace.Named> supportedColorSpaceProfiles = new ArraySet<ColorSpace.Named>();
        for (ColorSpace.Named colorSpace : this.mProfileMap.keySet()) {
            Set<Long> dynamicRangeProfiles;
            Map<Integer, Set<Long>> imageFormatMap = this.mProfileMap.get((Object)colorSpace);
            if (imageFormat == 0) {
                for (int supportedImageFormat : imageFormatMap.keySet()) {
                    Set<Long> dynamicRangeProfiles2 = imageFormatMap.get(supportedImageFormat);
                    if (!dynamicRangeProfiles2.contains(dynamicRangeProfile)) continue;
                    supportedColorSpaceProfiles.add(colorSpace);
                }
                continue;
            }
            if (!imageFormatMap.containsKey(imageFormat) || !(dynamicRangeProfiles = imageFormatMap.get(imageFormat)).contains(dynamicRangeProfile)) continue;
            supportedColorSpaceProfiles.add(colorSpace);
        }
        return supportedColorSpaceProfiles;
    }
}

