/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.SuppressLint;
import android.hardware.camera2.utils.HashCodeHelpers;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class DeviceStateSensorOrientationMap {
    public static final long NORMAL = 0L;
    public static final long FOLDED = 4L;
    private final HashMap<Long, Integer> mDeviceStateOrientationMap;
    private final long[] mElements;

    public DeviceStateSensorOrientationMap(long[] elements) {
        this.mElements = Objects.requireNonNull(elements, "elements must not be null");
        this.mDeviceStateOrientationMap = new HashMap();
        if (elements.length % 2 != 0) {
            throw new IllegalArgumentException("Device state sensor orientation map length " + elements.length + " is not even!");
        }
        for (int i = 0; i < elements.length; i += 2) {
            if (elements[i + 1] % 90L != 0L) {
                throw new IllegalArgumentException("Sensor orientation not divisible by 90: " + elements[i + 1]);
            }
            this.mDeviceStateOrientationMap.put(elements[i], Math.toIntExact(elements[i + 1]));
        }
    }

    private DeviceStateSensorOrientationMap(ArrayList<Long> elements, HashMap<Long, Integer> deviceStateOrientationMap) {
        this.mElements = new long[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            this.mElements[i] = elements.get(i);
        }
        this.mDeviceStateOrientationMap = deviceStateOrientationMap;
    }

    public int getSensorOrientation(long deviceState) {
        if (!this.mDeviceStateOrientationMap.containsKey(deviceState)) {
            throw new IllegalArgumentException("Invalid device state: " + deviceState);
        }
        return this.mDeviceStateOrientationMap.get(deviceState);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeviceStateSensorOrientationMap) {
            DeviceStateSensorOrientationMap other = (DeviceStateSensorOrientationMap)obj;
            return Arrays.equals(this.mElements, other.mElements);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCodeGeneric(new long[][]{this.mElements});
    }

    public static class Builder {
        private final ArrayList<Long> mElements = new ArrayList();
        private final HashMap<Long, Integer> mDeviceStateOrientationMap = new HashMap();

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addOrientationForState(long deviceState, long angle) {
            if (angle % 90L != 0L) {
                throw new IllegalArgumentException("Sensor orientation not divisible by 90: " + angle);
            }
            this.mDeviceStateOrientationMap.put(deviceState, Math.toIntExact(angle));
            this.mElements.add(deviceState);
            this.mElements.add(angle);
            return this;
        }

        public DeviceStateSensorOrientationMap build() {
            if (this.mElements.size() == 0) {
                throw new IllegalStateException("Cannot build a DeviceStateSensorOrientationMap with zero elements.");
            }
            return new DeviceStateSensorOrientationMap(this.mElements, this.mDeviceStateOrientationMap);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceState {
    }
}

