/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.devicestate.DeviceStateManagerGlobal;
import android.hardware.devicestate.DeviceStateRequest;
import com.android.internal.util.ArrayUtils;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DeviceStateManager {
    public static final int INVALID_DEVICE_STATE = -1;
    public static final int MINIMUM_DEVICE_STATE = 0;
    public static final int MAXIMUM_DEVICE_STATE = 255;
    public static final String ACTION_SHOW_REAR_DISPLAY_OVERLAY = "com.android.intent.action.SHOW_REAR_DISPLAY_OVERLAY";
    public static final String EXTRA_ORIGINAL_DEVICE_BASE_STATE = "original_device_base_state";
    private final DeviceStateManagerGlobal mGlobal;

    public DeviceStateManager() {
        DeviceStateManagerGlobal global = DeviceStateManagerGlobal.getInstance();
        if (global == null) {
            throw new IllegalStateException("Failed to get instance of global device state manager.");
        }
        this.mGlobal = global;
    }

    public int[] getSupportedStates() {
        return this.mGlobal.getSupportedStates();
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void requestState(DeviceStateRequest request, Executor executor, DeviceStateRequest.Callback callback) {
        this.mGlobal.requestState(request, executor, callback);
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void cancelStateRequest() {
        this.mGlobal.cancelStateRequest();
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void requestBaseStateOverride(DeviceStateRequest request, Executor executor, DeviceStateRequest.Callback callback) {
        this.mGlobal.requestBaseStateOverride(request, executor, callback);
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void cancelBaseStateOverride() {
        this.mGlobal.cancelBaseStateOverride();
    }

    public void registerCallback(Executor executor, DeviceStateCallback callback) {
        this.mGlobal.registerDeviceStateCallback(callback, executor);
    }

    public void unregisterCallback(DeviceStateCallback callback) {
        this.mGlobal.unregisterDeviceStateCallback(callback);
    }

    public static interface DeviceStateCallback {
        default public void onSupportedStatesChanged(int[] supportedStates) {
        }

        default public void onBaseStateChanged(int state) {
        }

        public void onStateChanged(int var1);
    }

    public static class FoldStateListener
    implements DeviceStateCallback {
        private final int[] mFoldedDeviceStates;
        private final Consumer<Boolean> mDelegate;
        private Boolean lastResult;

        public FoldStateListener(Context context) {
            this(context, folded -> {});
        }

        public FoldStateListener(Context context, Consumer<Boolean> listener) {
            this.mFoldedDeviceStates = context.getResources().getIntArray(17236074);
            this.mDelegate = listener;
        }

        @Override
        public void onStateChanged(int state) {
            boolean folded = ArrayUtils.contains(this.mFoldedDeviceStates, state);
            if (this.lastResult == null || !this.lastResult.equals(folded)) {
                this.lastResult = folded;
                this.mDelegate.accept(folded);
            }
        }

        public Boolean getFolded() {
            return this.lastResult;
        }
    }
}

