/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.RequiresPermission;
import android.hardware.devicestate.DeviceStateInfo;
import android.hardware.devicestate.IDeviceStateManagerCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDeviceStateManager
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.devicestate.IDeviceStateManager";

    public DeviceStateInfo getDeviceStateInfo() throws RemoteException;

    public void registerCallback(IDeviceStateManagerCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void requestState(IBinder var1, int var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void cancelStateRequest() throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void requestBaseStateOverride(IBinder var1, int var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void cancelBaseStateOverride() throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void onStateRequestOverlayDismissed(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDeviceStateManager {
        static final int TRANSACTION_getDeviceStateInfo = 1;
        static final int TRANSACTION_registerCallback = 2;
        static final int TRANSACTION_requestState = 3;
        static final int TRANSACTION_cancelStateRequest = 4;
        static final int TRANSACTION_requestBaseStateOverride = 5;
        static final int TRANSACTION_cancelBaseStateOverride = 6;
        static final int TRANSACTION_onStateRequestOverlayDismissed = 7;

        public Stub() {
            this.attachInterface(this, IDeviceStateManager.DESCRIPTOR);
        }

        public static IDeviceStateManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDeviceStateManager.DESCRIPTOR);
            if (iin != null && iin instanceof IDeviceStateManager) {
                return (IDeviceStateManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDeviceStateInfo";
                }
                case 2: {
                    return "registerCallback";
                }
                case 3: {
                    return "requestState";
                }
                case 4: {
                    return "cancelStateRequest";
                }
                case 5: {
                    return "requestBaseStateOverride";
                }
                case 6: {
                    return "cancelBaseStateOverride";
                }
                case 7: {
                    return "onStateRequestOverlayDismissed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDeviceStateManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    DeviceStateInfo _result = this.getDeviceStateInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    IDeviceStateManagerCallback _arg0 = IDeviceStateManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.cancelStateRequest();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestBaseStateOverride(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.cancelBaseStateOverride();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onStateRequestOverlayDismissed(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IDeviceStateManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDeviceStateManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DeviceStateInfo getDeviceStateInfo() throws RemoteException {
                DeviceStateInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DeviceStateInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IDeviceStateManagerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestState(IBinder token, int state, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(state);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelStateRequest() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestBaseStateOverride(IBinder token, int state, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(state);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelBaseStateOverride() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateRequestOverlayDismissed(boolean shouldCancelRequest) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManager.DESCRIPTOR);
                    _data.writeBoolean(shouldCancelRequest);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDeviceStateManager {
        @Override
        public DeviceStateInfo getDeviceStateInfo() throws RemoteException {
            return null;
        }

        @Override
        public void registerCallback(IDeviceStateManagerCallback callback) throws RemoteException {
        }

        @Override
        public void requestState(IBinder token, int state, int flags) throws RemoteException {
        }

        @Override
        public void cancelStateRequest() throws RemoteException {
        }

        @Override
        public void requestBaseStateOverride(IBinder token, int state, int flags) throws RemoteException {
        }

        @Override
        public void cancelBaseStateOverride() throws RemoteException {
        }

        @Override
        public void onStateRequestOverlayDismissed(boolean shouldCancelRequest) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

