/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.NonNull;
import android.hardware.biometrics.AuthenticateOptions;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class FaceAuthenticateOptions
implements AuthenticateOptions,
Parcelable {
    private final int mUserId;
    private int mSensorId;
    private final int mDisplayState;
    public static final int AUTHENTICATE_REASON_UNKNOWN = 0;
    public static final int AUTHENTICATE_REASON_STARTED_WAKING_UP = 1;
    public static final int AUTHENTICATE_REASON_PRIMARY_BOUNCER_SHOWN = 2;
    public static final int AUTHENTICATE_REASON_ASSISTANT_VISIBLE = 3;
    public static final int AUTHENTICATE_REASON_ALTERNATE_BIOMETRIC_BOUNCER_SHOWN = 4;
    public static final int AUTHENTICATE_REASON_NOTIFICATION_PANEL_CLICKED = 5;
    public static final int AUTHENTICATE_REASON_OCCLUDING_APP_REQUESTED = 6;
    public static final int AUTHENTICATE_REASON_PICK_UP_GESTURE_TRIGGERED = 7;
    public static final int AUTHENTICATE_REASON_QS_EXPANDED = 8;
    public static final int AUTHENTICATE_REASON_SWIPE_UP_ON_BOUNCER = 9;
    public static final int AUTHENTICATE_REASON_UDFPS_POINTER_DOWN = 10;
    private final int mAuthenticateReason;
    private final int mWakeReason;
    private String mOpPackageName;
    private String mAttributionTag;
    public static final Parcelable.Creator<FaceAuthenticateOptions> CREATOR = new Parcelable.Creator<FaceAuthenticateOptions>(){

        public FaceAuthenticateOptions[] newArray(int size) {
            return new FaceAuthenticateOptions[size];
        }

        @Override
        public FaceAuthenticateOptions createFromParcel(Parcel in) {
            return new FaceAuthenticateOptions(in);
        }
    };

    private static int defaultUserId() {
        return 0;
    }

    private static int defaultSensorId() {
        return -1;
    }

    private static int defaultDisplayState() {
        return 0;
    }

    private static int defaultAuthenticateReason() {
        return 0;
    }

    private static int defaultWakeReason() {
        return 0;
    }

    private static String defaultOpPackageName() {
        return "";
    }

    private static String defaultAttributionTag() {
        return null;
    }

    public static String authenticateReasonToString(int value) {
        switch (value) {
            case 0: {
                return "AUTHENTICATE_REASON_UNKNOWN";
            }
            case 1: {
                return "AUTHENTICATE_REASON_STARTED_WAKING_UP";
            }
            case 2: {
                return "AUTHENTICATE_REASON_PRIMARY_BOUNCER_SHOWN";
            }
            case 3: {
                return "AUTHENTICATE_REASON_ASSISTANT_VISIBLE";
            }
            case 4: {
                return "AUTHENTICATE_REASON_ALTERNATE_BIOMETRIC_BOUNCER_SHOWN";
            }
            case 5: {
                return "AUTHENTICATE_REASON_NOTIFICATION_PANEL_CLICKED";
            }
            case 6: {
                return "AUTHENTICATE_REASON_OCCLUDING_APP_REQUESTED";
            }
            case 7: {
                return "AUTHENTICATE_REASON_PICK_UP_GESTURE_TRIGGERED";
            }
            case 8: {
                return "AUTHENTICATE_REASON_QS_EXPANDED";
            }
            case 9: {
                return "AUTHENTICATE_REASON_SWIPE_UP_ON_BOUNCER";
            }
            case 10: {
                return "AUTHENTICATE_REASON_UDFPS_POINTER_DOWN";
            }
        }
        return Integer.toHexString(value);
    }

    FaceAuthenticateOptions(int userId, int sensorId, int displayState, int authenticateReason, int wakeReason, String opPackageName, String attributionTag) {
        this.mUserId = userId;
        this.mSensorId = sensorId;
        this.mDisplayState = displayState;
        AnnotationValidations.validate(AuthenticateOptions.DisplayState.class, null, this.mDisplayState);
        this.mAuthenticateReason = authenticateReason;
        if (this.mAuthenticateReason != 0 && this.mAuthenticateReason != 1 && this.mAuthenticateReason != 2 && this.mAuthenticateReason != 3 && this.mAuthenticateReason != 4 && this.mAuthenticateReason != 5 && this.mAuthenticateReason != 6 && this.mAuthenticateReason != 7 && this.mAuthenticateReason != 8 && this.mAuthenticateReason != 9 && this.mAuthenticateReason != 10) {
            throw new IllegalArgumentException("authenticateReason was " + this.mAuthenticateReason + " but must be one of: AUTHENTICATE_REASON_UNKNOWN(" + 0 + "), AUTHENTICATE_REASON_STARTED_WAKING_UP(" + 1 + "), AUTHENTICATE_REASON_PRIMARY_BOUNCER_SHOWN(" + 2 + "), AUTHENTICATE_REASON_ASSISTANT_VISIBLE(" + 3 + "), AUTHENTICATE_REASON_ALTERNATE_BIOMETRIC_BOUNCER_SHOWN(" + 4 + "), AUTHENTICATE_REASON_NOTIFICATION_PANEL_CLICKED(" + 5 + "), AUTHENTICATE_REASON_OCCLUDING_APP_REQUESTED(" + 6 + "), AUTHENTICATE_REASON_PICK_UP_GESTURE_TRIGGERED(" + 7 + "), AUTHENTICATE_REASON_QS_EXPANDED(" + 8 + "), AUTHENTICATE_REASON_SWIPE_UP_ON_BOUNCER(" + 9 + "), AUTHENTICATE_REASON_UDFPS_POINTER_DOWN(" + 10 + ")");
        }
        this.mWakeReason = wakeReason;
        AnnotationValidations.validate(PowerManager.WakeReason.class, null, this.mWakeReason);
        this.mOpPackageName = opPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOpPackageName);
        this.mAttributionTag = attributionTag;
    }

    @Override
    public int getUserId() {
        return this.mUserId;
    }

    @Override
    public int getSensorId() {
        return this.mSensorId;
    }

    @Override
    public int getDisplayState() {
        return this.mDisplayState;
    }

    public int getAuthenticateReason() {
        return this.mAuthenticateReason;
    }

    public int getWakeReason() {
        return this.mWakeReason;
    }

    @Override
    public String getOpPackageName() {
        return this.mOpPackageName;
    }

    @Override
    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    public FaceAuthenticateOptions setSensorId(int value) {
        this.mSensorId = value;
        return this;
    }

    public FaceAuthenticateOptions setOpPackageName(String value) {
        this.mOpPackageName = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOpPackageName);
        return this;
    }

    public FaceAuthenticateOptions setAttributionTag(String value) {
        this.mAttributionTag = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaceAuthenticateOptions that = (FaceAuthenticateOptions)o;
        return this.mUserId == that.mUserId && this.mSensorId == that.mSensorId && this.mDisplayState == that.mDisplayState && this.mAuthenticateReason == that.mAuthenticateReason && this.mWakeReason == that.mWakeReason && Objects.equals(this.mOpPackageName, that.mOpPackageName) && Objects.equals(this.mAttributionTag, that.mAttributionTag);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mUserId;
        _hash = 31 * _hash + this.mSensorId;
        _hash = 31 * _hash + this.mDisplayState;
        _hash = 31 * _hash + this.mAuthenticateReason;
        _hash = 31 * _hash + this.mWakeReason;
        _hash = 31 * _hash + Objects.hashCode(this.mOpPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAttributionTag != null) {
            flg = (byte)(flg | 0x40);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mUserId);
        dest.writeInt(this.mSensorId);
        dest.writeInt(this.mDisplayState);
        dest.writeInt(this.mAuthenticateReason);
        dest.writeInt(this.mWakeReason);
        dest.writeString(this.mOpPackageName);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected FaceAuthenticateOptions(Parcel in) {
        byte flg = in.readByte();
        int userId = in.readInt();
        int sensorId = in.readInt();
        int displayState = in.readInt();
        int authenticateReason = in.readInt();
        int wakeReason = in.readInt();
        String opPackageName = in.readString();
        String attributionTag = (flg & 0x40) == 0 ? null : in.readString();
        this.mUserId = userId;
        this.mSensorId = sensorId;
        this.mDisplayState = displayState;
        AnnotationValidations.validate(AuthenticateOptions.DisplayState.class, null, this.mDisplayState);
        this.mAuthenticateReason = authenticateReason;
        if (this.mAuthenticateReason != 0 && this.mAuthenticateReason != 1 && this.mAuthenticateReason != 2 && this.mAuthenticateReason != 3 && this.mAuthenticateReason != 4 && this.mAuthenticateReason != 5 && this.mAuthenticateReason != 6 && this.mAuthenticateReason != 7 && this.mAuthenticateReason != 8 && this.mAuthenticateReason != 9 && this.mAuthenticateReason != 10) {
            throw new IllegalArgumentException("authenticateReason was " + this.mAuthenticateReason + " but must be one of: AUTHENTICATE_REASON_UNKNOWN(" + 0 + "), AUTHENTICATE_REASON_STARTED_WAKING_UP(" + 1 + "), AUTHENTICATE_REASON_PRIMARY_BOUNCER_SHOWN(" + 2 + "), AUTHENTICATE_REASON_ASSISTANT_VISIBLE(" + 3 + "), AUTHENTICATE_REASON_ALTERNATE_BIOMETRIC_BOUNCER_SHOWN(" + 4 + "), AUTHENTICATE_REASON_NOTIFICATION_PANEL_CLICKED(" + 5 + "), AUTHENTICATE_REASON_OCCLUDING_APP_REQUESTED(" + 6 + "), AUTHENTICATE_REASON_PICK_UP_GESTURE_TRIGGERED(" + 7 + "), AUTHENTICATE_REASON_QS_EXPANDED(" + 8 + "), AUTHENTICATE_REASON_SWIPE_UP_ON_BOUNCER(" + 9 + "), AUTHENTICATE_REASON_UDFPS_POINTER_DOWN(" + 10 + ")");
        }
        this.mWakeReason = wakeReason;
        AnnotationValidations.validate(PowerManager.WakeReason.class, null, this.mWakeReason);
        this.mOpPackageName = opPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOpPackageName);
        this.mAttributionTag = attributionTag;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private int mUserId;
        private int mSensorId;
        private int mDisplayState;
        private int mAuthenticateReason;
        private int mWakeReason;
        private String mOpPackageName;
        private String mAttributionTag;
        private long mBuilderFieldsSet = 0L;

        public Builder setUserId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mUserId = value;
            return this;
        }

        public Builder setSensorId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mSensorId = value;
            return this;
        }

        public Builder setDisplayState(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mDisplayState = value;
            return this;
        }

        public Builder setAuthenticateReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mAuthenticateReason = value;
            return this;
        }

        public Builder setWakeReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mWakeReason = value;
            return this;
        }

        public Builder setOpPackageName(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mOpPackageName = value;
            return this;
        }

        public Builder setAttributionTag(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mAttributionTag = value;
            return this;
        }

        public FaceAuthenticateOptions build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mUserId = FaceAuthenticateOptions.defaultUserId();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mSensorId = FaceAuthenticateOptions.defaultSensorId();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mDisplayState = FaceAuthenticateOptions.defaultDisplayState();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mAuthenticateReason = FaceAuthenticateOptions.defaultAuthenticateReason();
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mWakeReason = FaceAuthenticateOptions.defaultWakeReason();
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mOpPackageName = FaceAuthenticateOptions.defaultOpPackageName();
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mAttributionTag = FaceAuthenticateOptions.defaultAttributionTag();
            }
            FaceAuthenticateOptions o = new FaceAuthenticateOptions(this.mUserId, this.mSensorId, this.mDisplayState, this.mAuthenticateReason, this.mWakeReason, this.mOpPackageName, this.mAttributionTag);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x80L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthenticateReason {
    }
}

