/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUdfpsRefreshRateRequestCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.fingerprint.IUdfpsRefreshRateRequestCallback";

    public void onRequestEnabled(int var1) throws RemoteException;

    public void onRequestDisabled(int var1) throws RemoteException;

    public void onAuthenticationPossible(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUdfpsRefreshRateRequestCallback {
        static final int TRANSACTION_onRequestEnabled = 1;
        static final int TRANSACTION_onRequestDisabled = 2;
        static final int TRANSACTION_onAuthenticationPossible = 3;

        public Stub() {
            this.attachInterface(this, IUdfpsRefreshRateRequestCallback.DESCRIPTOR);
        }

        public static IUdfpsRefreshRateRequestCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUdfpsRefreshRateRequestCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IUdfpsRefreshRateRequestCallback) {
                return (IUdfpsRefreshRateRequestCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRequestEnabled";
                }
                case 2: {
                    return "onRequestDisabled";
                }
                case 3: {
                    return "onAuthenticationPossible";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUdfpsRefreshRateRequestCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestEnabled(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestDisabled(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAuthenticationPossible(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IUdfpsRefreshRateRequestCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUdfpsRefreshRateRequestCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestEnabled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUdfpsRefreshRateRequestCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestDisabled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUdfpsRefreshRateRequestCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationPossible(int displayId, boolean isPossible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUdfpsRefreshRateRequestCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(isPossible);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUdfpsRefreshRateRequestCallback {
        @Override
        public void onRequestEnabled(int displayId) throws RemoteException {
        }

        @Override
        public void onRequestDisabled(int displayId) throws RemoteException {
        }

        @Override
        public void onAuthenticationPossible(int displayId, boolean isPossible) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

