/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import java.util.Objects;

public class DeviceFeatures {
    public static final int FEATURE_NOT_SUPPORTED = 0;
    public static final int FEATURE_SUPPORTED = 1;
    public static final int FEATURE_SUPPORT_UNKNOWN = 2;
    public static final DeviceFeatures ALL_FEATURES_SUPPORT_UNKNOWN = new Builder(2).build();
    public static final DeviceFeatures NO_FEATURES_SUPPORTED = new Builder(0).build();
    @FeatureSupportStatus
    private final int mRecordTvScreenSupport;
    @FeatureSupportStatus
    private final int mSetOsdStringSupport;
    @FeatureSupportStatus
    private final int mDeckControlSupport;
    @FeatureSupportStatus
    private final int mSetAudioRateSupport;
    @FeatureSupportStatus
    private final int mArcTxSupport;
    @FeatureSupportStatus
    private final int mArcRxSupport;
    @FeatureSupportStatus
    private final int mSetAudioVolumeLevelSupport;

    private DeviceFeatures(Builder builder) {
        this.mRecordTvScreenSupport = builder.mRecordTvScreenSupport;
        this.mSetOsdStringSupport = builder.mOsdStringSupport;
        this.mDeckControlSupport = builder.mDeckControlSupport;
        this.mSetAudioRateSupport = builder.mSetAudioRateSupport;
        this.mArcTxSupport = builder.mArcTxSupport;
        this.mArcRxSupport = builder.mArcRxSupport;
        this.mSetAudioVolumeLevelSupport = builder.mSetAudioVolumeLevelSupport;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceFeatures fromOperand(byte[] deviceFeaturesOperand) {
        Builder builder = new Builder(2);
        if (deviceFeaturesOperand.length >= 1) {
            byte b = deviceFeaturesOperand[0];
            builder.setRecordTvScreenSupport(DeviceFeatures.bitToFeatureSupportStatus((b >> 6 & 1) == 1)).setSetOsdStringSupport(DeviceFeatures.bitToFeatureSupportStatus((b >> 5 & 1) == 1)).setDeckControlSupport(DeviceFeatures.bitToFeatureSupportStatus((b >> 4 & 1) == 1)).setSetAudioRateSupport(DeviceFeatures.bitToFeatureSupportStatus((b >> 3 & 1) == 1)).setArcTxSupport(DeviceFeatures.bitToFeatureSupportStatus((b >> 2 & 1) == 1)).setArcRxSupport(DeviceFeatures.bitToFeatureSupportStatus((b >> 1 & 1) == 1)).setSetAudioVolumeLevelSupport(DeviceFeatures.bitToFeatureSupportStatus((b & 1) == 1));
        }
        return builder.build();
    }

    @FeatureSupportStatus
    private static int updateFeatureSupportStatus(@FeatureSupportStatus int oldStatus, @FeatureSupportStatus int newStatus) {
        if (newStatus == 2) {
            return oldStatus;
        }
        return newStatus;
    }

    public byte[] toOperand() {
        byte result = 0;
        if (this.mRecordTvScreenSupport == 1) {
            result = (byte)(result | 0x40);
        }
        if (this.mSetOsdStringSupport == 1) {
            result = (byte)(result | 0x20);
        }
        if (this.mDeckControlSupport == 1) {
            result = (byte)(result | 0x10);
        }
        if (this.mSetAudioRateSupport == 1) {
            result = (byte)(result | 8);
        }
        if (this.mArcTxSupport == 1) {
            result = (byte)(result | 4);
        }
        if (this.mArcRxSupport == 1) {
            result = (byte)(result | 2);
        }
        if (this.mSetAudioVolumeLevelSupport == 1) {
            result = (byte)(result | 1);
        }
        return new byte[]{result};
    }

    @FeatureSupportStatus
    private static int bitToFeatureSupportStatus(boolean bit) {
        return bit ? 1 : 0;
    }

    @FeatureSupportStatus
    public int getRecordTvScreenSupport() {
        return this.mRecordTvScreenSupport;
    }

    @FeatureSupportStatus
    public int getSetOsdStringSupport() {
        return this.mSetOsdStringSupport;
    }

    @FeatureSupportStatus
    public int getDeckControlSupport() {
        return this.mDeckControlSupport;
    }

    @FeatureSupportStatus
    public int getSetAudioRateSupport() {
        return this.mSetAudioRateSupport;
    }

    @FeatureSupportStatus
    public int getArcTxSupport() {
        return this.mArcTxSupport;
    }

    @FeatureSupportStatus
    public int getArcRxSupport() {
        return this.mArcRxSupport;
    }

    @FeatureSupportStatus
    public int getSetAudioVolumeLevelSupport() {
        return this.mSetAudioVolumeLevelSupport;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceFeatures)) {
            return false;
        }
        DeviceFeatures other = (DeviceFeatures)obj;
        return this.mRecordTvScreenSupport == other.mRecordTvScreenSupport && this.mSetOsdStringSupport == other.mSetOsdStringSupport && this.mDeckControlSupport == other.mDeckControlSupport && this.mSetAudioRateSupport == other.mSetAudioRateSupport && this.mArcTxSupport == other.mArcTxSupport && this.mArcRxSupport == other.mArcRxSupport && this.mSetAudioVolumeLevelSupport == other.mSetAudioVolumeLevelSupport;
    }

    public int hashCode() {
        return Objects.hash(this.mRecordTvScreenSupport, this.mSetOsdStringSupport, this.mDeckControlSupport, this.mSetAudioRateSupport, this.mArcTxSupport, this.mArcRxSupport, this.mSetAudioVolumeLevelSupport);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Device features: ");
        s.append("record_tv_screen: ").append(DeviceFeatures.featureSupportStatusToString(this.mRecordTvScreenSupport)).append(" ");
        s.append("set_osd_string: ").append(DeviceFeatures.featureSupportStatusToString(this.mSetOsdStringSupport)).append(" ");
        s.append("deck_control: ").append(DeviceFeatures.featureSupportStatusToString(this.mDeckControlSupport)).append(" ");
        s.append("set_audio_rate: ").append(DeviceFeatures.featureSupportStatusToString(this.mSetAudioRateSupport)).append(" ");
        s.append("arc_tx: ").append(DeviceFeatures.featureSupportStatusToString(this.mArcTxSupport)).append(" ");
        s.append("arc_rx: ").append(DeviceFeatures.featureSupportStatusToString(this.mArcRxSupport)).append(" ");
        s.append("set_audio_volume_level: ").append(DeviceFeatures.featureSupportStatusToString(this.mSetAudioVolumeLevelSupport)).append(" ");
        return s.toString();
    }

    private static String featureSupportStatusToString(@FeatureSupportStatus int status) {
        switch (status) {
            case 1: {
                return "Y";
            }
            case 0: {
                return "N";
            }
        }
        return "?";
    }

    public static class Builder {
        @FeatureSupportStatus
        private int mRecordTvScreenSupport;
        @FeatureSupportStatus
        private int mOsdStringSupport;
        @FeatureSupportStatus
        private int mDeckControlSupport;
        @FeatureSupportStatus
        private int mSetAudioRateSupport;
        @FeatureSupportStatus
        private int mArcTxSupport;
        @FeatureSupportStatus
        private int mArcRxSupport;
        @FeatureSupportStatus
        private int mSetAudioVolumeLevelSupport;

        private Builder(@FeatureSupportStatus int defaultFeatureSupportStatus) {
            this.mRecordTvScreenSupport = defaultFeatureSupportStatus;
            this.mOsdStringSupport = defaultFeatureSupportStatus;
            this.mDeckControlSupport = defaultFeatureSupportStatus;
            this.mSetAudioRateSupport = defaultFeatureSupportStatus;
            this.mArcTxSupport = defaultFeatureSupportStatus;
            this.mArcRxSupport = defaultFeatureSupportStatus;
            this.mSetAudioVolumeLevelSupport = defaultFeatureSupportStatus;
        }

        private Builder(DeviceFeatures info) {
            this.mRecordTvScreenSupport = info.getRecordTvScreenSupport();
            this.mOsdStringSupport = info.getSetOsdStringSupport();
            this.mDeckControlSupport = info.getDeckControlSupport();
            this.mSetAudioRateSupport = info.getSetAudioRateSupport();
            this.mArcTxSupport = info.getArcTxSupport();
            this.mArcRxSupport = info.getArcRxSupport();
            this.mSetAudioVolumeLevelSupport = info.getSetAudioVolumeLevelSupport();
        }

        public DeviceFeatures build() {
            return new DeviceFeatures(this);
        }

        public Builder setRecordTvScreenSupport(@FeatureSupportStatus int recordTvScreenSupport) {
            this.mRecordTvScreenSupport = recordTvScreenSupport;
            return this;
        }

        public Builder setSetOsdStringSupport(@FeatureSupportStatus int setOsdStringSupport) {
            this.mOsdStringSupport = setOsdStringSupport;
            return this;
        }

        public Builder setDeckControlSupport(@FeatureSupportStatus int deckControlSupport) {
            this.mDeckControlSupport = deckControlSupport;
            return this;
        }

        public Builder setSetAudioRateSupport(@FeatureSupportStatus int setAudioRateSupport) {
            this.mSetAudioRateSupport = setAudioRateSupport;
            return this;
        }

        public Builder setArcTxSupport(@FeatureSupportStatus int arcTxSupport) {
            this.mArcTxSupport = arcTxSupport;
            return this;
        }

        public Builder setArcRxSupport(@FeatureSupportStatus int arcRxSupport) {
            this.mArcRxSupport = arcRxSupport;
            return this;
        }

        public Builder setSetAudioVolumeLevelSupport(@FeatureSupportStatus int setAudioVolumeLevelSupport) {
            this.mSetAudioVolumeLevelSupport = setAudioVolumeLevelSupport;
            return this;
        }

        public Builder update(DeviceFeatures newDeviceFeatures) {
            this.mRecordTvScreenSupport = DeviceFeatures.updateFeatureSupportStatus(this.mRecordTvScreenSupport, newDeviceFeatures.getRecordTvScreenSupport());
            this.mOsdStringSupport = DeviceFeatures.updateFeatureSupportStatus(this.mOsdStringSupport, newDeviceFeatures.getSetOsdStringSupport());
            this.mDeckControlSupport = DeviceFeatures.updateFeatureSupportStatus(this.mDeckControlSupport, newDeviceFeatures.getDeckControlSupport());
            this.mSetAudioRateSupport = DeviceFeatures.updateFeatureSupportStatus(this.mSetAudioRateSupport, newDeviceFeatures.getSetAudioRateSupport());
            this.mArcTxSupport = DeviceFeatures.updateFeatureSupportStatus(this.mArcTxSupport, newDeviceFeatures.getArcTxSupport());
            this.mArcRxSupport = DeviceFeatures.updateFeatureSupportStatus(this.mArcRxSupport, newDeviceFeatures.getArcRxSupport());
            this.mSetAudioVolumeLevelSupport = DeviceFeatures.updateFeatureSupportStatus(this.mSetAudioVolumeLevelSupport, newDeviceFeatures.getSetAudioVolumeLevelSupport());
            return this;
        }
    }

    public static @interface FeatureSupportStatus {
    }
}

