/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.hardware.input.IKeyboardBacklightState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IKeyboardBacklightListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.input.IKeyboardBacklightListener";

    public void onBrightnessChanged(int var1, IKeyboardBacklightState var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeyboardBacklightListener {
        static final int TRANSACTION_onBrightnessChanged = 1;

        public Stub() {
            this.attachInterface(this, IKeyboardBacklightListener.DESCRIPTOR);
        }

        public static IKeyboardBacklightListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IKeyboardBacklightListener.DESCRIPTOR);
            if (iin != null && iin instanceof IKeyboardBacklightListener) {
                return (IKeyboardBacklightListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onBrightnessChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IKeyboardBacklightListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    IKeyboardBacklightState _arg1 = data.readTypedObject(IKeyboardBacklightState.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onBrightnessChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IKeyboardBacklightListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IKeyboardBacklightListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBrightnessChanged(int deviceId, IKeyboardBacklightState state, boolean isTriggeredByKeyPress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IKeyboardBacklightListener.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeTypedObject(state, 0);
                    _data.writeBoolean(isTriggeredByKeyPress);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IKeyboardBacklightListener {
        @Override
        public void onBrightnessChanged(int deviceId, IKeyboardBacklightState state, boolean isTriggeredByKeyPress) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

