/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.hardware.input.InputDeviceVibrator;
import android.hardware.input.InputManager;
import android.hardware.input.InputManagerGlobal;
import android.os.Binder;
import android.os.CombinedVibration;
import android.os.IBinder;
import android.os.NullVibrator;
import android.os.VibrationAttributes;
import android.os.Vibrator;
import android.os.VibratorManager;
import android.util.SparseArray;
import android.view.InputDevice;
import com.android.internal.annotations.GuardedBy;

public class InputDeviceVibratorManager
extends VibratorManager
implements InputManager.InputDeviceListener {
    private static final String TAG = "InputDeviceVibratorManager";
    private static final boolean DEBUG = false;
    private final Binder mToken;
    private final InputManagerGlobal mGlobal;
    private final int mDeviceId;
    @GuardedBy(value={"mVibrators"})
    private final SparseArray<Vibrator> mVibrators = new SparseArray();

    public InputDeviceVibratorManager(int deviceId) {
        this.mGlobal = InputManagerGlobal.getInstance();
        this.mDeviceId = deviceId;
        this.mToken = new Binder();
        this.initializeVibrators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVibrators() {
        SparseArray<Vibrator> sparseArray = this.mVibrators;
        synchronized (sparseArray) {
            this.mVibrators.clear();
            InputDevice inputDevice = InputDevice.getDevice(this.mDeviceId);
            int[] vibratorIds = this.mGlobal.getVibratorIds(this.mDeviceId);
            for (int i = 0; i < vibratorIds.length; ++i) {
                this.mVibrators.put(vibratorIds[i], new InputDeviceVibrator(this.mDeviceId, vibratorIds[i]));
            }
        }
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInputDeviceRemoved(int deviceId) {
        SparseArray<Vibrator> sparseArray = this.mVibrators;
        synchronized (sparseArray) {
            if (deviceId == this.mDeviceId) {
                this.mVibrators.clear();
            }
        }
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        if (deviceId == this.mDeviceId) {
            this.initializeVibrators();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getVibratorIds() {
        SparseArray<Vibrator> sparseArray = this.mVibrators;
        synchronized (sparseArray) {
            int[] vibratorIds = new int[this.mVibrators.size()];
            for (int idx = 0; idx < this.mVibrators.size(); ++idx) {
                vibratorIds[idx] = this.mVibrators.keyAt(idx);
            }
            return vibratorIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vibrator getVibrator(int vibratorId) {
        SparseArray<Vibrator> sparseArray = this.mVibrators;
        synchronized (sparseArray) {
            if (this.mVibrators.contains(vibratorId)) {
                return this.mVibrators.get(vibratorId);
            }
        }
        return NullVibrator.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vibrator getDefaultVibrator() {
        SparseArray<Vibrator> sparseArray = this.mVibrators;
        synchronized (sparseArray) {
            if (this.mVibrators.size() > 0) {
                return this.mVibrators.valueAt(0);
            }
        }
        return NullVibrator.getInstance();
    }

    @Override
    public void vibrate(int uid, String opPkg, CombinedVibration effect, String reason, VibrationAttributes attributes) {
        this.mGlobal.vibrate(this.mDeviceId, effect, (IBinder)this.mToken);
    }

    @Override
    public void cancel() {
        this.mGlobal.cancelVibrate(this.mDeviceId, this.mToken);
    }

    @Override
    public void cancel(int usageFilter) {
        this.cancel();
    }
}

