/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.BatteryState;
import android.hardware.input.HostUsiVersion;
import android.hardware.input.IInputManager;
import android.hardware.input.IInputSensorEventListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputDeviceVibrator;
import android.hardware.input.InputManagerGlobal;
import android.hardware.input.InputSensorInfo;
import android.hardware.input.InputSettings;
import android.hardware.input.KeyboardBacklightState;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Vibrator;
import android.util.Log;
import android.view.Display;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.PointerIcon;
import android.view.VerifiedInputEvent;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class InputManager {
    private static final String TAG = "InputManager";
    private static final boolean DEBUG = Log.isLoggable("InputManager", 3);
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final IInputManager mIm;
    private Boolean mIsStylusPointerIconEnabled = null;
    public static final String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    public static final String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static final long BLOCK_UNTRUSTED_TOUCHES = 158002302L;
    public static final int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    @UnsupportedAppUsage(trackingBug=171972397L)
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;
    public static final int SWITCH_STATE_UNKNOWN = -1;
    public static final int SWITCH_STATE_OFF = 0;
    public static final int SWITCH_STATE_ON = 1;
    private final InputManagerGlobal mGlobal = InputManagerGlobal.getInstance();
    private final Context mContext;

    public InputManager(Context context) {
        this.mIm = this.mGlobal.getInputManagerService();
        this.mContext = context;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static InputManager getInstance() {
        return Objects.requireNonNull(ActivityThread.currentApplication()).getSystemService(InputManager.class);
    }

    public String getVelocityTrackerStrategy() {
        return this.mGlobal.getVelocityTrackerStrategy();
    }

    public InputDevice getInputDevice(int id2) {
        return this.mGlobal.getInputDevice(id2);
    }

    public InputDevice getInputDeviceByDescriptor(String descriptor) {
        return this.mGlobal.getInputDeviceByDescriptor(descriptor);
    }

    public int[] getInputDeviceIds() {
        return this.mGlobal.getInputDeviceIds();
    }

    public boolean isInputDeviceEnabled(int id2) {
        return this.mGlobal.isInputDeviceEnabled(id2);
    }

    public void enableInputDevice(int id2) {
        this.mGlobal.enableInputDevice(id2);
    }

    public void disableInputDevice(int id2) {
        this.mGlobal.disableInputDevice(id2);
    }

    public void registerInputDeviceListener(InputDeviceListener listener, Handler handler) {
        this.mGlobal.registerInputDeviceListener(listener, handler);
    }

    public void unregisterInputDeviceListener(InputDeviceListener listener) {
        this.mGlobal.unregisterInputDeviceListener(listener);
    }

    public int isInTabletMode() {
        try {
            return this.mIm.isInTabletMode();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void registerOnTabletModeChangedListener(OnTabletModeChangedListener listener, Handler handler) {
        this.mGlobal.registerOnTabletModeChangedListener(listener, handler);
    }

    public void unregisterOnTabletModeChangedListener(OnTabletModeChangedListener listener) {
        this.mGlobal.unregisterOnTabletModeChangedListener(listener);
    }

    public int isMicMuted() {
        try {
            return this.mIm.isMicMuted();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        try {
            return this.mIm.getKeyboardLayouts();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public List<String> getKeyboardLayoutDescriptorsForInputDevice(InputDevice device) {
        KeyboardLayout[] layouts = this.getKeyboardLayoutsForInputDevice(device.getIdentifier());
        ArrayList<String> res = new ArrayList<String>();
        for (KeyboardLayout kl : layouts) {
            res.add(kl.getDescriptor());
        }
        return res;
    }

    public String getKeyboardLayoutTypeForLayoutDescriptor(String layoutDescriptor) {
        KeyboardLayout[] layouts;
        for (KeyboardLayout kl : layouts = this.getKeyboardLayouts()) {
            if (!layoutDescriptor.equals(kl.getDescriptor())) continue;
            return kl.getLayoutType();
        }
        return "";
    }

    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        return this.mGlobal.getKeyboardLayoutsForInputDevice(identifier);
    }

    public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayout(keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) {
        try {
            return this.mIm.getCurrentKeyboardLayoutForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        this.mGlobal.setCurrentKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
    }

    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getEnabledKeyboardLayoutsForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.addKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.removeKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public void remapModifierKey(int fromKey, int toKey) {
        try {
            this.mIm.remapModifierKey(fromKey, toKey);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public void clearAllModifierKeyRemappings() {
        try {
            this.mIm.clearAllModifierKeyRemappings();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public Map<Integer, Integer> getModifierKeyRemapping() {
        try {
            return this.mIm.getModifierKeyRemapping();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public TouchCalibration getTouchCalibration(String inputDeviceDescriptor, int surfaceRotation) {
        try {
            return this.mIm.getTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void setTouchCalibration(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        try {
            this.mIm.setTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation, calibration);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public String getKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) {
        try {
            return this.mIm.getKeyboardLayoutForInputDevice(identifier, userId, imeInfo, imeSubtype);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setKeyboardLayoutForInputDevice(identifier, userId, imeInfo, imeSubtype, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public KeyboardLayout[] getKeyboardLayoutListForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayoutListForInputDevice(identifier, userId, imeInfo, imeSubtype);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void tryPointerSpeed(int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(speed);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public float getMaximumObscuringOpacityForTouch() {
        return InputSettings.getMaximumObscuringOpacityForTouch(this.mContext);
    }

    public boolean[] deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    public boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        return this.mGlobal.deviceHasKeys(id2, keyCodes);
    }

    public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) {
        return this.mGlobal.getKeyCodeForKeyLocation(deviceId, locationKeyCode);
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    public boolean injectInputEvent(InputEvent event, int mode, int targetUid) {
        return this.mGlobal.injectInputEvent(event, mode, targetUid);
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    @UnsupportedAppUsage
    public boolean injectInputEvent(InputEvent event, int mode) {
        return this.mGlobal.injectInputEvent(event, mode);
    }

    public VerifiedInputEvent verifyInputEvent(InputEvent event) {
        try {
            return this.mIm.verifyInputEvent(event);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setPointerIconType(int iconId) {
        this.mGlobal.setPointerIconType(iconId);
    }

    public void setCustomPointerIcon(PointerIcon icon) {
        this.mGlobal.setCustomPointerIcon(icon);
    }

    public boolean isStylusPointerIconEnabled() {
        if (this.mIsStylusPointerIconEnabled == null) {
            this.mIsStylusPointerIconEnabled = InputSettings.isStylusPointerIconEnabled(this.mContext);
        }
        return this.mIsStylusPointerIconEnabled;
    }

    public void requestPointerCapture(IBinder windowToken, boolean enable) {
        this.mGlobal.requestPointerCapture(windowToken, enable);
    }

    public InputMonitor monitorGestureInput(String name, int displayId) {
        return this.mGlobal.monitorGestureInput(name, displayId);
    }

    public InputSensorInfo[] getSensorList(int deviceId) {
        return this.mGlobal.getSensorList(deviceId);
    }

    public boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) {
        return this.mGlobal.enableSensor(deviceId, sensorType, samplingPeriodUs, maxBatchReportLatencyUs);
    }

    public void disableSensor(int deviceId, int sensorType) {
        this.mGlobal.disableSensor(deviceId, sensorType);
    }

    public boolean flushSensor(int deviceId, int sensorType) {
        return this.mGlobal.flushSensor(deviceId, sensorType);
    }

    public boolean registerSensorListener(IInputSensorEventListener listener) {
        return this.mGlobal.registerSensorListener(listener);
    }

    public void unregisterSensorListener(IInputSensorEventListener listener) {
        this.mGlobal.unregisterSensorListener(listener);
    }

    public void addPortAssociation(String inputPort, int displayPort) {
        try {
            this.mIm.addPortAssociation(inputPort, displayPort);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void removePortAssociation(String inputPort) {
        try {
            this.mIm.removePortAssociation(inputPort);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void addUniqueIdAssociation(String inputPort, String displayUniqueId) {
        this.mGlobal.addUniqueIdAssociation(inputPort, displayUniqueId);
    }

    public void removeUniqueIdAssociation(String inputPort) {
        this.mGlobal.removeUniqueIdAssociation(inputPort);
    }

    public HostUsiVersion getHostUsiVersion(Display display) {
        return this.mGlobal.getHostUsiVersion(display);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public String getInputDeviceBluetoothAddress(int deviceId) {
        return this.mGlobal.getInputDeviceBluetoothAddress(deviceId);
    }

    public Vibrator getInputDeviceVibrator(int deviceId, int vibratorId) {
        return new InputDeviceVibrator(deviceId, vibratorId);
    }

    public void cancelCurrentTouch() {
        this.mGlobal.cancelCurrentTouch();
    }

    @RequiresPermission(value="android.permission.MONITOR_INPUT")
    public void pilferPointers(IBinder inputChannelToken) {
        this.mGlobal.pilferPointers(inputChannelToken);
    }

    public void addInputDeviceBatteryListener(int deviceId, Executor executor, InputDeviceBatteryListener listener) {
        this.mGlobal.addInputDeviceBatteryListener(deviceId, executor, listener);
    }

    public void removeInputDeviceBatteryListener(int deviceId, InputDeviceBatteryListener listener) {
        this.mGlobal.removeInputDeviceBatteryListener(deviceId, listener);
    }

    public boolean areTouchpadGesturesAvailable(Context context) {
        return true;
    }

    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    public void registerKeyboardBacklightListener(Executor executor, KeyboardBacklightListener listener) throws IllegalArgumentException {
        this.mGlobal.registerKeyboardBacklightListener(executor, listener);
    }

    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    public void unregisterKeyboardBacklightListener(KeyboardBacklightListener listener) {
        this.mGlobal.unregisterKeyboardBacklightListener(listener);
    }

    public static interface InputDeviceListener {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceRemoved(int var1);

        public void onInputDeviceChanged(int var1);
    }

    public static interface OnTabletModeChangedListener {
        public void onTabletModeChanged(long var1, boolean var3);
    }

    public static interface InputDeviceBatteryListener {
        public void onBatteryStateChanged(int var1, long var2, BatteryState var4);
    }

    public static interface KeyboardBacklightListener {
        public void onKeyboardBacklightChanged(int var1, KeyboardBacklightState var2, boolean var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RemappableModifierKey {
        public static final int REMAPPABLE_MODIFIER_KEY_CTRL_LEFT = 113;
        public static final int REMAPPABLE_MODIFIER_KEY_CTRL_RIGHT = 114;
        public static final int REMAPPABLE_MODIFIER_KEY_META_LEFT = 117;
        public static final int REMAPPABLE_MODIFIER_KEY_META_RIGHT = 118;
        public static final int REMAPPABLE_MODIFIER_KEY_ALT_LEFT = 57;
        public static final int REMAPPABLE_MODIFIER_KEY_ALT_RIGHT = 58;
        public static final int REMAPPABLE_MODIFIER_KEY_SHIFT_LEFT = 59;
        public static final int REMAPPABLE_MODIFIER_KEY_SHIFT_RIGHT = 60;
        public static final int REMAPPABLE_MODIFIER_KEY_CAPS_LOCK = 115;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchState {
    }
}

