/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.content.Context;
import android.provider.Settings;
import android.sysprop.InputProperties;

public class InputSettings {
    public static final int MIN_POINTER_SPEED = -7;
    public static final int MAX_POINTER_SPEED = 7;
    public static final int DEFAULT_POINTER_SPEED = 0;
    public static final float DEFAULT_MAXIMUM_OBSCURING_OPACITY_FOR_TOUCH = 0.8f;

    private InputSettings() {
    }

    @SuppressLint(value={"NonUserGetterCalled"})
    public static int getPointerSpeed(Context context) {
        return Settings.System.getInt(context.getContentResolver(), "pointer_speed", 0);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", speed);
    }

    public static float getMaximumObscuringOpacityForTouch(Context context) {
        return Settings.Global.getFloat(context.getContentResolver(), "maximum_obscuring_opacity_for_touch", 0.8f);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static void setMaximumObscuringOpacityForTouch(Context context, float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Maximum obscuring opacity for touch should be >= 0 and <= 1");
        }
        Settings.Global.putFloat(context.getContentResolver(), "maximum_obscuring_opacity_for_touch", opacity);
    }

    public static boolean isStylusEverUsed(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "stylus_ever_used", 0) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static void setStylusEverUsed(Context context, boolean stylusEverUsed) {
        Settings.Global.putInt(context.getContentResolver(), "stylus_ever_used", stylusEverUsed ? 1 : 0);
    }

    public static int getTouchpadPointerSpeed(Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_pointer_speed", 0, -2);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_pointer_speed", speed, -2);
    }

    public static boolean useTouchpadNaturalScrolling(Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_natural_scrolling", 1, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadNaturalScrolling(Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_natural_scrolling", enabled ? 1 : 0, -2);
    }

    public static boolean useTouchpadTapToClick(Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_tap_to_click", 0, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadTapToClick(Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_tap_to_click", enabled ? 1 : 0, -2);
    }

    public static boolean useTouchpadRightClickZone(Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_right_click_zone", 0, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadRightClickZone(Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_right_click_zone", enabled ? 1 : 0, -2);
    }

    public static boolean isStylusPointerIconEnabled(Context context) {
        return context.getResources().getBoolean(17891674) || InputProperties.force_enable_stylus_pointer_icon().orElse(false) != false;
    }
}

