/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class KeyboardLayout
implements Parcelable,
Comparable<KeyboardLayout> {
    public static final String LAYOUT_TYPE_UNDEFINED = "undefined";
    public static final String LAYOUT_TYPE_QWERTY = "qwerty";
    public static final String LAYOUT_TYPE_QWERTZ = "qwertz";
    public static final String LAYOUT_TYPE_AZERTY = "azerty";
    public static final String LAYOUT_TYPE_DVORAK = "dvorak";
    public static final String LAYOUT_TYPE_COLEMAK = "colemak";
    public static final String LAYOUT_TYPE_WORKMAN = "workman";
    public static final String LAYOUT_TYPE_TURKISH_F = "turkish_f";
    public static final String LAYOUT_TYPE_TURKISH_Q = "turkish_q";
    public static final String LAYOUT_TYPE_EXTENDED = "extended";
    private final String mDescriptor;
    private final String mLabel;
    private final String mCollection;
    private final int mPriority;
    private final LocaleList mLocales;
    private final LayoutType mLayoutType;
    private final int mVendorId;
    private final int mProductId;
    public static final Parcelable.Creator<KeyboardLayout> CREATOR = new Parcelable.Creator<KeyboardLayout>(){

        @Override
        public KeyboardLayout createFromParcel(Parcel source) {
            return new KeyboardLayout(source);
        }

        public KeyboardLayout[] newArray(int size) {
            return new KeyboardLayout[size];
        }
    };

    public KeyboardLayout(String descriptor, String label, String collection, int priority, LocaleList locales, int layoutValue, int vid, int pid) {
        this.mDescriptor = descriptor;
        this.mLabel = label;
        this.mCollection = collection;
        this.mPriority = priority;
        this.mLocales = locales;
        this.mLayoutType = LayoutType.of(layoutValue);
        this.mVendorId = vid;
        this.mProductId = pid;
    }

    private KeyboardLayout(Parcel source) {
        this.mDescriptor = source.readString();
        this.mLabel = source.readString();
        this.mCollection = source.readString();
        this.mPriority = source.readInt();
        this.mLocales = LocaleList.CREATOR.createFromParcel(source);
        this.mLayoutType = LayoutType.of(source.readInt());
        this.mVendorId = source.readInt();
        this.mProductId = source.readInt();
    }

    public String getDescriptor() {
        return this.mDescriptor;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String getCollection() {
        return this.mCollection;
    }

    public LocaleList getLocales() {
        return this.mLocales;
    }

    public String getLayoutType() {
        return this.mLayoutType.getName();
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int getProductId() {
        return this.mProductId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDescriptor);
        dest.writeString(this.mLabel);
        dest.writeString(this.mCollection);
        dest.writeInt(this.mPriority);
        this.mLocales.writeToParcel(dest, 0);
        dest.writeInt(this.mLayoutType.getValue());
        dest.writeInt(this.mVendorId);
        dest.writeInt(this.mProductId);
    }

    @Override
    public int compareTo(KeyboardLayout another) {
        int result = Integer.compare(another.mPriority, this.mPriority);
        if (result == 0) {
            result = Integer.compare(this.mLayoutType.mValue, another.mLayoutType.mValue);
        }
        if (result == 0) {
            result = this.mLabel.compareToIgnoreCase(another.mLabel);
        }
        if (result == 0) {
            result = this.mCollection.compareToIgnoreCase(another.mCollection);
        }
        return result;
    }

    public String toString() {
        String collectionString = this.mCollection.isEmpty() ? "" : " - " + this.mCollection;
        return "KeyboardLayout " + this.mLabel + collectionString + ", descriptor: " + this.mDescriptor + ", priority: " + this.mPriority + ", locales: " + this.mLocales.toString() + ", layout type: " + this.mLayoutType.getName() + ", vendorId: " + this.mVendorId + ", productId: " + this.mProductId;
    }

    public static boolean isLayoutTypeValid(String layoutName) {
        Objects.requireNonNull(layoutName, "Provided layout name should not be null");
        for (LayoutType layoutType : LayoutType.values()) {
            if (!layoutName.equals(layoutType.getName())) continue;
            return true;
        }
        return false;
    }

    private static enum LayoutType {
        UNDEFINED(0, "undefined"),
        QWERTY(1, "qwerty"),
        QWERTZ(2, "qwertz"),
        AZERTY(3, "azerty"),
        DVORAK(4, "dvorak"),
        COLEMAK(5, "colemak"),
        WORKMAN(6, "workman"),
        TURKISH_F(7, "turkish_f"),
        TURKISH_Q(8, "turkish_q"),
        EXTENDED(9, "extended");

        private final int mValue;
        private final String mName;
        private static final Map<Integer, LayoutType> VALUE_TO_ENUM_MAP;

        private static LayoutType of(int value) {
            return VALUE_TO_ENUM_MAP.getOrDefault(value, UNDEFINED);
        }

        private LayoutType(int value, String name) {
            this.mValue = value;
            this.mName = name;
        }

        private int getValue() {
            return this.mValue;
        }

        private String getName() {
            return this.mName;
        }

        static {
            VALUE_TO_ENUM_MAP = new HashMap<Integer, LayoutType>();
            for (LayoutType type : LayoutType.values()) {
                VALUE_TO_ENUM_MAP.put(type.mValue, type);
            }
        }
    }
}

