/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualKeyEvent;
import android.os.IBinder;
import android.os.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@SystemApi
public class VirtualDpad
extends VirtualInputDevice {
    private final Set<Integer> mSupportedKeyCodes = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(4, 19, 20, 21, 22, 23)));

    public VirtualDpad(IVirtualDevice virtualDevice, IBinder token) {
        super(virtualDevice, token);
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void sendKeyEvent(VirtualKeyEvent event) {
        try {
            if (!this.mSupportedKeyCodes.contains(event.getKeyCode())) {
                throw new IllegalArgumentException("Unsupported key code " + event.getKeyCode() + " sent to a VirtualDpad input device.");
            }
            this.mVirtualDevice.sendDpadKeyEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

