/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.companion.virtual.IVirtualDevice;
import android.os.IBinder;
import android.os.RemoteException;
import java.io.Closeable;

abstract class VirtualInputDevice
implements Closeable {
    protected final IVirtualDevice mVirtualDevice;
    protected final IBinder mToken;

    VirtualInputDevice(IVirtualDevice virtualDevice, IBinder token) {
        this.mVirtualDevice = virtualDevice;
        this.mToken = token;
    }

    public int getInputDeviceId() {
        try {
            return this.mVirtualDevice.getInputDeviceId(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void close() {
        try {
            this.mVirtualDevice.unregisterInputDevice(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

