/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.SystemApi;
import android.os.Parcel;

@SystemApi
public abstract class VirtualInputDeviceConfig {
    private final int mVendorId;
    private final int mProductId;
    private final int mAssociatedDisplayId;
    private final String mInputDeviceName;

    protected VirtualInputDeviceConfig(Builder<? extends Builder<?>> builder) {
        this.mVendorId = builder.mVendorId;
        this.mProductId = builder.mProductId;
        this.mAssociatedDisplayId = builder.mAssociatedDisplayId;
        this.mInputDeviceName = builder.mInputDeviceName;
    }

    protected VirtualInputDeviceConfig(Parcel in) {
        this.mVendorId = in.readInt();
        this.mProductId = in.readInt();
        this.mAssociatedDisplayId = in.readInt();
        this.mInputDeviceName = in.readString8();
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public int getAssociatedDisplayId() {
        return this.mAssociatedDisplayId;
    }

    public String getInputDeviceName() {
        return this.mInputDeviceName;
    }

    void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mVendorId);
        dest.writeInt(this.mProductId);
        dest.writeInt(this.mAssociatedDisplayId);
        dest.writeString8(this.mInputDeviceName);
    }

    public static abstract class Builder<T extends Builder<T>> {
        private int mVendorId;
        private int mProductId;
        private int mAssociatedDisplayId;
        private String mInputDeviceName;

        public T setVendorId(int vendorId) {
            this.mVendorId = vendorId;
            return this.self();
        }

        public T setProductId(int productId) {
            this.mProductId = productId;
            return this.self();
        }

        public T setAssociatedDisplayId(int displayId) {
            this.mAssociatedDisplayId = displayId;
            return this.self();
        }

        public T setInputDeviceName(String deviceName) {
            this.mInputDeviceName = deviceName;
            return this.self();
        }

        T self() {
            return (T)this;
        }
    }
}

