/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.SystemApi;
import android.hardware.input.VirtualInputDeviceConfig;
import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class VirtualKeyboardConfig
extends VirtualInputDeviceConfig
implements Parcelable {
    public static final String DEFAULT_LANGUAGE_TAG = "en-Latn-US";
    public static final String DEFAULT_LAYOUT_TYPE = "qwerty";
    private final String mLanguageTag;
    private final String mLayoutType;
    public static final Parcelable.Creator<VirtualKeyboardConfig> CREATOR = new Parcelable.Creator<VirtualKeyboardConfig>(){

        @Override
        public VirtualKeyboardConfig createFromParcel(Parcel in) {
            return new VirtualKeyboardConfig(in);
        }

        public VirtualKeyboardConfig[] newArray(int size) {
            return new VirtualKeyboardConfig[size];
        }
    };

    private VirtualKeyboardConfig(Builder builder) {
        super(builder);
        this.mLanguageTag = builder.mLanguageTag;
        this.mLayoutType = builder.mLayoutType;
    }

    private VirtualKeyboardConfig(Parcel in) {
        super(in);
        this.mLanguageTag = in.readString8();
        this.mLayoutType = in.readString8();
    }

    public String getLanguageTag() {
        return this.mLanguageTag;
    }

    public String getLayoutType() {
        return this.mLayoutType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString8(this.mLanguageTag);
        dest.writeString8(this.mLayoutType);
    }

    public static class Builder
    extends VirtualInputDeviceConfig.Builder<Builder> {
        private String mLanguageTag = "en-Latn-US";
        private String mLayoutType = "qwerty";

        public Builder setLanguageTag(String languageTag) {
            Objects.requireNonNull(languageTag, "languageTag cannot be null");
            ULocale locale = ULocale.forLanguageTag(languageTag);
            if (locale.getLanguage().isEmpty()) {
                throw new IllegalArgumentException("The language tag is not valid.");
            }
            this.mLanguageTag = ULocale.createCanonical(locale).toLanguageTag();
            return this;
        }

        public Builder setLayoutType(String layoutType) {
            Objects.requireNonNull(layoutType, "layoutType cannot be null");
            this.mLayoutType = layoutType;
            return this;
        }

        public VirtualKeyboardConfig build() {
            return new VirtualKeyboardConfig(this);
        }
    }
}

