/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.SystemApi;
import android.hardware.input.VirtualInputDeviceConfig;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class VirtualNavigationTouchpadConfig
extends VirtualInputDeviceConfig
implements Parcelable {
    private final int mHeight;
    private final int mWidth;
    public static final Parcelable.Creator<VirtualNavigationTouchpadConfig> CREATOR = new Parcelable.Creator<VirtualNavigationTouchpadConfig>(){

        @Override
        public VirtualNavigationTouchpadConfig createFromParcel(Parcel in) {
            return new VirtualNavigationTouchpadConfig(in);
        }

        public VirtualNavigationTouchpadConfig[] newArray(int size) {
            return new VirtualNavigationTouchpadConfig[size];
        }
    };

    private VirtualNavigationTouchpadConfig(Builder builder) {
        super(builder);
        this.mHeight = builder.mHeight;
        this.mWidth = builder.mWidth;
    }

    private VirtualNavigationTouchpadConfig(Parcel in) {
        super(in);
        this.mHeight = in.readInt();
        this.mWidth = in.readInt();
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mWidth);
    }

    public static class Builder
    extends VirtualInputDeviceConfig.Builder<Builder> {
        private final int mHeight;
        private final int mWidth;

        public Builder(int touchpadWidth, int touchpadHeight) {
            if (touchpadHeight <= 0 || touchpadWidth <= 0) {
                throw new IllegalArgumentException("Cannot create a virtual navigation touchpad, touchpad dimensions must be positive. Got: (" + touchpadHeight + ", " + touchpadWidth + ")");
            }
            this.mHeight = touchpadHeight;
            this.mWidth = touchpadWidth;
        }

        public VirtualNavigationTouchpadConfig build() {
            return new VirtualNavigationTouchpadConfig(this);
        }
    }
}

