/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.SystemApi;
import android.hardware.input.VirtualInputDeviceConfig;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class VirtualTouchscreenConfig
extends VirtualInputDeviceConfig
implements Parcelable {
    private final int mWidth;
    private final int mHeight;
    public static final Parcelable.Creator<VirtualTouchscreenConfig> CREATOR = new Parcelable.Creator<VirtualTouchscreenConfig>(){

        @Override
        public VirtualTouchscreenConfig createFromParcel(Parcel in) {
            return new VirtualTouchscreenConfig(in);
        }

        public VirtualTouchscreenConfig[] newArray(int size) {
            return new VirtualTouchscreenConfig[size];
        }
    };

    private VirtualTouchscreenConfig(Builder builder) {
        super(builder);
        this.mWidth = builder.mWidth;
        this.mHeight = builder.mHeight;
    }

    private VirtualTouchscreenConfig(Parcel in) {
        super(in);
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
    }

    public static class Builder
    extends VirtualInputDeviceConfig.Builder<Builder> {
        private int mWidth;
        private int mHeight;

        public Builder(int touchscreenWidth, int touchscreenHeight) {
            if (touchscreenHeight <= 0 || touchscreenWidth <= 0) {
                throw new IllegalArgumentException("Cannot create a virtual touchscreen, touchscreen dimensions must be positive. Got: (" + touchscreenHeight + ", " + touchscreenWidth + ")");
            }
            this.mHeight = touchscreenHeight;
            this.mWidth = touchscreenWidth;
        }

        public VirtualTouchscreenConfig build() {
            return new VirtualTouchscreenConfig(this);
        }
    }
}

