/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.IContextHubClient;
import android.hardware.location.NanoAppMessage;
import android.os.RemoteException;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

@SystemApi
public class ContextHubClient
implements Closeable {
    private static final String TAG = "ContextHubClient";
    private IContextHubClient mClientProxy = null;
    private final ContextHubInfo mAttachedHub;
    private final CloseGuard mCloseGuard;
    private final AtomicBoolean mIsClosed = new AtomicBoolean(false);
    private final boolean mPersistent;
    private Integer mId = null;

    ContextHubClient(ContextHubInfo hubInfo, boolean persistent) {
        this.mAttachedHub = hubInfo;
        this.mPersistent = persistent;
        if (this.mPersistent) {
            this.mCloseGuard = null;
        } else {
            this.mCloseGuard = CloseGuard.get();
            this.mCloseGuard.open("ContextHubClient.close");
        }
    }

    synchronized void setClientProxy(IContextHubClient clientProxy) {
        Objects.requireNonNull(clientProxy, "IContextHubClient cannot be null");
        if (this.mClientProxy != null) {
            throw new IllegalStateException("Cannot change client proxy multiple times");
        }
        this.mClientProxy = clientProxy;
        try {
            this.mId = this.mClientProxy.getId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.notifyAll();
    }

    public ContextHubInfo getAttachedHub() {
        return this.mAttachedHub;
    }

    public int getId() {
        if (this.mId == null) {
            throw new IllegalStateException("ID was not set");
        }
        return 0xFFFF & this.mId;
    }

    @Override
    public void close() {
        if (!this.mIsClosed.getAndSet(true)) {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.close();
            }
            try {
                this.mClientProxy.close();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public int sendMessageToNanoApp(NanoAppMessage message) {
        Objects.requireNonNull(message, "NanoAppMessage cannot be null");
        int maxPayloadBytes = this.mAttachedHub.getMaxPacketLengthBytes();
        byte[] payload = message.getMessageBody();
        if (payload != null && payload.length > maxPayloadBytes) {
            Log.e(TAG, "Message (" + payload.length + " bytes) exceeds max payload length (" + maxPayloadBytes + " bytes)");
            return 2;
        }
        try {
            return this.mClientProxy.sendMessageToNanoApp(message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mPersistent) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void callbackFinished() {
        try {
            while (this.mClientProxy == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.mClientProxy.callbackFinished();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

