/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public interface ITunerCallback
extends IInterface {
    public void onError(int var1) throws RemoteException;

    public void onTuneFailed(int var1, ProgramSelector var2) throws RemoteException;

    public void onConfigurationChanged(RadioManager.BandConfig var1) throws RemoteException;

    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo var1) throws RemoteException;

    public void onTrafficAnnouncement(boolean var1) throws RemoteException;

    public void onEmergencyAnnouncement(boolean var1) throws RemoteException;

    public void onAntennaState(boolean var1) throws RemoteException;

    public void onBackgroundScanAvailabilityChange(boolean var1) throws RemoteException;

    public void onBackgroundScanComplete() throws RemoteException;

    public void onProgramListChanged() throws RemoteException;

    public void onProgramListUpdated(ProgramList.Chunk var1) throws RemoteException;

    public void onConfigFlagUpdated(int var1, boolean var2) throws RemoteException;

    public void onParametersUpdated(Map<String, String> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITunerCallback {
        public static final String DESCRIPTOR = "android.hardware.radio.ITunerCallback";
        static final int TRANSACTION_onError = 1;
        static final int TRANSACTION_onTuneFailed = 2;
        static final int TRANSACTION_onConfigurationChanged = 3;
        static final int TRANSACTION_onCurrentProgramInfoChanged = 4;
        static final int TRANSACTION_onTrafficAnnouncement = 5;
        static final int TRANSACTION_onEmergencyAnnouncement = 6;
        static final int TRANSACTION_onAntennaState = 7;
        static final int TRANSACTION_onBackgroundScanAvailabilityChange = 8;
        static final int TRANSACTION_onBackgroundScanComplete = 9;
        static final int TRANSACTION_onProgramListChanged = 10;
        static final int TRANSACTION_onProgramListUpdated = 11;
        static final int TRANSACTION_onConfigFlagUpdated = 12;
        static final int TRANSACTION_onParametersUpdated = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITunerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITunerCallback) {
                return (ITunerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onError";
                }
                case 2: {
                    return "onTuneFailed";
                }
                case 3: {
                    return "onConfigurationChanged";
                }
                case 4: {
                    return "onCurrentProgramInfoChanged";
                }
                case 5: {
                    return "onTrafficAnnouncement";
                }
                case 6: {
                    return "onEmergencyAnnouncement";
                }
                case 7: {
                    return "onAntennaState";
                }
                case 8: {
                    return "onBackgroundScanAvailabilityChange";
                }
                case 9: {
                    return "onBackgroundScanComplete";
                }
                case 10: {
                    return "onProgramListChanged";
                }
                case 11: {
                    return "onProgramListUpdated";
                }
                case 12: {
                    return "onConfigFlagUpdated";
                }
                case 13: {
                    return "onParametersUpdated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    ProgramSelector _arg1 = data.readTypedObject(ProgramSelector.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTuneFailed(_arg0, _arg1);
                    break;
                }
                case 3: {
                    RadioManager.BandConfig _arg0 = data.readTypedObject(RadioManager.BandConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0);
                    break;
                }
                case 4: {
                    RadioManager.ProgramInfo _arg0 = data.readTypedObject(RadioManager.ProgramInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCurrentProgramInfoChanged(_arg0);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onTrafficAnnouncement(_arg0);
                    break;
                }
                case 6: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onEmergencyAnnouncement(_arg0);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAntennaState(_arg0);
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onBackgroundScanAvailabilityChange(_arg0);
                    break;
                }
                case 9: {
                    this.onBackgroundScanComplete();
                    break;
                }
                case 10: {
                    this.onProgramListChanged();
                    break;
                }
                case 11: {
                    ProgramList.Chunk _arg0 = data.readTypedObject(ProgramList.Chunk.CREATOR);
                    data.enforceNoDataAvail();
                    this.onProgramListUpdated(_arg0);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onConfigFlagUpdated(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int N = data.readInt();
                    HashMap<String, String> _arg0 = N < 0 ? null : new HashMap<String, String>();
                    IntStream.range(0, N).forEach(i -> {
                        String k = data.readString();
                        String v = data.readString();
                        _arg0.put(k, v);
                    });
                    data.enforceNoDataAvail();
                    this.onParametersUpdated(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 12;
        }

        private static class Proxy
        implements ITunerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTuneFailed(int result, ProgramSelector selector) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(result);
                    _data.writeTypedObject(selector, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(RadioManager.BandConfig config) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTrafficAnnouncement(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEmergencyAnnouncement(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAntennaState(boolean connected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(connected);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackgroundScanAvailabilityChange(boolean isAvailable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isAvailable);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBackgroundScanComplete() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onProgramListChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProgramListUpdated(ProgramList.Chunk chunk) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(chunk, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigFlagUpdated(int flag, boolean value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flag);
                    _data.writeBoolean(value);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onParametersUpdated(Map<String, String> parameters) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parameters == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(parameters.size());
                        parameters.forEach((k, v) -> {
                            _data.writeString((String)k);
                            _data.writeString((String)v);
                        });
                    }
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITunerCallback {
        @Override
        public void onError(int status) throws RemoteException {
        }

        @Override
        public void onTuneFailed(int result, ProgramSelector selector) throws RemoteException {
        }

        @Override
        public void onConfigurationChanged(RadioManager.BandConfig config) throws RemoteException {
        }

        @Override
        public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) throws RemoteException {
        }

        @Override
        public void onTrafficAnnouncement(boolean active) throws RemoteException {
        }

        @Override
        public void onEmergencyAnnouncement(boolean active) throws RemoteException {
        }

        @Override
        public void onAntennaState(boolean connected) throws RemoteException {
        }

        @Override
        public void onBackgroundScanAvailabilityChange(boolean isAvailable) throws RemoteException {
        }

        @Override
        public void onBackgroundScanComplete() throws RemoteException {
        }

        @Override
        public void onProgramListChanged() throws RemoteException {
        }

        @Override
        public void onProgramListUpdated(ProgramList.Chunk chunk) throws RemoteException {
        }

        @Override
        public void onConfigFlagUpdated(int flag, boolean value) throws RemoteException {
        }

        @Override
        public void onParametersUpdated(Map<String, String> parameters) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

