/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.SystemApi;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.Utils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

@SystemApi
public class ProgramList
implements AutoCloseable {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<ProgramSelector.Identifier, RadioManager.ProgramInfo> mPrograms = new ArrayMap<ProgramSelector.Identifier, RadioManager.ProgramInfo>();
    @GuardedBy(value={"mLock"})
    private final List<ListCallback> mListCallbacks = new ArrayList<ListCallback>();
    @GuardedBy(value={"mLock"})
    private final List<OnCompleteListener> mOnCompleteListeners = new ArrayList<OnCompleteListener>();
    @GuardedBy(value={"mLock"})
    private OnCloseListener mOnCloseListener;
    @GuardedBy(value={"mLock"})
    private boolean mIsClosed;
    @GuardedBy(value={"mLock"})
    private boolean mIsComplete;

    ProgramList() {
    }

    public void registerListCallback(final Executor executor, final ListCallback callback) {
        this.registerListCallback(new ListCallback(){

            @Override
            public void onItemChanged(ProgramSelector.Identifier id2) {
                executor.execute(() -> callback.onItemChanged(id2));
            }

            @Override
            public void onItemRemoved(ProgramSelector.Identifier id2) {
                executor.execute(() -> callback.onItemRemoved(id2));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListCallback(ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.add(Objects.requireNonNull(callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListCallback(ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.remove(Objects.requireNonNull(callback));
        }
    }

    public void addOnCompleteListener(Executor executor, OnCompleteListener listener) {
        this.addOnCompleteListener(() -> executor.execute(listener::onComplete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCompleteListener(OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.add(Objects.requireNonNull(listener));
            if (this.mIsComplete) {
                listener.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCompleteListener(OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.remove(Objects.requireNonNull(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnCloseListener(OnCloseListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOnCloseListener != null) {
                throw new IllegalStateException("Close callback is already set");
            }
            this.mOnCloseListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OnCloseListener onCompleteListenersCopied = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
            this.mPrograms.clear();
            this.mListCallbacks.clear();
            this.mOnCompleteListeners.clear();
            if (this.mOnCloseListener != null) {
                onCompleteListenersCopied = this.mOnCloseListener;
                this.mOnCloseListener = null;
            }
        }
        if (onCompleteListenersCopied != null) {
            onCompleteListenersCopied.onClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(Chunk chunk) {
        int i;
        ArrayList<ListCallback> listCallbacksCopied;
        ArrayList<ProgramSelector.Identifier> removedList = new ArrayList<ProgramSelector.Identifier>();
        ArrayList changedList = new ArrayList();
        ArrayList<Object> onCompleteListenersCopied = new ArrayList();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsComplete = false;
            listCallbacksCopied = new ArrayList<ListCallback>(this.mListCallbacks);
            if (chunk.isPurge()) {
                Iterator<Map.Entry<ProgramSelector.Identifier, RadioManager.ProgramInfo>> programsIterator = this.mPrograms.entrySet().iterator();
                while (programsIterator.hasNext()) {
                    RadioManager.ProgramInfo removed = programsIterator.next().getValue();
                    if (removed != null) {
                        removedList.add(removed.getSelector().getPrimaryId());
                    }
                    programsIterator.remove();
                }
            }
            chunk.getRemoved().stream().forEach(id2 -> this.removeLocked((ProgramSelector.Identifier)id2, (List<ProgramSelector.Identifier>)removedList));
            chunk.getModified().stream().forEach(info -> this.putLocked((RadioManager.ProgramInfo)info, changedList));
            if (chunk.isComplete()) {
                this.mIsComplete = true;
                onCompleteListenersCopied = new ArrayList<OnCompleteListener>(this.mOnCompleteListeners);
            }
        }
        for (i = 0; i < removedList.size(); ++i) {
            for (int cbIndex = 0; cbIndex < listCallbacksCopied.size(); ++cbIndex) {
                ((ListCallback)listCallbacksCopied.get(cbIndex)).onItemRemoved((ProgramSelector.Identifier)removedList.get(i));
            }
        }
        for (i = 0; i < changedList.size(); ++i) {
            for (int cbIndex = 0; cbIndex < listCallbacksCopied.size(); ++cbIndex) {
                ((ListCallback)listCallbacksCopied.get(cbIndex)).onItemChanged((ProgramSelector.Identifier)changedList.get(i));
            }
        }
        if (chunk.isComplete()) {
            for (int cbIndex = 0; cbIndex < onCompleteListenersCopied.size(); ++cbIndex) {
                ((OnCompleteListener)onCompleteListenersCopied.get(cbIndex)).onComplete();
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void putLocked(RadioManager.ProgramInfo value, List<ProgramSelector.Identifier> changedIdentifierList) {
        ProgramSelector.Identifier key = value.getSelector().getPrimaryId();
        this.mPrograms.put(Objects.requireNonNull(key), value);
        ProgramSelector.Identifier sel = value.getSelector().getPrimaryId();
        changedIdentifierList.add(sel);
    }

    @GuardedBy(value={"mLock"})
    private void removeLocked(ProgramSelector.Identifier key, List<ProgramSelector.Identifier> removedIdentifierList) {
        RadioManager.ProgramInfo removed = this.mPrograms.remove(Objects.requireNonNull(key));
        if (removed == null) {
            return;
        }
        ProgramSelector.Identifier sel = removed.getSelector().getPrimaryId();
        removedIdentifierList.add(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RadioManager.ProgramInfo> toList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrograms.values().stream().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadioManager.ProgramInfo get(ProgramSelector.Identifier id2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrograms.get(Objects.requireNonNull(id2));
        }
    }

    public static abstract class ListCallback {
        public void onItemChanged(ProgramSelector.Identifier id2) {
        }

        public void onItemRemoved(ProgramSelector.Identifier id2) {
        }
    }

    public static interface OnCompleteListener {
        public void onComplete();
    }

    static interface OnCloseListener {
        public void onClose();
    }

    public static class Chunk
    implements Parcelable {
        private final boolean mPurge;
        private final boolean mComplete;
        private final Set<RadioManager.ProgramInfo> mModified;
        private final Set<ProgramSelector.Identifier> mRemoved;
        public static final Parcelable.Creator<Chunk> CREATOR = new Parcelable.Creator<Chunk>(){

            @Override
            public Chunk createFromParcel(Parcel in) {
                return new Chunk(in);
            }

            public Chunk[] newArray(int size) {
                return new Chunk[size];
            }
        };

        public Chunk(boolean purge, boolean complete, Set<RadioManager.ProgramInfo> modified, Set<ProgramSelector.Identifier> removed) {
            this.mPurge = purge;
            this.mComplete = complete;
            this.mModified = modified != null ? modified : Collections.emptySet();
            this.mRemoved = removed != null ? removed : Collections.emptySet();
        }

        private Chunk(Parcel in) {
            this.mPurge = in.readByte() != 0;
            this.mComplete = in.readByte() != 0;
            this.mModified = Utils.createSet(in, RadioManager.ProgramInfo.CREATOR);
            this.mRemoved = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte((byte)(this.mPurge ? 1 : 0));
            dest.writeByte((byte)(this.mComplete ? 1 : 0));
            Utils.writeSet(dest, this.mModified);
            Utils.writeSet(dest, this.mRemoved);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean isPurge() {
            return this.mPurge;
        }

        public boolean isComplete() {
            return this.mComplete;
        }

        public Set<RadioManager.ProgramInfo> getModified() {
            return this.mModified;
        }

        public Set<ProgramSelector.Identifier> getRemoved() {
            return this.mRemoved;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Chunk)) {
                return false;
            }
            Chunk other = (Chunk)obj;
            if (this.mPurge != other.mPurge) {
                return false;
            }
            if (this.mComplete != other.mComplete) {
                return false;
            }
            if (!Objects.equals(this.mModified, other.mModified)) {
                return false;
            }
            return Objects.equals(this.mRemoved, other.mRemoved);
        }

        public String toString() {
            return "Chunk [mPurge=" + this.mPurge + ", mComplete=" + this.mComplete + ", mModified=" + this.mModified + ", mRemoved=" + this.mRemoved + "]";
        }
    }

    public static class Filter
    implements Parcelable {
        private final Set<Integer> mIdentifierTypes;
        private final Set<ProgramSelector.Identifier> mIdentifiers;
        private final boolean mIncludeCategories;
        private final boolean mExcludeModifications;
        private final Map<String, String> mVendorFilter;
        public static final Parcelable.Creator<Filter> CREATOR = new Parcelable.Creator<Filter>(){

            @Override
            public Filter createFromParcel(Parcel in) {
                return new Filter(in);
            }

            public Filter[] newArray(int size) {
                return new Filter[size];
            }
        };

        public Filter(Set<Integer> identifierTypes, Set<ProgramSelector.Identifier> identifiers, boolean includeCategories, boolean excludeModifications) {
            this.mIdentifierTypes = Objects.requireNonNull(identifierTypes);
            this.mIdentifiers = Objects.requireNonNull(identifiers);
            this.mIncludeCategories = includeCategories;
            this.mExcludeModifications = excludeModifications;
            this.mVendorFilter = null;
        }

        public Filter() {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = null;
        }

        public Filter(Map<String, String> vendorFilter) {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = vendorFilter;
        }

        private Filter(Parcel in) {
            this.mIdentifierTypes = Utils.createIntSet(in);
            this.mIdentifiers = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
            this.mIncludeCategories = in.readByte() != 0;
            this.mExcludeModifications = in.readByte() != 0;
            this.mVendorFilter = Utils.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            Utils.writeIntSet(dest, this.mIdentifierTypes);
            Utils.writeSet(dest, this.mIdentifiers);
            dest.writeByte((byte)(this.mIncludeCategories ? 1 : 0));
            dest.writeByte((byte)(this.mExcludeModifications ? 1 : 0));
            Utils.writeStringMap(dest, this.mVendorFilter);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Map<String, String> getVendorFilter() {
            return this.mVendorFilter;
        }

        public Set<Integer> getIdentifierTypes() {
            return this.mIdentifierTypes;
        }

        public Set<ProgramSelector.Identifier> getIdentifiers() {
            return this.mIdentifiers;
        }

        public boolean areCategoriesIncluded() {
            return this.mIncludeCategories;
        }

        public boolean areModificationsExcluded() {
            return this.mExcludeModifications;
        }

        public int hashCode() {
            return Objects.hash(this.mIdentifierTypes, this.mIdentifiers, this.mIncludeCategories, this.mExcludeModifications);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)obj;
            if (this.mIncludeCategories != other.mIncludeCategories) {
                return false;
            }
            if (this.mExcludeModifications != other.mExcludeModifications) {
                return false;
            }
            if (!Objects.equals(this.mIdentifierTypes, other.mIdentifierTypes)) {
                return false;
            }
            return Objects.equals(this.mIdentifiers, other.mIdentifiers);
        }

        public String toString() {
            return "Filter [mIdentifierTypes=" + this.mIdentifierTypes + ", mIdentifiers=" + this.mIdentifiers + ", mIncludeCategories=" + this.mIncludeCategories + ", mExcludeModifications=" + this.mExcludeModifications + "]";
        }
    }
}

