/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.hardware.soundtrigger.SoundTrigger;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRecognitionStatusCallback
extends IInterface {
    public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent var1) throws RemoteException;

    public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent var1) throws RemoteException;

    public void onRecognitionPaused() throws RemoteException;

    public void onRecognitionResumed() throws RemoteException;

    public void onPreempted() throws RemoteException;

    public void onModuleDied() throws RemoteException;

    public void onResumeFailed(int var1) throws RemoteException;

    public void onPauseFailed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRecognitionStatusCallback {
        public static final String DESCRIPTOR = "android.hardware.soundtrigger.IRecognitionStatusCallback";
        static final int TRANSACTION_onKeyphraseDetected = 1;
        static final int TRANSACTION_onGenericSoundTriggerDetected = 2;
        static final int TRANSACTION_onRecognitionPaused = 3;
        static final int TRANSACTION_onRecognitionResumed = 4;
        static final int TRANSACTION_onPreempted = 5;
        static final int TRANSACTION_onModuleDied = 6;
        static final int TRANSACTION_onResumeFailed = 7;
        static final int TRANSACTION_onPauseFailed = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRecognitionStatusCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRecognitionStatusCallback) {
                return (IRecognitionStatusCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onKeyphraseDetected";
                }
                case 2: {
                    return "onGenericSoundTriggerDetected";
                }
                case 3: {
                    return "onRecognitionPaused";
                }
                case 4: {
                    return "onRecognitionResumed";
                }
                case 5: {
                    return "onPreempted";
                }
                case 6: {
                    return "onModuleDied";
                }
                case 7: {
                    return "onResumeFailed";
                }
                case 8: {
                    return "onPauseFailed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SoundTrigger.KeyphraseRecognitionEvent _arg0 = data.readTypedObject(SoundTrigger.KeyphraseRecognitionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onKeyphraseDetected(_arg0);
                    break;
                }
                case 2: {
                    SoundTrigger.GenericRecognitionEvent _arg0 = data.readTypedObject(SoundTrigger.GenericRecognitionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onGenericSoundTriggerDetected(_arg0);
                    break;
                }
                case 3: {
                    this.onRecognitionPaused();
                    break;
                }
                case 4: {
                    this.onRecognitionResumed();
                    break;
                }
                case 5: {
                    this.onPreempted();
                    break;
                }
                case 6: {
                    this.onModuleDied();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onResumeFailed(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPauseFailed(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IRecognitionStatusCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent recognitionEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(recognitionEvent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent recognitionEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(recognitionEvent, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRecognitionPaused() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRecognitionResumed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPreempted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onModuleDied() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResumeFailed(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPauseFailed(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRecognitionStatusCallback {
        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent recognitionEvent) throws RemoteException {
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent recognitionEvent) throws RemoteException {
        }

        @Override
        public void onRecognitionPaused() throws RemoteException {
        }

        @Override
        public void onRecognitionResumed() throws RemoteException {
        }

        @Override
        public void onPreempted() throws RemoteException {
        }

        @Override
        public void onModuleDied() throws RemoteException {
        }

        @Override
        public void onResumeFailed(int status) throws RemoteException {
        }

        @Override
        public void onPauseFailed(int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

