/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.android.internal.util.AnnotationValidations;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class KeyphraseMetadata
implements Parcelable {
    private final int mId;
    private final String mKeyphrase;
    private final ArraySet<Locale> mSupportedLocales;
    private final int mRecognitionModeFlags;
    public static final Parcelable.Creator<KeyphraseMetadata> CREATOR = new Parcelable.Creator<KeyphraseMetadata>(){

        public KeyphraseMetadata[] newArray(int size) {
            return new KeyphraseMetadata[size];
        }

        @Override
        public KeyphraseMetadata createFromParcel(Parcel in) {
            return new KeyphraseMetadata(in);
        }
    };

    public KeyphraseMetadata(int id2, String keyphrase, Set<Locale> supportedLocales, int recognitionModeFlags) {
        this.mId = id2;
        this.mKeyphrase = keyphrase;
        this.mSupportedLocales = new ArraySet<Locale>(supportedLocales);
        this.mRecognitionModeFlags = recognitionModeFlags;
    }

    public int getId() {
        return this.mId;
    }

    public String getKeyphrase() {
        return this.mKeyphrase;
    }

    public Set<Locale> getSupportedLocales() {
        return this.mSupportedLocales;
    }

    public int getRecognitionModeFlags() {
        return this.mRecognitionModeFlags;
    }

    public boolean supportsPhrase(String phrase) {
        return this.getKeyphrase().isEmpty() || this.getKeyphrase().equalsIgnoreCase(phrase);
    }

    public boolean supportsLocale(Locale locale) {
        return this.getSupportedLocales().isEmpty() || this.getSupportedLocales().contains(locale);
    }

    public String toString() {
        return "KeyphraseMetadata { id = " + this.mId + ", keyphrase = " + this.mKeyphrase + ", supportedLocales = " + this.mSupportedLocales + ", recognitionModeFlags = " + this.mRecognitionModeFlags + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyphraseMetadata that = (KeyphraseMetadata)o;
        return this.mId == that.mId && Objects.equals(this.mKeyphrase, that.mKeyphrase) && Objects.equals(this.mSupportedLocales, that.mSupportedLocales) && this.mRecognitionModeFlags == that.mRecognitionModeFlags;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mId;
        _hash = 31 * _hash + Objects.hashCode(this.mKeyphrase);
        _hash = 31 * _hash + Objects.hashCode(this.mSupportedLocales);
        _hash = 31 * _hash + this.mRecognitionModeFlags;
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mKeyphrase);
        dest.writeArraySet(this.mSupportedLocales);
        dest.writeInt(this.mRecognitionModeFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    KeyphraseMetadata(Parcel in) {
        int id2 = in.readInt();
        String keyphrase = in.readString();
        ArraySet<? extends Object> supportedLocales = in.readArraySet(null);
        int recognitionModeFlags = in.readInt();
        this.mId = id2;
        this.mKeyphrase = keyphrase;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mKeyphrase);
        this.mSupportedLocales = supportedLocales;
        AnnotationValidations.validate(NonNull.class, null, this.mSupportedLocales);
        this.mRecognitionModeFlags = recognitionModeFlags;
    }

    @Deprecated
    private void __metadata() {
    }
}

