/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.hardware.usb.IDisplayPortAltModeInfoListener;
import android.hardware.usb.IUsbOperationInternal;
import android.hardware.usb.ParcelableUsbPort;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbPortStatus;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.List;

public interface IUsbManager
extends IInterface {
    public void getDeviceList(Bundle var1) throws RemoteException;

    public ParcelFileDescriptor openDevice(String var1, String var2) throws RemoteException;

    public UsbAccessory getCurrentAccessory() throws RemoteException;

    public ParcelFileDescriptor openAccessory(UsbAccessory var1) throws RemoteException;

    public void setDevicePackage(UsbDevice var1, String var2, int var3) throws RemoteException;

    public void setAccessoryPackage(UsbAccessory var1, String var2, int var3) throws RemoteException;

    public void addDevicePackagesToPreferenceDenied(UsbDevice var1, String[] var2, UserHandle var3) throws RemoteException;

    public void addAccessoryPackagesToPreferenceDenied(UsbAccessory var1, String[] var2, UserHandle var3) throws RemoteException;

    public void removeDevicePackagesFromPreferenceDenied(UsbDevice var1, String[] var2, UserHandle var3) throws RemoteException;

    public void removeAccessoryPackagesFromPreferenceDenied(UsbAccessory var1, String[] var2, UserHandle var3) throws RemoteException;

    public void setDevicePersistentPermission(UsbDevice var1, int var2, UserHandle var3, boolean var4) throws RemoteException;

    public void setAccessoryPersistentPermission(UsbAccessory var1, int var2, UserHandle var3, boolean var4) throws RemoteException;

    public boolean hasDevicePermission(UsbDevice var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public boolean hasDevicePermissionWithIdentity(UsbDevice var1, String var2, int var3, int var4) throws RemoteException;

    public boolean hasAccessoryPermission(UsbAccessory var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public boolean hasAccessoryPermissionWithIdentity(UsbAccessory var1, int var2, int var3) throws RemoteException;

    public void requestDevicePermission(UsbDevice var1, String var2, PendingIntent var3) throws RemoteException;

    public void requestAccessoryPermission(UsbAccessory var1, String var2, PendingIntent var3) throws RemoteException;

    public void grantDevicePermission(UsbDevice var1, int var2) throws RemoteException;

    public void grantAccessoryPermission(UsbAccessory var1, int var2) throws RemoteException;

    public boolean hasDefaults(String var1, int var2) throws RemoteException;

    public void clearDefaults(String var1, int var2) throws RemoteException;

    public boolean isFunctionEnabled(String var1) throws RemoteException;

    public void setCurrentFunctions(long var1, int var3) throws RemoteException;

    public void setCurrentFunction(String var1, boolean var2, int var3) throws RemoteException;

    public long getCurrentFunctions() throws RemoteException;

    public int getCurrentUsbSpeed() throws RemoteException;

    public int getGadgetHalVersion() throws RemoteException;

    public void setScreenUnlockedFunctions(long var1) throws RemoteException;

    public long getScreenUnlockedFunctions() throws RemoteException;

    public void resetUsbGadget() throws RemoteException;

    public void resetUsbPort(String var1, int var2, IUsbOperationInternal var3) throws RemoteException;

    public boolean enableUsbData(String var1, boolean var2, int var3, IUsbOperationInternal var4) throws RemoteException;

    public void enableUsbDataWhileDocked(String var1, int var2, IUsbOperationInternal var3) throws RemoteException;

    public int getUsbHalVersion() throws RemoteException;

    public ParcelFileDescriptor getControlFd(long var1) throws RemoteException;

    public List<ParcelableUsbPort> getPorts() throws RemoteException;

    public UsbPortStatus getPortStatus(String var1) throws RemoteException;

    public void setPortRoles(String var1, int var2, int var3) throws RemoteException;

    public void enableLimitPowerTransfer(String var1, boolean var2, int var3, IUsbOperationInternal var4) throws RemoteException;

    public void enableContaminantDetection(String var1, boolean var2) throws RemoteException;

    public void setUsbDeviceConnectionHandler(ComponentName var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public boolean registerForDisplayPortEvents(IDisplayPortAltModeInfoListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public void unregisterForDisplayPortEvents(IDisplayPortAltModeInfoListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUsbManager {
        public static final String DESCRIPTOR = "android.hardware.usb.IUsbManager";
        static final int TRANSACTION_getDeviceList = 1;
        static final int TRANSACTION_openDevice = 2;
        static final int TRANSACTION_getCurrentAccessory = 3;
        static final int TRANSACTION_openAccessory = 4;
        static final int TRANSACTION_setDevicePackage = 5;
        static final int TRANSACTION_setAccessoryPackage = 6;
        static final int TRANSACTION_addDevicePackagesToPreferenceDenied = 7;
        static final int TRANSACTION_addAccessoryPackagesToPreferenceDenied = 8;
        static final int TRANSACTION_removeDevicePackagesFromPreferenceDenied = 9;
        static final int TRANSACTION_removeAccessoryPackagesFromPreferenceDenied = 10;
        static final int TRANSACTION_setDevicePersistentPermission = 11;
        static final int TRANSACTION_setAccessoryPersistentPermission = 12;
        static final int TRANSACTION_hasDevicePermission = 13;
        static final int TRANSACTION_hasDevicePermissionWithIdentity = 14;
        static final int TRANSACTION_hasAccessoryPermission = 15;
        static final int TRANSACTION_hasAccessoryPermissionWithIdentity = 16;
        static final int TRANSACTION_requestDevicePermission = 17;
        static final int TRANSACTION_requestAccessoryPermission = 18;
        static final int TRANSACTION_grantDevicePermission = 19;
        static final int TRANSACTION_grantAccessoryPermission = 20;
        static final int TRANSACTION_hasDefaults = 21;
        static final int TRANSACTION_clearDefaults = 22;
        static final int TRANSACTION_isFunctionEnabled = 23;
        static final int TRANSACTION_setCurrentFunctions = 24;
        static final int TRANSACTION_setCurrentFunction = 25;
        static final int TRANSACTION_getCurrentFunctions = 26;
        static final int TRANSACTION_getCurrentUsbSpeed = 27;
        static final int TRANSACTION_getGadgetHalVersion = 28;
        static final int TRANSACTION_setScreenUnlockedFunctions = 29;
        static final int TRANSACTION_getScreenUnlockedFunctions = 30;
        static final int TRANSACTION_resetUsbGadget = 31;
        static final int TRANSACTION_resetUsbPort = 32;
        static final int TRANSACTION_enableUsbData = 33;
        static final int TRANSACTION_enableUsbDataWhileDocked = 34;
        static final int TRANSACTION_getUsbHalVersion = 35;
        static final int TRANSACTION_getControlFd = 36;
        static final int TRANSACTION_getPorts = 37;
        static final int TRANSACTION_getPortStatus = 38;
        static final int TRANSACTION_setPortRoles = 39;
        static final int TRANSACTION_enableLimitPowerTransfer = 40;
        static final int TRANSACTION_enableContaminantDetection = 41;
        static final int TRANSACTION_setUsbDeviceConnectionHandler = 42;
        static final int TRANSACTION_registerForDisplayPortEvents = 43;
        static final int TRANSACTION_unregisterForDisplayPortEvents = 44;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IUsbManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IUsbManager) {
                return (IUsbManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDeviceList";
                }
                case 2: {
                    return "openDevice";
                }
                case 3: {
                    return "getCurrentAccessory";
                }
                case 4: {
                    return "openAccessory";
                }
                case 5: {
                    return "setDevicePackage";
                }
                case 6: {
                    return "setAccessoryPackage";
                }
                case 7: {
                    return "addDevicePackagesToPreferenceDenied";
                }
                case 8: {
                    return "addAccessoryPackagesToPreferenceDenied";
                }
                case 9: {
                    return "removeDevicePackagesFromPreferenceDenied";
                }
                case 10: {
                    return "removeAccessoryPackagesFromPreferenceDenied";
                }
                case 11: {
                    return "setDevicePersistentPermission";
                }
                case 12: {
                    return "setAccessoryPersistentPermission";
                }
                case 13: {
                    return "hasDevicePermission";
                }
                case 14: {
                    return "hasDevicePermissionWithIdentity";
                }
                case 15: {
                    return "hasAccessoryPermission";
                }
                case 16: {
                    return "hasAccessoryPermissionWithIdentity";
                }
                case 17: {
                    return "requestDevicePermission";
                }
                case 18: {
                    return "requestAccessoryPermission";
                }
                case 19: {
                    return "grantDevicePermission";
                }
                case 20: {
                    return "grantAccessoryPermission";
                }
                case 21: {
                    return "hasDefaults";
                }
                case 22: {
                    return "clearDefaults";
                }
                case 23: {
                    return "isFunctionEnabled";
                }
                case 24: {
                    return "setCurrentFunctions";
                }
                case 25: {
                    return "setCurrentFunction";
                }
                case 26: {
                    return "getCurrentFunctions";
                }
                case 27: {
                    return "getCurrentUsbSpeed";
                }
                case 28: {
                    return "getGadgetHalVersion";
                }
                case 29: {
                    return "setScreenUnlockedFunctions";
                }
                case 30: {
                    return "getScreenUnlockedFunctions";
                }
                case 31: {
                    return "resetUsbGadget";
                }
                case 32: {
                    return "resetUsbPort";
                }
                case 33: {
                    return "enableUsbData";
                }
                case 34: {
                    return "enableUsbDataWhileDocked";
                }
                case 35: {
                    return "getUsbHalVersion";
                }
                case 36: {
                    return "getControlFd";
                }
                case 37: {
                    return "getPorts";
                }
                case 38: {
                    return "getPortStatus";
                }
                case 39: {
                    return "setPortRoles";
                }
                case 40: {
                    return "enableLimitPowerTransfer";
                }
                case 41: {
                    return "enableContaminantDetection";
                }
                case 42: {
                    return "setUsbDeviceConnectionHandler";
                }
                case 43: {
                    return "registerForDisplayPortEvents";
                }
                case 44: {
                    return "unregisterForDisplayPortEvents";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Bundle _arg0 = new Bundle();
                    data.enforceNoDataAvail();
                    this.getDeviceList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg0, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    UsbAccessory _result = this.getCurrentAccessory();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openAccessory(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDevicePackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAccessoryPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addDevicePackagesToPreferenceDenied(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addAccessoryPackagesToPreferenceDenied(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeDevicePackagesFromPreferenceDenied(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    String[] _arg1 = data.createStringArray();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeAccessoryPackagesFromPreferenceDenied(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    int _arg1 = data.readInt();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDevicePersistentPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    int _arg1 = data.readInt();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAccessoryPersistentPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasDevicePermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasDevicePermissionWithIdentity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasAccessoryPermission(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasAccessoryPermissionWithIdentity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    String _arg1 = data.readString();
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestDevicePermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    String _arg1 = data.readString();
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestAccessoryPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantDevicePermission(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    UsbAccessory _arg0 = data.readTypedObject(UsbAccessory.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantAccessoryPermission(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasDefaults(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearDefaults(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isFunctionEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCurrentFunctions(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCurrentFunction(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    long _result = this.getCurrentFunctions();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 27: {
                    int _result = this.getCurrentUsbSpeed();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    int _result = this.getGadgetHalVersion();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setScreenUnlockedFunctions(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    long _result = this.getScreenUnlockedFunctions();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 31: {
                    this.resetUsbGadget();
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IUsbOperationInternal _arg2 = IUsbOperationInternal.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.resetUsbPort(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    IUsbOperationInternal _arg3 = IUsbOperationInternal.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.enableUsbData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IUsbOperationInternal _arg2 = IUsbOperationInternal.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.enableUsbDataWhileDocked(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    int _result = this.getUsbHalVersion();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 36: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.getControlFd(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 37: {
                    List<ParcelableUsbPort> _result = this.getPorts();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    UsbPortStatus _result = this.getPortStatus(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPortRoles(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    IUsbOperationInternal _arg3 = IUsbOperationInternal.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.enableLimitPowerTransfer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.enableContaminantDetection(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUsbDeviceConnectionHandler(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    IDisplayPortAltModeInfoListener _arg0 = IDisplayPortAltModeInfoListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerForDisplayPortEvents(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 44: {
                    IDisplayPortAltModeInfoListener _arg0 = IDisplayPortAltModeInfoListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterForDisplayPortEvents(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 43;
        }

        private static class Proxy
        implements IUsbManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDeviceList(Bundle devices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        devices.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openDevice(String deviceName, String packageName) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsbAccessory getCurrentAccessory() throws RemoteException {
                UsbAccessory _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsbAccessory.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openAccessory(UsbAccessory accessory) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDevicePackage(UsbDevice device, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAccessoryPackage(UsbAccessory accessory, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addDevicePackagesToPreferenceDenied(UsbDevice device, String[] packageNames, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAccessoryPackagesToPreferenceDenied(UsbAccessory accessory, String[] packageNames, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeDevicePackagesFromPreferenceDenied(UsbDevice device, String[] packageNames, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAccessoryPackagesFromPreferenceDenied(UsbAccessory device, String[] packageNames, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeStringArray(packageNames);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDevicePersistentPermission(UsbDevice device, int uid, UserHandle user, boolean shouldBeGranted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(uid);
                    _data.writeTypedObject(user, 0);
                    _data.writeBoolean(shouldBeGranted);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAccessoryPersistentPermission(UsbAccessory accessory, int uid, UserHandle user, boolean shouldBeGranted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    _data.writeInt(uid);
                    _data.writeTypedObject(user, 0);
                    _data.writeBoolean(shouldBeGranted);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasDevicePermission(UsbDevice device, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasDevicePermissionWithIdentity(UsbDevice device, String packageName, int pid, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeString(packageName);
                    _data.writeInt(pid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasAccessoryPermission(UsbAccessory accessory) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasAccessoryPermissionWithIdentity(UsbAccessory accessory, int pid, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    _data.writeInt(pid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestDevicePermission(UsbDevice device, String packageName, PendingIntent pi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(pi, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAccessoryPermission(UsbAccessory accessory, String packageName, PendingIntent pi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(pi, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDevicePermission(UsbDevice device, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantAccessoryPermission(UsbAccessory accessory, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accessory, 0);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasDefaults(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearDefaults(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFunctionEnabled(String function) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(function);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentFunctions(long functions, int operationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(functions);
                    _data.writeInt(operationId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentFunction(String function, boolean usbDataUnlocked, int operationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(function);
                    _data.writeBoolean(usbDataUnlocked);
                    _data.writeInt(operationId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCurrentFunctions() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCurrentUsbSpeed() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGadgetHalVersion() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScreenUnlockedFunctions(long functions) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(functions);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getScreenUnlockedFunctions() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetUsbGadget() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetUsbPort(String portId, int operationId, IUsbOperationInternal callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    _data.writeInt(operationId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableUsbData(String portId, boolean enable, int operationId, IUsbOperationInternal callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    _data.writeBoolean(enable);
                    _data.writeInt(operationId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableUsbDataWhileDocked(String portId, int operationId, IUsbOperationInternal callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    _data.writeInt(operationId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUsbHalVersion() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor getControlFd(long function) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(function);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ParcelableUsbPort> getPorts() throws RemoteException {
                ArrayList<ParcelableUsbPort> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ParcelableUsbPort.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsbPortStatus getPortStatus(String portId) throws RemoteException {
                UsbPortStatus _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsbPortStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPortRoles(String portId, int powerRole, int dataRole) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    _data.writeInt(powerRole);
                    _data.writeInt(dataRole);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableLimitPowerTransfer(String portId, boolean limit, int operationId, IUsbOperationInternal callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    _data.writeBoolean(limit);
                    _data.writeInt(operationId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableContaminantDetection(String portId, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(portId);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUsbDeviceConnectionHandler(ComponentName usbDeviceConnectionHandler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(usbDeviceConnectionHandler, 0);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerForDisplayPortEvents(IDisplayPortAltModeInfoListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterForDisplayPortEvents(IDisplayPortAltModeInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUsbManager {
        @Override
        public void getDeviceList(Bundle devices) throws RemoteException {
        }

        @Override
        public ParcelFileDescriptor openDevice(String deviceName, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public UsbAccessory getCurrentAccessory() throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openAccessory(UsbAccessory accessory) throws RemoteException {
            return null;
        }

        @Override
        public void setDevicePackage(UsbDevice device, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void setAccessoryPackage(UsbAccessory accessory, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void addDevicePackagesToPreferenceDenied(UsbDevice device, String[] packageNames, UserHandle user) throws RemoteException {
        }

        @Override
        public void addAccessoryPackagesToPreferenceDenied(UsbAccessory accessory, String[] packageNames, UserHandle user) throws RemoteException {
        }

        @Override
        public void removeDevicePackagesFromPreferenceDenied(UsbDevice device, String[] packageNames, UserHandle user) throws RemoteException {
        }

        @Override
        public void removeAccessoryPackagesFromPreferenceDenied(UsbAccessory device, String[] packageNames, UserHandle user) throws RemoteException {
        }

        @Override
        public void setDevicePersistentPermission(UsbDevice device, int uid, UserHandle user, boolean shouldBeGranted) throws RemoteException {
        }

        @Override
        public void setAccessoryPersistentPermission(UsbAccessory accessory, int uid, UserHandle user, boolean shouldBeGranted) throws RemoteException {
        }

        @Override
        public boolean hasDevicePermission(UsbDevice device, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasDevicePermissionWithIdentity(UsbDevice device, String packageName, int pid, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasAccessoryPermission(UsbAccessory accessory) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasAccessoryPermissionWithIdentity(UsbAccessory accessory, int pid, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void requestDevicePermission(UsbDevice device, String packageName, PendingIntent pi) throws RemoteException {
        }

        @Override
        public void requestAccessoryPermission(UsbAccessory accessory, String packageName, PendingIntent pi) throws RemoteException {
        }

        @Override
        public void grantDevicePermission(UsbDevice device, int uid) throws RemoteException {
        }

        @Override
        public void grantAccessoryPermission(UsbAccessory accessory, int uid) throws RemoteException {
        }

        @Override
        public boolean hasDefaults(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void clearDefaults(String packageName, int userId) throws RemoteException {
        }

        @Override
        public boolean isFunctionEnabled(String function) throws RemoteException {
            return false;
        }

        @Override
        public void setCurrentFunctions(long functions, int operationId) throws RemoteException {
        }

        @Override
        public void setCurrentFunction(String function, boolean usbDataUnlocked, int operationId) throws RemoteException {
        }

        @Override
        public long getCurrentFunctions() throws RemoteException {
            return 0L;
        }

        @Override
        public int getCurrentUsbSpeed() throws RemoteException {
            return 0;
        }

        @Override
        public int getGadgetHalVersion() throws RemoteException {
            return 0;
        }

        @Override
        public void setScreenUnlockedFunctions(long functions) throws RemoteException {
        }

        @Override
        public long getScreenUnlockedFunctions() throws RemoteException {
            return 0L;
        }

        @Override
        public void resetUsbGadget() throws RemoteException {
        }

        @Override
        public void resetUsbPort(String portId, int operationId, IUsbOperationInternal callback) throws RemoteException {
        }

        @Override
        public boolean enableUsbData(String portId, boolean enable, int operationId, IUsbOperationInternal callback) throws RemoteException {
            return false;
        }

        @Override
        public void enableUsbDataWhileDocked(String portId, int operationId, IUsbOperationInternal callback) throws RemoteException {
        }

        @Override
        public int getUsbHalVersion() throws RemoteException {
            return 0;
        }

        @Override
        public ParcelFileDescriptor getControlFd(long function) throws RemoteException {
            return null;
        }

        @Override
        public List<ParcelableUsbPort> getPorts() throws RemoteException {
            return null;
        }

        @Override
        public UsbPortStatus getPortStatus(String portId) throws RemoteException {
            return null;
        }

        @Override
        public void setPortRoles(String portId, int powerRole, int dataRole) throws RemoteException {
        }

        @Override
        public void enableLimitPowerTransfer(String portId, boolean limit, int operationId, IUsbOperationInternal callback) throws RemoteException {
        }

        @Override
        public void enableContaminantDetection(String portId, boolean enable) throws RemoteException {
        }

        @Override
        public void setUsbDeviceConnectionHandler(ComponentName usbDeviceConnectionHandler) throws RemoteException {
        }

        @Override
        public boolean registerForDisplayPortEvents(IDisplayPortAltModeInfoListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterForDisplayPortEvents(IDisplayPortAltModeInfoListener listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

