/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.AggregateRecordsResponse;
import android.health.connect.AggregateResult;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.internal.datatypes.utils.AggregationTypeIdMapper;
import android.util.ArrayMap;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public class AggregateRecordsGroupedByPeriodResponse<T> {
    private final Map<AggregationType<T>, AggregateResult<T>> mResult;
    private LocalDateTime mStartTime;
    private LocalDateTime mEndTime;

    public AggregateRecordsGroupedByPeriodResponse(LocalDateTime startTime, LocalDateTime endTime, Map<Integer, AggregateResult<?>> result) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        Objects.requireNonNull(result);
        this.mStartTime = startTime;
        this.mEndTime = endTime;
        this.mResult = new ArrayMap<AggregationType<T>, AggregateResult<T>>(result.size());
        result.forEach((key, value) -> this.mResult.put(AggregationTypeIdMapper.getInstance().getAggregationTypeFor((int)key), (AggregateResult<T>)value));
    }

    public LocalDateTime getStartTime() {
        return this.mStartTime;
    }

    public AggregateRecordsGroupedByPeriodResponse<T> setStartTime(LocalDateTime startTime) {
        this.mStartTime = startTime;
        return this;
    }

    public LocalDateTime getEndTime() {
        return this.mEndTime;
    }

    public AggregateRecordsGroupedByPeriodResponse<T> setEndTime(LocalDateTime endTime) {
        this.mEndTime = endTime;
        return this;
    }

    public T get(AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getInternal(aggregationType, this.mResult);
    }

    public ZoneOffset getZoneOffset(AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getZoneOffsetInternal(aggregationType, this.mResult);
    }
}

