/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.TimeRangeFilter;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.DataOrigin;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

public class AggregateRecordsRequest<T> {
    private final TimeRangeFilter mTimeRangeFilter;
    private final Set<AggregationType<T>> mAggregationTypes;
    private final Set<DataOrigin> mDataOriginsFilter;

    private AggregateRecordsRequest(Set<AggregationType<T>> aggregationTypes, TimeRangeFilter timeRangeFilter, Set<DataOrigin> dataOriginsFilter) {
        Objects.requireNonNull(timeRangeFilter);
        Objects.requireNonNull(aggregationTypes);
        Objects.requireNonNull(dataOriginsFilter);
        this.mTimeRangeFilter = timeRangeFilter;
        this.mAggregationTypes = aggregationTypes;
        this.mDataOriginsFilter = dataOriginsFilter;
    }

    public TimeRangeFilter getTimeRangeFilter() {
        return this.mTimeRangeFilter;
    }

    public Set<AggregationType<T>> getAggregationTypes() {
        return this.mAggregationTypes;
    }

    public Set<DataOrigin> getDataOriginsFilters() {
        return this.mDataOriginsFilter;
    }

    public static class Builder<T> {
        private final TimeRangeFilter mTimeRangeFilter;
        private final Set<AggregationType<T>> mAggregationTypes = new ArraySet<AggregationType<T>>();
        private final Set<DataOrigin> mDataOriginsFilter = new ArraySet<DataOrigin>();

        public Builder(TimeRangeFilter timeRangeFilter) {
            Objects.requireNonNull(timeRangeFilter);
            this.mTimeRangeFilter = timeRangeFilter;
        }

        public Builder<T> addAggregationType(AggregationType<T> aggregationType) {
            this.mAggregationTypes.add(aggregationType);
            return this;
        }

        public Builder<T> addDataOriginsFilter(DataOrigin dataOriginsFilter) {
            Objects.requireNonNull(dataOriginsFilter);
            this.mDataOriginsFilter.add(dataOriginsFilter);
            return this;
        }

        public AggregateRecordsRequest<T> build() {
            if (this.mAggregationTypes.isEmpty()) {
                throw new IllegalArgumentException("At least one of the aggregation types must be set");
            }
            return new AggregateRecordsRequest<T>(this.mAggregationTypes, this.mTimeRangeFilter, this.mDataOriginsFilter);
        }
    }
}

