/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.datatypes.DataOrigin;
import android.os.Parcel;
import android.util.ArraySet;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AggregateResult<T> {
    private final T mResult;
    private ZoneOffset mZoneOffset;
    private Set<DataOrigin> mDataOrigins;

    public AggregateResult(T result) {
        this.mResult = result;
    }

    public void putToParcel(Parcel parcel) {
        if (this.mResult instanceof Long) {
            parcel.writeLong((Long)this.mResult);
        } else if (this.mResult instanceof Double) {
            parcel.writeDouble((Double)this.mResult);
        }
    }

    public ZoneOffset getZoneOffset() {
        return this.mZoneOffset;
    }

    public AggregateResult<T> setZoneOffset(ZoneOffset zoneOffset) {
        this.mZoneOffset = zoneOffset;
        return this;
    }

    public Set<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    public AggregateResult<T> setDataOrigins(List<String> packageNameList) {
        Objects.requireNonNull(packageNameList);
        this.mDataOrigins = new ArraySet<DataOrigin>();
        for (String packageName : packageNameList) {
            this.mDataOrigins.add(new DataOrigin.Builder().setPackageName(packageName).build());
        }
        return this;
    }

    T getResult() {
        return this.mResult;
    }
}

