/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.SystemApi;
import android.health.connect.TimeRangeFilter;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class DeleteUsingFiltersRequest {
    private final TimeRangeFilter mTimeRangeFilter;
    private final Set<Class<? extends Record>> mRecordTypes;
    private final Set<DataOrigin> mDataOrigins;

    private DeleteUsingFiltersRequest(TimeRangeFilter timeRangeFilter, Set<Class<? extends Record>> recordTypes, Set<DataOrigin> dataOrigins) {
        Objects.requireNonNull(recordTypes);
        Objects.requireNonNull(dataOrigins);
        this.mTimeRangeFilter = timeRangeFilter;
        this.mRecordTypes = recordTypes;
        this.mDataOrigins = dataOrigins;
    }

    public Set<Class<? extends Record>> getRecordTypes() {
        return this.mRecordTypes;
    }

    public TimeRangeFilter getTimeRangeFilter() {
        return this.mTimeRangeFilter;
    }

    public Set<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    public static class Builder {
        private final Set<DataOrigin> mDataOrigins = new ArraySet<DataOrigin>();
        private final Set<Class<? extends Record>> mRecordTypes = new ArraySet<Class<? extends Record>>();
        private TimeRangeFilter mTimeRangeFilter;

        public Builder addDataOrigin(DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigins.add(dataOrigin);
            return this;
        }

        public Builder clearDataOrigins() {
            this.mDataOrigins.clear();
            return this;
        }

        public Builder setTimeRangeFilter(TimeRangeFilter timeRangeFilter) {
            this.mTimeRangeFilter = timeRangeFilter;
            return this;
        }

        public Builder addRecordType(Class<? extends Record> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordTypes.add(recordType);
            return this;
        }

        public Builder clearRecordTypes() {
            this.mRecordTypes.clear();
            return this;
        }

        public DeleteUsingFiltersRequest build() {
            return new DeleteUsingFiltersRequest(this.mTimeRangeFilter, this.mRecordTypes, this.mDataOrigins);
        }
    }
}

