/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.health.connect.AggregateRecordsGroupedByDurationResponse;
import android.health.connect.AggregateRecordsGroupedByPeriodResponse;
import android.health.connect.AggregateRecordsRequest;
import android.health.connect.AggregateRecordsResponse;
import android.health.connect.ApplicationInfoResponse;
import android.health.connect.DeleteUsingFiltersRequest;
import android.health.connect.FetchDataOriginsPriorityOrderResponse;
import android.health.connect.HealthConnectDataState;
import android.health.connect.HealthConnectException;
import android.health.connect.InsertRecordsResponse;
import android.health.connect.ReadRecordsRequest;
import android.health.connect.ReadRecordsResponse;
import android.health.connect.RecordIdFilter;
import android.health.connect.RecordTypeInfoResponse;
import android.health.connect.TimeRangeFilter;
import android.health.connect.UpdateDataOriginPriorityOrderRequest;
import android.health.connect.accesslog.AccessLog;
import android.health.connect.accesslog.AccessLogsResponseParcel;
import android.health.connect.aidl.ActivityDatesRequestParcel;
import android.health.connect.aidl.ActivityDatesResponseParcel;
import android.health.connect.aidl.AggregateDataRequestParcel;
import android.health.connect.aidl.AggregateDataResponseParcel;
import android.health.connect.aidl.ApplicationInfoResponseParcel;
import android.health.connect.aidl.DeleteUsingFiltersRequestParcel;
import android.health.connect.aidl.GetPriorityResponseParcel;
import android.health.connect.aidl.HealthConnectExceptionParcel;
import android.health.connect.aidl.IAccessLogsResponseCallback;
import android.health.connect.aidl.IActivityDatesResponseCallback;
import android.health.connect.aidl.IAggregateRecordsResponseCallback;
import android.health.connect.aidl.IApplicationInfoResponseCallback;
import android.health.connect.aidl.IChangeLogsResponseCallback;
import android.health.connect.aidl.IDataStagingFinishedCallback;
import android.health.connect.aidl.IEmptyResponseCallback;
import android.health.connect.aidl.IGetChangeLogTokenCallback;
import android.health.connect.aidl.IGetHealthConnectDataStateCallback;
import android.health.connect.aidl.IGetHealthConnectMigrationUiStateCallback;
import android.health.connect.aidl.IGetPriorityResponseCallback;
import android.health.connect.aidl.IHealthConnectService;
import android.health.connect.aidl.IInsertRecordsResponseCallback;
import android.health.connect.aidl.IMigrationCallback;
import android.health.connect.aidl.IReadRecordsResponseCallback;
import android.health.connect.aidl.IRecordTypeInfoResponseCallback;
import android.health.connect.aidl.InsertRecordsResponseParcel;
import android.health.connect.aidl.ReadRecordsResponseParcel;
import android.health.connect.aidl.RecordIdFiltersParcel;
import android.health.connect.aidl.RecordTypeInfoResponseParcel;
import android.health.connect.aidl.RecordsParcel;
import android.health.connect.aidl.UpdatePriorityRequestParcel;
import android.health.connect.changelog.ChangeLogTokenRequest;
import android.health.connect.changelog.ChangeLogTokenResponse;
import android.health.connect.changelog.ChangeLogsRequest;
import android.health.connect.changelog.ChangeLogsResponse;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.InternalExternalRecordConverter;
import android.health.connect.migration.HealthConnectMigrationUiState;
import android.health.connect.migration.MigrationEntity;
import android.health.connect.migration.MigrationEntityParcel;
import android.health.connect.migration.MigrationException;
import android.health.connect.restore.StageRemoteDataException;
import android.health.connect.restore.StageRemoteDataRequest;
import android.os.Binder;
import android.os.OutcomeReceiver;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class HealthConnectManager {
    public static final String CATEGORY_HEALTH_PERMISSIONS = "android.intent.category.HEALTH_PERMISSIONS";
    public static final String ACTION_MANAGE_HEALTH_PERMISSIONS = "android.health.connect.action.MANAGE_HEALTH_PERMISSIONS";
    public static final String ACTION_REQUEST_EXERCISE_ROUTE = "android.health.connect.action.REQUEST_EXERCISE_ROUTE";
    public static final String EXTRA_SESSION_ID = "android.health.connect.extra.SESSION_ID";
    public static final String EXTRA_EXERCISE_ROUTE = "android.health.connect.extra.EXERCISE_ROUTE";
    @SystemApi
    public static final String ACTION_REQUEST_HEALTH_PERMISSIONS = "android.health.connect.action.REQUEST_HEALTH_PERMISSIONS";
    @SystemApi
    public static final String ACTION_HEALTH_HOME_SETTINGS = "android.health.connect.action.HEALTH_HOME_SETTINGS";
    @SystemApi
    public static final String ACTION_MANAGE_HEALTH_DATA = "android.health.connect.action.MANAGE_HEALTH_DATA";
    @SystemApi
    public static final String ACTION_SHOW_MIGRATION_INFO = "android.health.connect.action.SHOW_MIGRATION_INFO";
    @SystemApi
    public static final String ACTION_HEALTH_CONNECT_MIGRATION_READY = "android.health.connect.action.HEALTH_CONNECT_MIGRATION_READY";
    @SystemApi
    public static final int DATA_DOWNLOAD_STATE_UNKNOWN = 0;
    @SystemApi
    public static final int DATA_DOWNLOAD_STARTED = 1;
    @SystemApi
    public static final int DATA_DOWNLOAD_RETRY = 2;
    @SystemApi
    public static final int DATA_DOWNLOAD_FAILED = 3;
    @SystemApi
    public static final int DATA_DOWNLOAD_COMPLETE = 4;
    private static final String TAG = "HealthConnectManager";
    private static final String HEALTH_PERMISSION_PREFIX = "android.permission.health.";
    private static volatile Set<String> sHealthPermissions;
    private final Context mContext;
    private final IHealthConnectService mService;
    private final InternalExternalRecordConverter mInternalExternalRecordConverter;

    HealthConnectManager(Context context, IHealthConnectService service) {
        this.mContext = context;
        this.mService = service;
        this.mInternalExternalRecordConverter = InternalExternalRecordConverter.getInstance();
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void grantHealthPermission(String packageName, String permissionName) {
        try {
            this.mService.grantHealthPermission(packageName, permissionName, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void revokeHealthPermission(String packageName, String permissionName, String reason) {
        try {
            this.mService.revokeHealthPermission(packageName, permissionName, reason, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void revokeAllHealthPermissions(String packageName, String reason) {
        try {
            this.mService.revokeAllHealthPermissions(packageName, reason, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public List<String> getGrantedHealthPermissions(String packageName) {
        try {
            return this.mService.getGrantedHealthPermissions(packageName, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public Instant getHealthDataHistoricalAccessStartDate(String packageName) {
        try {
            long dateMilli = this.mService.getHistoricalAccessStartDateInMilliseconds(packageName, this.mContext.getUser());
            if (dateMilli == -1L) {
                return null;
            }
            return Instant.ofEpochMilli(dateMilli);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void insertRecords(final List<Record> records, final Executor executor, final OutcomeReceiver<InsertRecordsResponse, HealthConnectException> callback) {
        Objects.requireNonNull(records);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            records.forEach(record -> record.getMetadata().setId(""));
            List<RecordInternal<?>> recordInternals = records.stream().map(Record::toRecordInternal).collect(Collectors.toList());
            this.mService.insertRecords(this.mContext.getAttributionSource(), new RecordsParcel(recordInternals), new IInsertRecordsResponseCallback.Stub(){

                @Override
                public void onResult(InsertRecordsResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(new InsertRecordsResponse(HealthConnectManager.this.getRecordsWithUids(records, parcel.getUids()))));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T> void aggregate(AggregateRecordsRequest<T> request, final Executor executor, final OutcomeReceiver<AggregateRecordsResponse<T>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.aggregateRecords(this.mContext.getAttributionSource(), new AggregateDataRequestParcel(request), new IAggregateRecordsResponseCallback.Stub(){

                @Override
                public void onResult(AggregateDataResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onResult(parcel.getAggregateDataResponse()));
                    }
                    catch (Exception exception) {
                        callback.onError(new HealthConnectException(2));
                    }
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException classCastException) {
            this.returnError(executor, new HealthConnectExceptionParcel(new HealthConnectException(2)), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T> void aggregateGroupByDuration(AggregateRecordsRequest<T> request, Duration duration, final Executor executor, final OutcomeReceiver<List<AggregateRecordsGroupedByDurationResponse<T>>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(duration);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.aggregateRecords(this.mContext.getAttributionSource(), new AggregateDataRequestParcel(request, duration), new IAggregateRecordsResponseCallback.Stub(){

                @Override
                public void onResult(AggregateDataResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    ArrayList result = new ArrayList();
                    for (AggregateRecordsGroupedByDurationResponse<?> aggregateRecordsGroupedByDurationResponse : parcel.getAggregateDataResponseGroupedByDuration()) {
                        result.add(aggregateRecordsGroupedByDurationResponse);
                    }
                    executor.execute(() -> callback.onResult(result));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException classCastException) {
            this.returnError(executor, new HealthConnectExceptionParcel(new HealthConnectException(2)), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T> void aggregateGroupByPeriod(AggregateRecordsRequest<T> request, Period period, final Executor executor, final OutcomeReceiver<List<AggregateRecordsGroupedByPeriodResponse<T>>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(period);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.aggregateRecords(this.mContext.getAttributionSource(), new AggregateDataRequestParcel(request, period), new IAggregateRecordsResponseCallback.Stub(){

                @Override
                public void onResult(AggregateDataResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    ArrayList result = new ArrayList();
                    for (AggregateRecordsGroupedByPeriodResponse<?> aggregateRecordsGroupedByPeriodResponse : parcel.getAggregateDataResponseGroupedByPeriod()) {
                        result.add(aggregateRecordsGroupedByPeriodResponse);
                    }
                    executor.execute(() -> callback.onResult(result));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException classCastException) {
            this.returnError(executor, new HealthConnectExceptionParcel(new HealthConnectException(2)), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void deleteRecords(DeleteUsingFiltersRequest request, final Executor executor, final OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.deleteUsingFilters(this.mContext.getAttributionSource(), new DeleteUsingFiltersRequestParcel(request), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void deleteRecords(List<RecordIdFilter> recordIds, final Executor executor, final OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(recordIds);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (recordIds.isEmpty()) {
            throw new IllegalArgumentException("record ids can't be empty");
        }
        try {
            this.mService.deleteUsingFiltersForSelf(this.mContext.getAttributionSource(), new DeleteUsingFiltersRequestParcel(new RecordIdFiltersParcel(recordIds), this.mContext.getPackageName()), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void deleteRecords(Class<? extends Record> recordType, TimeRangeFilter timeRangeFilter, final Executor executor, final OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(recordType);
        Objects.requireNonNull(timeRangeFilter);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.deleteUsingFiltersForSelf(this.mContext.getAttributionSource(), new DeleteUsingFiltersRequestParcel(new DeleteUsingFiltersRequest.Builder().addDataOrigin(new DataOrigin.Builder().setPackageName(this.mContext.getPackageName()).build()).addRecordType(recordType).setTimeRangeFilter(timeRangeFilter).build()), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void getChangeLogs(ChangeLogsRequest changeLogsRequest, final Executor executor, final OutcomeReceiver<ChangeLogsResponse, HealthConnectException> callback) {
        Objects.requireNonNull(changeLogsRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getChangeLogs(this.mContext.getAttributionSource(), changeLogsRequest, new IChangeLogsResponseCallback.Stub(){

                @Override
                public void onResult(ChangeLogsResponse parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException invalidArgumentException) {
            callback.onError(new HealthConnectException(3, invalidArgumentException.getMessage()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getChangeLogToken(ChangeLogTokenRequest request, final Executor executor, final OutcomeReceiver<ChangeLogTokenResponse, HealthConnectException> callback) {
        try {
            this.mService.getChangeLogToken(this.mContext.getAttributionSource(), request, new IGetChangeLogTokenCallback.Stub(){

                @Override
                public void onResult(ChangeLogTokenResponse parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void fetchDataOriginsPriorityOrder(int dataCategory, final Executor executor, final OutcomeReceiver<FetchDataOriginsPriorityOrderResponse, HealthConnectException> callback) {
        try {
            this.mService.getCurrentPriority(this.mContext.getPackageName(), dataCategory, new IGetPriorityResponseCallback.Stub(){

                @Override
                public void onResult(GetPriorityResponseParcel response) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(response.getPriorityResponse()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void updateDataOriginPriorityOrder(UpdateDataOriginPriorityOrderRequest request, final Executor executor, final OutcomeReceiver<Void, HealthConnectException> callback) {
        try {
            this.mService.updatePriority(this.mContext.getPackageName(), new UpdatePriorityRequestParcel(request), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryAllRecordTypesInfo(final Executor executor, final OutcomeReceiver<Map<Class<? extends Record>, RecordTypeInfoResponse>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryAllRecordTypesInfo(new IRecordTypeInfoResponseCallback.Stub(){

                @Override
                public void onResult(RecordTypeInfoResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel.getRecordTypeInfoResponses()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public int getRecordRetentionPeriodInDays() {
        try {
            return this.mService.getRecordRetentionPeriodInDays(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void setRecordRetentionPeriodInDays(int days, final Executor executor, final OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (days < 0 || days > 7300) {
            throw new IllegalArgumentException("days should be between 0 and 7300");
        }
        try {
            this.mService.setRecordRetentionPeriodInDays(days, this.mContext.getUser(), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryAccessLogs(final Executor executor, final OutcomeReceiver<List<AccessLog>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryAccessLogs(this.mContext.getPackageName(), new IAccessLogsResponseCallback.Stub(){

                @Override
                public void onResult(AccessLogsResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel.getAccessLogs()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T extends Record> void readRecords(ReadRecordsRequest<T> request, Executor executor, OutcomeReceiver<ReadRecordsResponse<T>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.readRecords(this.mContext.getAttributionSource(), request.toReadRecordsRequestParcel(), this.getReadCallback(executor, callback));
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void updateRecords(List<Record> records, final Executor executor, final OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(records);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            List<RecordInternal<?>> recordInternals = records.stream().map(Record::toRecordInternal).collect(Collectors.toList());
            for (RecordInternal recordInternal : recordInternals) {
                if (recordInternal.getClientRecordId() != null && !recordInternal.getClientRecordId().isEmpty() || recordInternal.getUuid() != null) continue;
                throw new IllegalArgumentException("At least one of the records is missing both ClientRecordID and UUID. RecordType of the input: " + recordInternal.getRecordType());
            }
            this.mService.updateRecords(this.mContext.getAttributionSource(), new RecordsParcel(recordInternals), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    Binder.clearCallingIdentity();
                    callback.onError(exception.getHealthConnectException());
                }
            });
        }
        catch (ArithmeticException | ClassCastException | IllegalArgumentException invalidArgumentException) {
            throw new IllegalArgumentException(invalidArgumentException);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void getContributorApplicationsInfo(final Executor executor, final OutcomeReceiver<ApplicationInfoResponse, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getContributorApplicationsInfo(new IApplicationInfoResponseCallback.Stub(){

                @Override
                public void onResult(ApplicationInfoResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(new ApplicationInfoResponse(parcel.getAppInfoList())));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STAGE_HEALTH_CONNECT_REMOTE_DATA")
    public void stageAllHealthConnectRemoteData(Map<String, ParcelFileDescriptor> pfdsByFileName, final Executor executor, final OutcomeReceiver<Void, StageRemoteDataException> callback) throws NullPointerException {
        Objects.requireNonNull(pfdsByFileName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.stageAllHealthConnectRemoteData(new StageRemoteDataRequest(pfdsByFileName), this.mContext.getUser(), new IDataStagingFinishedCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(StageRemoteDataException stageRemoteDataException) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onError(stageRemoteDataException));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getAllDataForBackup(Map<String, ParcelFileDescriptor> pfdsByFileName) {
        Objects.requireNonNull(pfdsByFileName);
        try {
            this.mService.getAllDataForBackup(new StageRemoteDataRequest(pfdsByFileName), this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Set<String> getAllBackupFileNames(boolean forDeviceToDevice) {
        try {
            return this.mService.getAllBackupFileNames(forDeviceToDevice).getFileNames();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteAllStagedRemoteData() throws NullPointerException {
        try {
            this.mService.deleteAllStagedRemoteData(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STAGE_HEALTH_CONNECT_REMOTE_DATA")
    public void updateDataDownloadState(int downloadState) {
        try {
            this.mService.updateDataDownloadState(downloadState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void getHealthConnectMigrationUiState(final Executor executor, final OutcomeReceiver<HealthConnectMigrationUiState, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getHealthConnectMigrationUiState(new IGetHealthConnectMigrationUiStateCallback.Stub(){

                @Override
                public void onResult(HealthConnectMigrationUiState migrationUiState) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(migrationUiState));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onError(exception.getHealthConnectException()));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_HEALTH_DATA", "android.permission.MIGRATE_HEALTH_CONNECT_DATA"})
    public void getHealthConnectDataState(final Executor executor, final OutcomeReceiver<HealthConnectDataState, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getHealthConnectDataState(new IGetHealthConnectDataStateCallback.Stub(){

                @Override
                public void onResult(HealthConnectDataState healthConnectDataState) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(healthConnectDataState));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onError(exception.getHealthConnectException()));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryActivityDates(List<Class<? extends Record>> recordTypes, final Executor executor, final OutcomeReceiver<List<LocalDate>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Objects.requireNonNull(recordTypes);
        if (recordTypes.isEmpty()) {
            throw new IllegalArgumentException("Record types list can not be empty");
        }
        try {
            this.mService.getActivityDates(new ActivityDatesRequestParcel(recordTypes), new IActivityDatesResponseCallback.Stub(){

                @Override
                public void onResult(ActivityDatesResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel.getDates()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException exception) {
            exception.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void startMigration(Executor executor, OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.startMigration(this.mContext.getPackageName(), HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void finishMigration(Executor executor, OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.finishMigration(this.mContext.getPackageName(), HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void writeMigrationData(List<MigrationEntity> entities, Executor executor, OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(entities);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.writeMigrationData(this.mContext.getPackageName(), new MigrationEntityParcel(entities), HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void insertMinDataMigrationSdkExtensionVersion(int requiredSdkExtension, Executor executor, OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.insertMinDataMigrationSdkExtensionVersion(this.mContext.getPackageName(), requiredSdkExtension, HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private <T extends Record> IReadRecordsResponseCallback.Stub getReadCallback(final Executor executor, final OutcomeReceiver<ReadRecordsResponse<T>, HealthConnectException> callback) {
        return new IReadRecordsResponseCallback.Stub(){

            @Override
            public void onResult(ReadRecordsResponseParcel parcel) {
                Binder.clearCallingIdentity();
                try {
                    List<Record> externalRecords = HealthConnectManager.this.mInternalExternalRecordConverter.getExternalRecords(parcel.getRecordsParcel().getRecords());
                    executor.execute(() -> callback.onResult(new ReadRecordsResponse(externalRecords, parcel.getPageToken())));
                }
                catch (ClassCastException castException) {
                    HealthConnectException healthConnectException = new HealthConnectException(2, castException.getMessage());
                    HealthConnectManager.this.returnError(executor, new HealthConnectExceptionParcel(healthConnectException), callback);
                }
            }

            @Override
            public void onError(HealthConnectExceptionParcel exception) {
                HealthConnectManager.this.returnError(executor, exception, callback);
            }
        };
    }

    private List<Record> getRecordsWithUids(List<Record> records, List<String> uids) {
        int i = 0;
        for (Record record : records) {
            record.getMetadata().setId(uids.get(i++));
        }
        return records;
    }

    private void returnError(Executor executor, HealthConnectExceptionParcel exception, OutcomeReceiver<?, HealthConnectException> callback) {
        Binder.clearCallingIdentity();
        executor.execute(() -> callback.onError(exception.getHealthConnectException()));
    }

    @SystemApi
    public static boolean isHealthPermission(Context context, String permission2) {
        if (!permission2.startsWith(HEALTH_PERMISSION_PREFIX)) {
            return false;
        }
        return HealthConnectManager.getHealthPermissions(context).contains(permission2);
    }

    @SystemApi
    public static Set<String> getHealthPermissions(Context context) {
        PackageInfo packageInfo;
        if (sHealthPermissions != null) {
            return sHealthPermissions;
        }
        try {
            PackageManager pm = context.getApplicationContext().getPackageManager();
            PermissionGroupInfo permGroupInfo = pm.getPermissionGroupInfo("android.permission-group.HEALTH", 0);
            packageInfo = pm.getPackageInfo(permGroupInfo.packageName, PackageManager.PackageInfoFlags.of(4096L));
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e(TAG, "Health permission group or HC package not found", ex);
            sHealthPermissions = Collections.emptySet();
            return sHealthPermissions;
        }
        HashSet<String> permissions = new HashSet<String>();
        for (PermissionInfo perm : packageInfo.permissions) {
            if (!"android.permission-group.HEALTH".equals(perm.group)) continue;
            permissions.add(perm.name);
        }
        sHealthPermissions = Collections.unmodifiableSet(permissions);
        return sHealthPermissions;
    }

    private static IMigrationCallback wrapMigrationCallback(final Executor executor, final OutcomeReceiver<Void, MigrationException> callback) {
        return new IMigrationCallback.Stub(){

            @Override
            public void onSuccess() {
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onResult(null));
            }

            @Override
            public void onError(MigrationException exception) {
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onError(exception));
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataDownloadState {
    }
}

