/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.TimeRangeFilter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class LocalTimeRangeFilter
implements TimeRangeFilter {
    private final LocalDateTime mLocalStartTime;
    private final LocalDateTime mLocalEndTime;

    private LocalTimeRangeFilter(LocalDateTime localStartTime, LocalDateTime localEndTime) {
        if (localStartTime == null && localEndTime == null) {
            throw new IllegalArgumentException("Both start time and end time cannot be null.");
        }
        if (localStartTime != null && localEndTime != null && !localEndTime.isAfter(localStartTime)) {
            throw new IllegalArgumentException("end time needs to be after start time.");
        }
        this.mLocalStartTime = localStartTime != null ? localStartTime : LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.MIN);
        this.mLocalEndTime = localEndTime != null ? localEndTime : LocalDateTime.ofInstant(Instant.now().plus(1L, ChronoUnit.DAYS), ZoneOffset.MAX);
    }

    public LocalDateTime getStartTime() {
        return this.mLocalStartTime;
    }

    public LocalDateTime getEndTime() {
        return this.mLocalEndTime;
    }

    public boolean isBounded() {
        return this.mLocalStartTime != null && this.mLocalEndTime != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mLocalStartTime.equals(((LocalTimeRangeFilter)o).mLocalStartTime)) {
            return false;
        }
        return this.mLocalEndTime.equals(((LocalTimeRangeFilter)o).mLocalEndTime);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.mLocalStartTime == null ? 0 : this.mLocalStartTime.hashCode());
        result = 31 * result + (this.mLocalEndTime == null ? 0 : this.mLocalEndTime.hashCode());
        return result;
    }

    public static class Builder {
        private LocalDateTime mLocalStartTime;
        private LocalDateTime mLocalEndTime;

        public Builder setStartTime(LocalDateTime localStartTime) {
            this.mLocalStartTime = localStartTime;
            return this;
        }

        public Builder setEndTime(LocalDateTime localEndTime) {
            this.mLocalEndTime = localEndTime;
            return this;
        }

        public LocalTimeRangeFilter build() {
            return new LocalTimeRangeFilter(this.mLocalStartTime, this.mLocalEndTime);
        }
    }
}

